/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.icpc2010.manager;

import java.lang.reflect.Constructor;
import java.util.concurrent.TimeoutException;
import jp.ac.nii.icpc2010.manager.OptionsManager;
import jp.ac.nii.icpc2010.manager.PlayerInitProcess;
import jp.ac.nii.icpc2010.manager.PlayerRunProcess;
import jp.ac.nii.icpc2010.players.AbstractPlayer;
import jp.ac.nii.icpc2010.players.Player;
import jp.ac.nii.icpc2010.playfield.FieldDirection;
import jp.ac.nii.icpc2010.playfield.RefPlayField;

public class TimeKeeper {
    public FieldDirection getInput(Player player, long timeout) throws InterruptedException, TimeoutException {
        FieldDirection[] buf = new FieldDirection[1];
        Thread playerThread = new Thread(new PlayerRunProcess(buf, player, System.currentTimeMillis() + timeout));
        long startTime = System.currentTimeMillis();
        playerThread.start();
        long waitTime = timeout + 1L - (System.currentTimeMillis() - startTime);
        while (waitTime > 0L) {
            try {
                playerThread.join(waitTime);
                waitTime = 0L;
            }
            catch (InterruptedException e) {
                waitTime = timeout + 1L - (System.currentTimeMillis() - startTime);
            }
        }
        FieldDirection input = buf[0];
        long endTime = System.currentTimeMillis();
        playerThread.stop();
        while (playerThread.isAlive()) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (endTime - startTime > timeout) {
            throw new TimeoutException();
        }
        return input;
    }

    public AbstractPlayer getInstance(Constructor<? extends AbstractPlayer> playerConstructor, int playerId, RefPlayField playField, long timeout, OptionsManager om) throws InterruptedException, TimeoutException {
        AbstractPlayer[] buf = new AbstractPlayer[1];
        Thread playerThread = new Thread(new PlayerInitProcess(buf, playerConstructor, playerId, playField, om));
        long startTime = System.currentTimeMillis();
        playerThread.start();
        long waitTime = timeout + 1L - (System.currentTimeMillis() - startTime);
        while (waitTime > 0L) {
            try {
                playerThread.join(waitTime);
                waitTime = 0L;
            }
            catch (InterruptedException e) {
                waitTime = timeout + 1L - (System.currentTimeMillis() - startTime);
            }
        }
        AbstractPlayer player = buf[0];
        long endTime = System.currentTimeMillis();
        playerThread.stop();
        while (playerThread.isAlive()) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (endTime - startTime > timeout) {
            throw new TimeoutException();
        }
        return player;
    }
}

