/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.icpc2010.players;

import jp.ac.nii.icpc2010.players.Player;
import jp.ac.nii.icpc2010.playfield.IPlayField;
import jp.ac.nii.icpc2010.playfield.RefPlayField;

public abstract class AbstractPlayer
implements Player {
    protected int id;
    protected IPlayField playField;
    private long finishTime;
    protected static final int OBJECT_FREE = 0;
    protected static final int OBJECT_WALL = 1;
    protected static final int OBJECT_COIN = 2;

    public AbstractPlayer(int id, IPlayField playField) {
        this.id = id;
        this.playField = playField;
    }

    public final void setFinishTime(long finishTime) {
        this.finishTime = finishTime;
    }

    public final void setPlayField(IPlayField playField) {
        this.playField = playField;
    }

    protected int getId() {
        return this.id;
    }

    protected IPlayField getPlayField() {
        return this.playField;
    }

    protected int getXOf(int id) {
        return this.playField.getTrons().get(id).getX();
    }

    protected int getYOf(int id) {
        return this.playField.getTrons().get(id).getY();
    }

    protected int getX() {
        return this.getXOf(this.id);
    }

    protected int getY() {
        return this.getYOf(this.id);
    }

    protected int getTrailIdOf(int id) {
        return RefPlayField.playerTrail(id);
    }

    protected int getTrailId() {
        return this.getTrailIdOf(this.id);
    }

    protected int getTronIdOf(int trail) {
        return RefPlayField.playerId(trail);
    }

    protected int getRemainingTime() {
        return (int)(this.finishTime - System.currentTimeMillis());
    }
}

