/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.icpc2010.players;

import java.util.List;
import jp.ac.nii.icpc2010.players.BasePlayer;
import jp.ac.nii.icpc2010.playfield.FieldDirection;
import jp.ac.nii.icpc2010.playfield.IPlayField;

public class CoinPlayer
extends BasePlayer {
    public CoinPlayer(int id, IPlayField playField) {
        super(id, playField);
    }

    @Override
    public FieldDirection getInput() {
        int r = 1;
        int[] target = null;
        while (target == null && r < 20) {
            target = this.squareScan(r);
            ++r;
        }
        if (target != null) {
            int curx = this.getX();
            int cury = this.getY();
            int xdiff = target[0] - curx;
            int ydiff = target[1] - cury;
            FieldDirection goalDir = Math.abs(xdiff) > Math.abs(ydiff) ? (xdiff < 0 ? FieldDirection.Left : FieldDirection.Right) : (ydiff < 0 ? FieldDirection.Up : FieldDirection.Down);
            if (this.getSafeDirs(curx, cury).contains((Object)goalDir)) {
                return goalDir;
            }
            return this.pickSafe();
        }
        return this.pickSafe();
    }

    FieldDirection pickSafe() {
        List<FieldDirection> safeDirs = this.getSafeDirs(this.getX(), this.getY());
        if (safeDirs.isEmpty()) {
            return FieldDirection.Up;
        }
        return safeDirs.get((int)(Math.random() * (double)safeDirs.size()));
    }

    private int adjustWidth(int coord) {
        while (coord < 0) {
            coord += this.getPlayField().getWidth();
        }
        return coord % this.getPlayField().getWidth();
    }

    private int adjustHeight(int coord) {
        while (coord < 0) {
            coord += this.getPlayField().getHeight();
        }
        return coord % this.getPlayField().getHeight();
    }

    public int[] squareScan(int radius) {
        int curx = this.getX();
        int cury = this.getY();
        int i = curx - radius;
        while (i < curx + radius) {
            int j = cury - radius;
            while (j < cury + radius) {
                int rj;
                int ri = this.adjustWidth(i);
                if (this.playField.getObjectAt(ri, rj = this.adjustHeight(j)) == 2) {
                    return new int[]{i, j};
                }
                ++j;
            }
            ++i;
        }
        return null;
    }
}

