/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.icpc2010.submission;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import jp.ac.nii.icpc2010.submission.SubmissionUtils;

public class SubmissionController {
    final String uploadsPath = "/Users/florian/Documents/phd/hg/code/sws/keikaku/res/services/portal/test/uploads";
    final String deployPath = "/Users/florian/Documents/phd/hg/code/sws/keikaku/res/services/portal/test/deploy";
    private final String jarFilePath = "/Users/florian/Documents/phd/hg/projects/icpc/jtron.jar";
    HashSet<String> teams = new HashSet();
    Map<String, HashSet<String>> submissions = new HashMap<String, HashSet<String>>();
    Map<String, HashSet<String>> finalSubmissions = new HashMap<String, HashSet<String>>();
    Map<String, String> movedFiles = new HashMap<String, String>();
    Map<String, String> teamToClassNames = new HashMap<String, String>();
    Map<String, String> finalSubmissionsReverse = new HashMap<String, String>();
    HashSet<String> javaFiles = new HashSet();

    public void start() {
        this.getTeamNames();
        this.getNewestSubmissions();
        this.deploySubmissions();
        this.analyzeSubmissionLog();
        this.createPackageStructure();
        this.compileFiles();
        this.runTournament();
        this.closeLogFile();
    }

    private void analyzeSubmissionLog() {
        this.debug("Verfying submission log...");
        String logFile = "/Users/florian/Documents/phd/hg/code/sws/keikaku/res/services/portal/test/uploads/log.xml";
        try {
            BufferedReader input = new BufferedReader(new FileReader(logFile));
            String line = null;
            HashMap teamToIPMap = new HashMap();
            block2: while ((line = input.readLine()) != null) {
                if (!line.contains("Team")) continue;
                String teamName = line.substring(line.indexOf(">") + 1, line.lastIndexOf("<"));
                if (!teamToIPMap.containsKey(teamName)) {
                    teamToIPMap.put(teamName, new HashSet());
                }
                while ((line = input.readLine()) != null) {
                    if (!line.contains("IP")) continue;
                    String ip = line.substring(line.indexOf(">") + 1, line.lastIndexOf("<"));
                    ((HashSet)teamToIPMap.get(teamName)).add(ip);
                    continue block2;
                }
            }
            for (String team : teamToIPMap.keySet()) {
                HashSet ips = (HashSet)teamToIPMap.get(team);
                if (ips.size() <= 1) continue;
                this.error("***********************************************", false);
                this.error("  WARNING: Team '" + team + "' has submission from multiple IPs!!", false);
                this.error("             IPs:", false);
                for (String ip : ips) {
                    this.error("                   " + ip, false);
                }
                this.error("  Please check the log file and contact the participants", false);
                this.error(" Log file: " + logFile, false);
                this.error("***********************************************", false);
            }
        }
        catch (Exception e) {
            this.error("Error while parsing log.xml: " + e.getMessage(), false);
            this.error("Please check submission log.xml manually! Path:" + logFile, false);
            this.error("Try to continue...", false);
        }
    }

    private void closeLogFile() {
        SubmissionUtils.closeLog();
    }

    private void runTournament() {
        String cmdLine = "";
        String classPath = "/Users/florian/Documents/phd/hg/code/sws/keikaku/res/services/portal/test/deploy";
        for (String team : this.teams) {
            cmdLine = String.valueOf(cmdLine) + "\"" + team.replaceAll(" ", "_") + "\" ";
            cmdLine = String.valueOf(cmdLine) + this.teamToClassNames.get(team) + " ";
        }
        String cmd = "java -classpath " + classPath + ":" + "/Users/florian/Documents/phd/hg/projects/icpc/jtron.jar" + " jp.ac.nii.icpc2010.tournament.TournamentRunner -players " + cmdLine;
        try {
            String line;
            this.debug("Invoking " + cmd);
            Process p = Runtime.getRuntime().exec(cmd);
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = input.readLine()) != null) {
                this.debug(line);
            }
            input.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void compileFiles() {
        this.debug("Compiling files...");
        for (String javaFile : this.javaFiles) {
            try {
                String cmd = this.compileFile(javaFile);
                if (new File(javaFile.replace(".java", ".class")).exists()) continue;
                this.error("Could not compile " + javaFile + ". Maybe a programming error in that java file? Command was: " + cmd);
            }
            catch (IOException e) {
                this.error("Error while compiling " + javaFile + ":" + e.getMessage());
            }
        }
    }

    private String compileFile(String javaFile) throws IOException {
        String line;
        this.debug("Compiling file " + javaFile);
        String cmd = "javac -classpath /Users/florian/Documents/phd/hg/projects/icpc/jtron.jar " + javaFile;
        Process p = Runtime.getRuntime().exec(cmd);
        BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
        while ((line = input.readLine()) != null) {
            this.debug(line);
        }
        input.close();
        return cmd;
    }

    private void createPackageStructure() {
        this.debug("Creating package structure...");
        for (String file : this.finalSubmissionsReverse.keySet()) {
            this.createPackageStructure(file, this.finalSubmissionsReverse.get(file));
        }
    }

    private void createPackageStructure(String filename, String teamname) {
        try {
            BufferedReader input = new BufferedReader(new FileReader(filename));
            try {
                String line = null;
                boolean found = false;
                while ((line = input.readLine()) != null) {
                    if (!line.contains("package")) continue;
                    LinkedList<String> directories = new LinkedList<String>();
                    found = true;
                    String sub = line.substring(line.indexOf(" ") + 1).replaceAll(";", "");
                    this.teamToClassNames.put(teamname, String.valueOf(sub) + "." + filename.substring(filename.lastIndexOf("/") + 1, filename.indexOf(".java")));
                    StringTokenizer st = new StringTokenizer(sub, ".");
                    while (st.hasMoreTokens()) {
                        directories.add(st.nextToken());
                    }
                    String currentPath = "/Users/florian/Documents/phd/hg/code/sws/keikaku/res/services/portal/test/deploy";
                    for (String _dir : directories) {
                        File dir = new File(currentPath = String.valueOf(currentPath) + File.separator + _dir);
                        if (dir.exists()) continue;
                        dir.mkdir();
                    }
                    File file = new File(filename);
                    file.renameTo(new File(new File(currentPath), file.getName()));
                    this.movedFiles.put(filename, String.valueOf(currentPath) + File.separator + file.getName());
                    this.javaFiles.add(String.valueOf(currentPath) + File.separator + file.getName());
                    break;
                }
                if (!found) {
                    this.teamToClassNames.put(teamname, filename.substring(filename.lastIndexOf("/") + 1, filename.indexOf(".java")));
                    this.movedFiles.put(filename, filename);
                    this.javaFiles.add(filename);
                    return;
                }
            }
            finally {
                input.close();
            }
        }
        catch (IOException ex) {
            this.error("Error in submission '" + filename + "':" + ex.getMessage());
            return;
        }
    }

    private void deploySubmissions() {
        File deploy = new File("/Users/florian/Documents/phd/hg/code/sws/keikaku/res/services/portal/test/deploy");
        if (!deploy.exists()) {
            this.debug("Creating directory " + deploy);
            deploy.mkdir();
        }
        for (String team : this.submissions.keySet()) {
            this.finalSubmissions.put(team, new HashSet());
            for (String file : this.submissions.get(team)) {
                String filename = file.substring(file.lastIndexOf("/") + 1);
                String toFileName = "/Users/florian/Documents/phd/hg/code/sws/keikaku/res/services/portal/test/deploy" + File.separator + filename;
                try {
                    SubmissionUtils.copy(file, toFileName);
                    this.finalSubmissions.get(team).add(toFileName);
                    this.finalSubmissionsReverse.put(toFileName, team);
                }
                catch (IOException e) {
                    this.error(e.getMessage());
                }
            }
        }
    }

    private void getTeamNames() {
        File dir = new File("/Users/florian/Documents/phd/hg/code/sws/keikaku/res/services/portal/test/uploads");
        this.debug("Checking submission folder...");
        String[] children = dir.list();
        if (children == null) {
            this.error("Could not find any submission. Is the path '/Users/florian/Documents/phd/hg/code/sws/keikaku/res/services/portal/test/uploads' correct?");
        } else {
            this.debug("Found " + children.length + " teams");
            int i = 0;
            while (i < children.length) {
                String filename = children[i];
                File f = new File("/Users/florian/Documents/phd/hg/code/sws/keikaku/res/services/portal/test/uploads/" + children[i]);
                if (f.isDirectory()) {
                    this.debug("Found team '" + filename + "'");
                    this.teams.add(filename);
                }
                ++i;
            }
        }
    }

    private void error(String string) {
        this.error(string, true);
    }

    private void error(String string, boolean terminate) {
        SubmissionUtils.error(string, this);
        if (terminate) {
            SubmissionUtils.error("Terminating application", this);
            System.exit(1);
        }
    }

    private void debug(String string) {
        SubmissionUtils.debug(string, this);
    }

    private void getNewestSubmissions() {
        for (String team : this.teams) {
            File dir = new File("/Users/florian/Documents/phd/hg/code/sws/keikaku/res/services/portal/test/uploads" + File.separator + team);
            String[] children = dir.list();
            if (children == null) {
                this.error("Team '" + team + "' has no submissions. Ignore this entry. ", false);
                continue;
            }
            int newest = 0;
            int i = 0;
            while (i < children.length) {
                try {
                    int n = Integer.parseInt(children[i]);
                    if (n > newest) {
                        newest = n;
                    }
                }
                catch (Exception e) {
                    this.error("Invalid entry in '" + team + "'");
                }
                ++i;
            }
            this.debug("Newest submission for team '" + team + "' seems to be " + newest);
            dir = new File("/Users/florian/Documents/phd/hg/code/sws/keikaku/res/services/portal/test/uploads" + File.separator + team + File.separator + newest);
            children = dir.list();
            if (children == null) {
                this.error("Team '" + team + "' has no submissions. Ignore this entry. ", false);
                continue;
            }
            HashSet<String> hs = new HashSet<String>();
            this.submissions.put(team, hs);
            this.debug("Team '" + team + "' has the following submission files in the newest submission:");
            int i2 = 0;
            while (i2 < children.length) {
                if (!children[i2].equals("log.xml") && !children[i2].endsWith("~")) {
                    this.debug("  " + children[i2]);
                    hs.add("/Users/florian/Documents/phd/hg/code/sws/keikaku/res/services/portal/test/uploads" + File.separator + team + File.separator + newest + File.separator + children[i2]);
                }
                ++i2;
            }
        }
    }

    public static void main(String[] args) {
        new SubmissionController().start();
    }
}

