package jp.ac.nii.icpc2010.tournament;

public class Player implements Comparable<Player> {
	private String team;
	private String playerClass;
	private double score;
	
	public Player(String name, String playerClass) {
		this.team = name;
		this.playerClass = playerClass;
	}
	
	public void setScore(double score) {
		this.score = score;
	}

	public int compareTo(Player p) {
		return Double.compare(score, p.score);
	}
	
	public String getPlayerClass() {
		return playerClass;
	}
	
	@Override
	public String toString() {
		return team+"("+playerClass+")";
	}
}
