/*-
 * Javoids -- Javoids is an asteroids based game (that look nothing like the original).
 * 
 * Copyright (C) 1999-2006 Patrick Mallette
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * I can be reached at parickmallette@rogers.com
 */
package javoids;

import static javoids.Health.DurationType.IMMORTAL;
import static javoids.ImageMap.Name.EXPLOSION1;
import static javoids.ImageMap.Name.NO_IMAGE;
import static javoids.Shapes.Shape.POINT;

/* Explosion------------------ */
/**
 * An explosion (currently an animated gif image)
 * @author mallette
 */
public final class Explosion extends ShieldedSprite
{
  /** This is the version used for serializing/deserializing (storing/retrieving) this object */
  private static final long  serialVersionUID = 1L;
  /** The maximum number of these sprites allowed in the game */
  protected final static int MAX_NUMBER       = 25;
  /** the sprite's maximum size */
  protected final static int MAX_SIZE         = 100;
  /** the sprite's minimum size */
  protected final static int MIN_SIZE         = 20;
  /** the sprite's default size */
  protected final static int DEFAULT_SIZE     = 100; // This should match the size of the image!

  /**
   * Constructor
   * @param parent the parent of this sprite
   * @param move the movement information
   * @param _size the size of the explosion
   */
  public Explosion(BasicSprite parent,Move move,int _size)
  {
    super(parent,new Health(1,Health.DEFAULT_DAMAGE_CAPACITY,Health.DEFAULT_DURATION,Health.DEFAULT_AGING_RATE * 2,IMMORTAL),new Move(move),null,_size,EXPLOSION1,Shapes.getAreas(POINT,_size,Explosion.MAX_SIZE),Shapes.getColors(POINT));
    this.setShape(POINT);
    this.setDisplayAreas(false);
  }

  /**
   * @return the maximum size
   */
  public int getMaximumSize()
  {
    return Explosion.MAX_SIZE;
  }

  /**
   * @return the minimum size
   */
  public int getMinimumSize()
  {
    return Explosion.MIN_SIZE;
  }

  /**
   * @return the default size
   */
  public int getDefaultSize()
  {
    return Explosion.DEFAULT_SIZE;
  }

  /**
   * @param _size the size to set the sprite's size to
   */
  /*
   * (non-Javadoc)
   * @see javoids.Sprite#setSize(int)
   */
  @Override
  public void setSize(int _size)
  {
    super.setSize(_size >= Explosion.MIN_SIZE ? _size <= Explosion.MAX_SIZE ? _size : Explosion.MAX_SIZE : Explosion.MIN_SIZE);
  }

  /**
   * @return the name of the image this sprite uses
   */
  /*
   * (non-Javadoc)
   * @see javoids.Sprite#getImageNumber()
   */
  @Override
  public ImageMap.Name getImageNumber()
  {
    return BasicSprite.getPacmanGame() ? NO_IMAGE : this.getOriginalImage();
  }
}
/* Explosion------------------ */
