/*-
 * Javoids -- Javoids is an asteroids based game (that look nothing like the original).
 * 
 * Copyright (C) 1999-2006 Patrick Mallette
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * I can be reached at parickmallette@rogers.com
 */
package javoids;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

/**
 * A splash screen (replace when JDK 1.6 is released).
 * @author mallette
 */
public class ProgressFrame extends JFrame
{
  /** This is the version used for serializing/deserializing (storing/retrieving) this object */
  private static final long serialVersionUID = 1L;
  /** the image to display for the splashscreen */
  transient private Image   image;
  /** a panel to hold the image */
  private JPanel            imagePanel;
  /** a progress bar to display what percent of the set-up is done */
  private JProgressBar      progressBar;

  /**
   * Constructor
   * @param title the title of the frame
   * @param _image the image to display as a splash screen
   * @param location the location of the splash screen
   * @param dimension the size of the splash screen
   */
  public ProgressFrame(String title,Image _image,Point location,Dimension dimension)
  {
    super(title);
    this.setUndecorated(true);
    System.out.printf(title);
    this.setLocation(location);
    this.setLayout(new BorderLayout());
    this.image = _image;
    this.imagePanel = new JPanel();
    this.progressBar = new JProgressBar();
    this.imagePanel.setPreferredSize(new Dimension(dimension));
    this.imagePanel.setMinimumSize(new Dimension(dimension));
    this.progressBar.setPreferredSize(new Dimension((int)dimension.getWidth(),2 * (int)this.progressBar.getPreferredSize().getHeight()));
    this.progressBar.setMinimumSize(new Dimension((int)dimension.getWidth(),_image.getHeight(this)));
    this.progressBar.setStringPainted(true);
    this.progressBar.setValue(0);
    this.add(this.imagePanel,BorderLayout.CENTER);
    this.add(this.progressBar,BorderLayout.SOUTH);
    this.pack();
  }

  /**
   * @param graphics the graphics context to use for drawing
   */
  /*
   * (non-Javadoc)
   * @see java.awt.Container#paint(java.awt.Graphics)
   */
  @Override
  public void paint(Graphics graphics)
  {
    super.paint(graphics);
    this.imagePanel.getGraphics().drawImage(this.image,0,0,this);
  }

  /**
   * @param graphics the graphics context to use for drawing
   */
  /*
   * (non-Javadoc)
   * @see javax.swing.JFrame#update(java.awt.Graphics)
   */
  @Override
  public void update(Graphics graphics)
  {
    this.paint(graphics);
  }

  /**
   * @return the image to be displayed
   */
  public Image getImage()
  {
    return this.image;
  }

  /**
   * set the image to display.
   * @param _image the image to be displayed
   */
  public void setImage(Image _image)
  {
    this.image = _image;
  }

  /**
   * @return the progress bar value (out of 0 to 100)
   */
  public int getValue()
  {
    return this.progressBar.getValue();
  }

  /**
   * @param value the progress bar value (out of 0 to 100)
   */
  public void setValue(int value)
  {
    this.progressBar.setValue(value);
  }

  /**
   * @param value the progress bar value's string
   */
  public void setString(String value)
  {
    this.progressBar.setString(value);
  }
}
