/*
 * Decompiled with CFR 0.152.
 */
package Objects;

import Animations.FallingDeadSprites;
import Objects.BasicEnemy;
import Objects.TurtelShell;
import SandBox.Mario;
import com.golden.gamedev.object.AnimatedSprite;
import com.golden.gamedev.object.Timer;

public class EnemyTurtle
extends AnimatedSprite
implements BasicEnemy {
    boolean PositiveX = true;
    Mario game;
    public int Gravity = 6;
    boolean Standing = true;
    public boolean Green = true;
    String Color;

    public EnemyTurtle(double x, double y, Mario g, boolean isGreen) {
        this.game = g;
        this.Color = "normal";
        if (isGreen) {
            this.setImages(this.game.bsLoader.getStoredImages("turtle"));
        } else {
            this.setImages(this.game.bsLoader.getStoredImages("EnemyTurtlePatrol"));
        }
        this.setLocation(x, y);
        this.setAnimationTimer(new Timer(300));
        this.setAnimate(true);
        this.setLoopAnim(true);
        this.setAnimationFrame(0, 1);
        this.setID(102);
        this.Green = isGreen;
    }

    public EnemyTurtle(double x, double y, Mario g, boolean isGreen, String color) {
        this.game = g;
        if (isGreen) {
            this.setImages(this.game.bsLoader.getStoredImages("turtledark"));
            this.Color = "dark";
        } else {
            this.setImages(this.game.bsLoader.getStoredImages("EnemyTurtlePatrol"));
        }
        this.setLocation(x, y);
        this.setAnimationTimer(new Timer(300));
        this.setAnimate(true);
        this.setLoopAnim(true);
        this.setAnimationFrame(0, 1);
        this.setID(102);
        this.Green = isGreen;
    }

    public void update(long l) {
        this.moveY(this.Gravity);
        if (this.PositiveX) {
            this.moveX(-1.0);
        } else {
            this.moveX(1.0);
        }
        super.update(l);
    }

    public void CollidedWithBrick_GoToLeft() {
        this.PositiveX = true;
        this.setAnimationFrame(0, 1);
    }

    public void CollidedWithBrick_GoToRight() {
        this.PositiveX = false;
        this.setAnimationFrame(2, 3);
    }

    public void MarioJumpedOnEnemy() {
        this.game.player.Jump(-8);
        this.game.EnemyGroup.add(new TurtelShell(this.getX(), this.getY() + 16.0, this.game, this.MariotoRight(), this.Standing, this.Green, this.Color));
        this.setActive(false);
    }

    public void KilledByFireBall() {
        this.game.parent.amitsAudioPlayer.smb_kick.play();
        if (this.Green) {
            if (this.Color.equals("normal")) {
                this.game.AnimationGroup.add(new FallingDeadSprites(this.getX(), this.getY(), this.game.bsLoader.getStoredImage("TurtelShell"), this.MariotoRight()));
            } else {
                this.game.AnimationGroup.add(new FallingDeadSprites(this.getX(), this.getY(), this.game.bsLoader.getStoredImage("TurtelShelldark"), this.MariotoRight()));
            }
        } else {
            this.game.AnimationGroup.add(new FallingDeadSprites(this.getX(), this.getY(), this.game.bsLoader.getStoredImage("TurtelShellRed"), this.MariotoRight()));
        }
        this.setActive(false);
    }

    public void bounce() {
    }

    public void setYloc(double d) {
        this.setY(d);
    }

    public void CollidedWithShell() {
    }

    public int getType() {
        return this.getID();
    }

    public void CollidedWithMovingShell() {
        this.KilledByFireBall();
    }

    public void OtherEnemyTouchedFromRight() {
        this.PositiveX = true;
        this.setAnimationFrame(0, 1);
    }

    public void OtherEnemyTouchedFromLeft() {
        this.PositiveX = false;
        this.setAnimationFrame(2, 3);
    }

    public void CollidedWithMarioFromTOLeft() {
        if (this.game.player.HasStar()) {
            this.KilledByFireBall();
        } else {
            this.game.player.Decerease();
        }
    }

    public void CollidedWithMarioTORight() {
        if (this.game.player.HasStar()) {
            this.KilledByFireBall();
        } else {
            this.game.player.Decerease();
        }
    }

    public void EnemyJumperOnMario() {
        if (this.game.player.HasStar()) {
            this.KilledByFireBall();
        } else {
            this.game.player.Decerease();
        }
    }

    public int Life() {
        return 0;
    }

    public void CollidedWithJumping_Brick() {
        this.game.parent.amitsAudioPlayer.smb_kick.play();
        this.game.EnemyGroup.add(new TurtelShell(this.getX(), this.getY() + 16.0, this.game, this.MariotoRight(), false, "Jump", this.Green));
        this.Standing = false;
        this.setActive(false);
    }

    public boolean MariotoRight() {
        boolean positive = !(this.game.player.getX() < this.getX());
        return positive;
    }
}

