/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.engine.graphics;

import com.golden.gamedev.engine.BaseGraphics;
import com.golden.gamedev.engine.graphics.WindowExitListener;
import com.golden.gamedev.util.ImageUtil;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.image.BufferStrategy;
import java.awt.image.VolatileImage;

public class WindowedMode
implements BaseGraphics {
    public static final GraphicsDevice DEVICE = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
    public static final GraphicsConfiguration CONFIG = DEVICE.getDefaultConfiguration();
    private Frame frame;
    private Canvas canvas;
    private Dimension size;
    private VolatileImage offscreen;
    private BufferStrategy strategy;
    private Graphics2D currentGraphics;

    public WindowedMode(Dimension d, boolean bufferstrategy) {
        this.size = d;
        this.frame = new Frame("Super Mario Bros.", CONFIG);
        try {
            this.frame.setIconImage(ImageUtil.getImage(WindowedMode.class.getResource("Icon.png"), 3));
        }
        catch (Exception e) {
            // empty catch block
        }
        this.frame.addWindowListener(WindowExitListener.getInstance());
        this.frame.setIgnoreRepaint(true);
        this.canvas = new Canvas(CONFIG);
        this.canvas.setIgnoreRepaint(true);
        this.canvas.setSize(this.size);
        this.frame.setVisible(true);
        Insets inset = this.frame.getInsets();
        this.frame.setVisible(false);
        this.frame.setSize(this.size.width + inset.left + inset.right, this.size.height + inset.top + inset.bottom);
        this.frame.add(this.canvas);
        this.frame.pack();
        this.frame.setLayout(null);
        this.frame.setLocationRelativeTo(null);
        if (this.frame.getX() < 0) {
            this.frame.setLocation(0, this.frame.getY());
        }
        if (this.frame.getY() < 0) {
            this.frame.setLocation(this.frame.getX(), 0);
        }
        this.frame.setVisible(true);
        if (bufferstrategy) {
            bufferstrategy = this.createBufferStrategy();
        }
        if (!bufferstrategy) {
            this.createBackBuffer();
        }
        this.canvas.requestFocus();
    }

    private boolean createBufferStrategy() {
        boolean bufferCreated;
        int num = 0;
        do {
            bufferCreated = true;
            try {
                this.canvas.createBufferStrategy(2);
            }
            catch (Exception e) {
                bufferCreated = false;
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException excp) {
                    // empty catch block
                }
            }
        } while (num++ <= 5 && !bufferCreated);
        if (!bufferCreated) {
            System.err.println("BufferStrategy is not available!");
            return false;
        }
        while (this.strategy == null) {
            try {
                this.strategy = this.canvas.getBufferStrategy();
            }
            catch (Exception e) {}
        }
        Graphics2D gfx = null;
        while (gfx == null) {
            try {
                gfx = this.getBackBuffer();
            }
            catch (Exception e) {}
        }
        return true;
    }

    private void createBackBuffer() {
        if (this.offscreen != null) {
            this.offscreen.flush();
            this.offscreen = null;
        }
        this.offscreen = CONFIG.createCompatibleVolatileImage(this.size.width, this.size.height);
    }

    public Graphics2D getBackBuffer() {
        if (this.currentGraphics == null) {
            if (this.strategy == null) {
                if (this.offscreen.validate(CONFIG) == 2) {
                    this.createBackBuffer();
                }
                this.currentGraphics = this.offscreen.createGraphics();
            } else {
                this.currentGraphics = (Graphics2D)this.strategy.getDrawGraphics();
            }
        }
        return this.currentGraphics;
    }

    public boolean flip() {
        this.currentGraphics.dispose();
        this.currentGraphics = null;
        if (this.strategy == null) {
            this.canvas.getGraphics().drawImage(this.offscreen, 0, 0, null);
            Toolkit.getDefaultToolkit().sync();
            return !this.offscreen.contentsLost();
        }
        this.strategy.show();
        Toolkit.getDefaultToolkit().sync();
        return !this.strategy.contentsLost();
    }

    public void cleanup() {
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        try {
            if (this.frame != null) {
                this.frame.dispose();
            }
        }
        catch (Exception e) {
            System.err.println("ERROR: Shutting down graphics context " + e);
            System.exit(-1);
        }
    }

    public Dimension getSize() {
        return this.size;
    }

    public Component getComponent() {
        return this.canvas;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public boolean isBufferStrategy() {
        return this.strategy != null;
    }

    public String getGraphicsDescription() {
        return "Windowed Mode [" + this.getSize().width + "x" + this.getSize().height + "]" + (this.strategy != null ? " with BufferStrategy" : "");
    }

    public void setWindowTitle(String st) {
        this.frame.setTitle(st);
    }

    public String getWindowTitle() {
        return this.frame.getTitle();
    }

    public void setWindowIcon(Image icon) {
        try {
            this.frame.setIconImage(icon);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Image getWindowIcon() {
        return this.frame.getIconImage();
    }
}

