/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.object.background;

import com.golden.gamedev.object.Background;
import java.awt.Graphics2D;

public class ParallaxBackground
extends Background {
    private static final long serialVersionUID = 8282072812030049762L;
    private Background[] stack;
    private int total;

    public ParallaxBackground(Background[] stack) {
        this.stack = stack;
        this.total = stack.length;
        this.normalizedView();
    }

    private void normalizedView() {
        for (int i = 0; i < this.total; ++i) {
            if (this.stack[i].getWidth() > this.getWidth()) {
                this.setSize(this.stack[i].getWidth(), this.getHeight());
            }
            if (this.stack[i].getHeight() <= this.getHeight()) continue;
            this.setSize(this.getWidth(), this.stack[i].getHeight());
        }
    }

    public void setLocation(double xb, double yb) {
        super.setLocation(xb, yb);
        for (int i = 0; i < this.total; ++i) {
            this.stack[i].setLocation(this.getX() * (double)(this.stack[i].getWidth() - this.getClip().width) / (double)(this.getWidth() - this.getClip().width), this.getY() * (double)(this.stack[i].getHeight() - this.getClip().height) / (double)(this.getHeight() - this.getClip().height));
        }
    }

    public void update(long elapsedTime) {
        for (int i = 0; i < this.total; ++i) {
            this.stack[i].update(elapsedTime);
        }
    }

    public void render(Graphics2D g) {
        for (int i = 0; i < this.total; ++i) {
            this.stack[i].render(g);
        }
    }

    public Background[] getParallaxBackground() {
        return this.stack;
    }

    public void setParallaxBackground(Background[] stack) {
        this.stack = stack;
        this.total = stack.length;
        this.normalizedView();
    }
}

