/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.object.background.abstraction;

import com.golden.gamedev.object.Background;
import java.awt.Graphics2D;
import java.awt.Point;

public abstract class AbstractTileBackground
extends Background {
    private int tileWidth;
    private int tileHeight;
    private int tileX;
    private int tileY;
    private int offsetX;
    private int offsetY;
    private int horiz;
    private int vert;
    private Point point = new Point();

    public AbstractTileBackground(int horiz, int vert, int tileWidth, int tileHeight) {
        super(horiz * tileWidth, vert * tileHeight);
        this.tileWidth = tileWidth;
        this.tileHeight = tileHeight;
        this.horiz = horiz;
        this.vert = vert;
        this.tileY = 0;
        this.tileX = 0;
        this.offsetY = 0;
        this.offsetX = 0;
    }

    public void render(Graphics2D g, int xbg, int ybg, int x, int y, int w, int h) {
        int x1 = 0;
        int y1 = 0;
        int x2 = x + w;
        int y2 = y + h;
        int xTile = 0;
        int yTile = this.tileY;
        for (y1 = y - this.offsetY; y1 < y2; y1 += this.tileHeight) {
            xTile = this.tileX;
            for (x1 = x - this.offsetX; x1 < x2; x1 += this.tileWidth) {
                this.renderTile(g, xTile, yTile, x1, y1);
                ++xTile;
            }
            ++yTile;
        }
    }

    public abstract void renderTile(Graphics2D var1, int var2, int var3, int var4, int var5);

    public void setLocation(double xb, double yb) {
        int oldx = (int)this.getX();
        int oldy = (int)this.getY();
        super.setLocation(xb, yb);
        int x = (int)this.getX();
        int y = (int)this.getY();
        if (x == oldx && y == oldy) {
            return;
        }
        this.tileX = x / this.tileWidth;
        this.tileY = y / this.tileHeight;
        this.offsetX = x % this.tileWidth;
        this.offsetY = y % this.tileHeight;
    }

    public void setTileLocation(int xs, int ys) {
        this.setLocation(xs * this.tileWidth, ys * this.tileHeight);
    }

    public int getTileX() {
        return this.tileX;
    }

    public int getTileY() {
        return this.tileY;
    }

    public Point getTileAt(double screenX, double screenY) {
        if (screenX < (double)this.getClip().x || screenX > (double)(this.getClip().x + this.getClip().width) || screenY < (double)this.getClip().y || screenY > (double)(this.getClip().y + this.getClip().height)) {
            return null;
        }
        this.point.x = (int)(this.getX() + screenX - (double)this.getClip().x) / this.tileWidth;
        this.point.y = (int)(this.getY() + screenY - (double)this.getClip().y) / this.tileHeight;
        return this.point;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public int getTileWidth() {
        return this.tileWidth;
    }

    public int getTileHeight() {
        return this.tileHeight;
    }

    protected void setTileSize(int tileWidth, int tileHeight) {
        this.tileWidth = tileWidth;
        this.tileHeight = tileHeight;
        super.setSize(this.horiz * this.getTileWidth(), this.vert * this.getTileHeight());
    }

    public int getTotalHorizontalTiles() {
        return this.horiz;
    }

    public int getTotalVerticalTiles() {
        return this.vert;
    }

    public void setSize(int horiz, int vert) {
        this.horiz = horiz;
        this.vert = vert;
        super.setSize(horiz * this.getTileWidth(), vert * this.getTileHeight());
    }
}

