/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.util;

import com.golden.gamedev.util.ImageUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;

public class FontUtil {
    private FontUtil() {
    }

    public static Font createTrueTypeFont(URL url, int style, float size) {
        Font f = null;
        try {
            f = Font.createFont(0, url.openStream());
        }
        catch (IOException e) {
            System.err.println("ERROR: " + url + " is not found or can not be read");
            f = new Font("Verdana", 0, 0);
        }
        catch (FontFormatException e) {
            System.err.println("ERROR: " + url + " is not a valid true type font");
            f = new Font("Verdana", 0, 0);
        }
        return f.deriveFont(style, size);
    }

    public static BufferedImage createBitmapFont(Font f, Color col) {
        Graphics2D g = ImageUtil.createImage(1, 1).createGraphics();
        FontMetrics fm = g.getFontMetrics(f);
        g.dispose();
        byte[] bytes = new byte[95];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)(32 + i);
        }
        String st = new String(bytes);
        int w = fm.stringWidth(st);
        int h = fm.getHeight();
        int len = st.length();
        int x = 0;
        int y = h - fm.getDescent() + 1;
        Color delim = Color.GREEN;
        if (delim.equals(col)) {
            delim = Color.YELLOW;
        }
        BufferedImage bitmap = ImageUtil.createImage(w, h, 2);
        g = bitmap.createGraphics();
        g.setFont(f);
        for (int i = 0; i < len; ++i) {
            char c = st.charAt(i);
            g.setColor(delim);
            g.drawLine(x, 0, x, 0);
            g.setColor(col);
            g.drawString(String.valueOf(c), x, y);
            x += fm.charWidth(c);
        }
        g.dispose();
        return bitmap;
    }
}

