/*
 * Decompiled with CFR 0.152.
 */
package AmitsMusicPlayer;

import AmitsMusicPlayer.AudioFilesInterface;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;

public class SimpleMusicFile
implements LineListener,
AudioFilesInterface {
    protected final String AudioFileName;
    private URL audioFile;
    protected AudioInputStream audioStream;
    private AudioFormat format;
    protected DataLine.Info info;
    private Clip audioClip;
    private boolean repeatMusic = true;

    public SimpleMusicFile(String AudioFileName) {
        this.AudioFileName = AudioFileName;
    }

    public void intitalize() {
        try {
            System.out.println("Loading Sound file \"" + this.AudioFileName + "\"");
            this.audioFile = this.getClass().getResource(this.AudioFileName);
            this.audioStream = AudioSystem.getAudioInputStream(this.audioFile);
            this.format = this.audioStream.getFormat();
            this.info = new DataLine.Info(Clip.class, this.format);
            this.audioClip = (Clip)AudioSystem.getLine(this.info);
            this.audioClip.loop(-1);
            this.audioClip.addLineListener(this);
            this.audioClip.open(this.audioStream);
        }
        catch (LineUnavailableException ex) {
            Logger.getLogger(SimpleMusicFile.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println("sound file not found \"" + this.AudioFileName + "\"");
        }
        catch (UnsupportedAudioFileException ex) {
            Logger.getLogger(SimpleMusicFile.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println("sound file not found \"" + this.AudioFileName + "\"");
        }
        catch (IOException ex) {
            Logger.getLogger(SimpleMusicFile.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println("sound file not found \"" + this.AudioFileName + "\"");
        }
    }

    public void update(LineEvent event) {
        if (LineEvent.Type.START != event.getType() && LineEvent.Type.STOP == event.getType() && this.repeatMusic) {
            this.audioClip.setFramePosition(0);
            this.audioClip.start();
        }
    }

    public void play() {
        if (!this.audioClip.isRunning()) {
            this.audioClip.setFramePosition(0);
            this.audioClip.start();
            this.repeatMusic = true;
        }
    }

    public void stop() {
        this.repeatMusic = false;
        this.audioClip.stop();
    }
}

