/*
 * Decompiled with CFR 0.152.
 */
package Collusion;

import Animations.AnotherCastleMessage;
import Animations.FireWorks;
import Animations.FlagUp;
import Animations.JumpingGuy;
import Animations.Victory;
import Objects.Player;
import SandBox.Mario;
import com.golden.gamedev.object.Sprite;
import com.golden.gamedev.object.collision.BasicCollisionGroup;
import java.awt.Point;
import java.util.Random;

public class Player_CheckPoint
extends BasicCollisionGroup {
    Mario game;

    public Player_CheckPoint(Mario f) {
        this.game = f;
    }

    public void collided(Sprite player, Sprite checkpoint) {
        Player p = (Player)player;
        String side = "?";
        Point player_Center = new Point((int)player.getX() + player.getWidth(), (int)player.getY() + player.getHeight());
        Point checkpoint_Center = new Point((int)checkpoint.getX() + checkpoint.getWidth(), (int)checkpoint.getY() + checkpoint.getHeight());
        int angle = (int)Math.toDegrees(Math.atan2(player_Center.getY() - checkpoint_Center.getY(), player_Center.getX() - checkpoint_Center.getX()));
        this.game.setDegree(angle);
        switch (checkpoint.getID()) {
            default: {
                break;
            }
            case 23: {
                FlagUp flagUp = new FlagUp(this.game.bsLoader.getStoredImages("FlagUp"), (int)checkpoint.getX() - 32, 288);
                this.game.BackGroundSpriteGroup.add(flagUp);
                Random r = new Random();
                if (r.nextBoolean()) {
                    this.game.AnimationGroup.add(new FireWorks((int)checkpoint.getX(), (int)checkpoint.getY(), this.game));
                }
                this.game.LevelComplete(checkpoint);
                this.game.AnimationGroup.add(new Victory(this.game, (int)checkpoint.getX(), (int)checkpoint.getY()));
                p.setActive(false);
                break;
            }
            case 16: {
                this.game.boss.BadGameGlitch();
                this.game.VolitileGroup.add(new AnotherCastleMessage(this.game.bsLoader.getStoredImages("AnotherCastleMessage"), checkpoint.getX() - 224.0, checkpoint.getY() - 192.0, this.game));
                p.setX(checkpoint.getX() - (double)p.getWidth());
                p.StopSpeed();
                p.NoControlling();
                p.ShowThumbs();
                p.StopMoveForward();
                this.game.AnimationGroup.add(new JumpingGuy((int)checkpoint.getX(), (int)checkpoint.getY(), this.game));
                this.game.LevelComplete(checkpoint, 200);
                checkpoint.setActive(false);
                break;
            }
            case 24: {
                if (p.speed <= 2) break;
                this.game.MarioGoingInsidePumpToRight();
                this.game.LevelComplete(checkpoint);
                this.game.player.setActive(false);
                this.game.parent.amitsAudioPlayer.stopAllMusic();
                this.game.parent.amitsAudioPlayer.smb_pipe.play();
                p.setActive(false);
                break;
            }
            case 25: {
                if (!(p.getX() < checkpoint.getX() + 10.0) || !(p.getX() > checkpoint.getX() - 10.0) || !p.KeyPressedDown()) break;
                this.game.MarioGoingDownAnimation();
                this.game.LevelComplete(checkpoint);
                this.game.parent.amitsAudioPlayer.stopAllMusic();
                this.game.parent.amitsAudioPlayer.smb_pipe.play();
                p.setActive(false);
                break;
            }
            case 26: {
                this.game.boss.BadGameGlitch();
                this.game.VolitileGroup.add(new Sprite(this.game.bsLoader.getStoredImage("QuestComplete"), checkpoint.getX() - 224.0, checkpoint.getY() - 192.0));
                p.setX(checkpoint.getX() - (double)p.getWidth());
                p.StopSpeed();
                p.NoControlling();
                p.StopMoveForward();
                break;
            }
            case 27: {
                this.game.LevelComplete(checkpoint);
                p.setActive(false);
                this.game.DelayToNextCheckPoint = 200;
                this.game.parent.amitsAudioPlayer.stopAllMusic();
                break;
            }
            case 28: {
                if (!p.KeyPressedUP) break;
                this.game.LevelComplete(checkpoint);
                p.setActive(false);
                this.game.DelayToNextCheckPoint = 200;
                this.game.parent.amitsAudioPlayer.stopAllMusic();
            }
        }
        this.game.setDegree(side);
    }
}

