/*
 * Decompiled with CFR 0.152.
 */
package Objects;

import Animations.FallingDeadSprites;
import Objects.BasicEnemy;
import Objects.EnemyTurtle;
import SandBox.Mario;
import com.golden.gamedev.object.AnimatedSprite;
import com.golden.gamedev.object.Timer;
import com.golden.gamedev.object.sprite.VolatileSprite;
import com.golden.gamedev.util.ImageUtil;
import java.awt.image.BufferedImage;

public class FlyingTurtle
extends AnimatedSprite
implements BasicEnemy {
    boolean PositiveX = true;
    Mario game;
    public int Gravity = -6;

    public FlyingTurtle(BufferedImage[] bufferedImage, int x, int y, Mario g) {
        super(bufferedImage, (double)x, (double)y);
        this.setAnimationTimer(new Timer(300));
        this.setAnimate(true);
        this.setLoopAnim(true);
        this.setAnimationFrame(0, 1);
        this.setID(101);
        this.game = g;
    }

    public void update(long l) {
        if (this.Gravity < 8) {
            ++this.Gravity;
        }
        super.update(l);
        this.moveY(this.Gravity);
        if (this.PositiveX) {
            this.moveX(-2.0);
        } else {
            this.moveX(2.0);
        }
        super.update(l);
    }

    public void bounce() {
        this.Gravity = -16;
    }

    public void MarioJumpedOnEnemy() {
        this.game.player.Jump(-8);
        this.game.EnemyGroup.add(new EnemyTurtle((int)this.getX(), (int)this.getY(), this.game, true));
        if (this.game.player.HasStar()) {
            this.game.AnimationGroup.add(new VolatileSprite(this.game.bsLoader.getStoredImages("Twink"), this.getX(), this.getY()));
        }
        this.setActive(false);
    }

    public void CollidedWithMovingShell() {
        BufferedImage HorizontalFilpShell = this.game.bsLoader.getStoredImage("TurtelShell");
        HorizontalFilpShell = ImageUtil.flipHorizontal(HorizontalFilpShell);
        this.game.AnimationGroup.add(new FallingDeadSprites(this.getX(), this.getY(), HorizontalFilpShell, this.MariotoRight()));
        this.game.AnimationGroup.add(new VolatileSprite(this.game.bsLoader.getStoredImages("Twink"), this.getX(), this.getY()));
        this.setActive(false);
    }

    public void CollidedWithBrick_GoToLeft() {
        this.PositiveX = true;
        this.setAnimationFrame(0, 1);
    }

    public void CollidedWithBrick_GoToRight() {
        this.PositiveX = false;
        this.setAnimationFrame(2, 3);
    }

    public int getType() {
        return this.getID();
    }

    public void KilledByFireBall() {
        BufferedImage HorizontalFilpShell = this.game.bsLoader.getStoredImage("TurtelShell");
        HorizontalFilpShell = ImageUtil.flipHorizontal(HorizontalFilpShell);
        this.game.AnimationGroup.add(new FallingDeadSprites(this.getX(), this.getY(), HorizontalFilpShell, this.MariotoRight()));
        this.setActive(false);
    }

    public void setYloc(double d) {
        this.setY(d);
        this.bounce();
    }

    public void CollidedWithShell() {
    }

    public void OtherEnemyTouchedFromRight() {
        this.PositiveX = false;
        this.setAnimationFrame(2, 3);
    }

    public void OtherEnemyTouchedFromLeft() {
        this.PositiveX = true;
        this.setAnimationFrame(0, 1);
    }

    public void CollidedWithMarioFromTOLeft() {
        if (this.game.player.HasStar()) {
            this.CollidedWithMovingShell();
            this.setActive(false);
        } else {
            this.game.player.Decerease();
        }
    }

    public void CollidedWithMarioTORight() {
        if (this.game.player.HasStar()) {
            this.CollidedWithMovingShell();
            this.setActive(false);
        } else {
            this.game.player.Decerease();
        }
    }

    public void Kill() {
    }

    public void EnemyJumperOnMario() {
        if (this.game.player.HasStar()) {
            this.CollidedWithMovingShell();
            this.setActive(false);
        } else {
            this.game.player.Decerease();
        }
    }

    public int Life() {
        return 0;
    }

    public void CollidedWithJumping_Brick() {
    }

    public boolean MariotoRight() {
        boolean positive = !(this.game.player.getX() < this.getX());
        return positive;
    }
}

