/*
 * Decompiled with CFR 0.152.
 */
package Utility;

import SandBox.Mario;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;

public class SoundPlayer
implements LineListener {
    private Hashtable myClips = new Hashtable();

    public void play(String fileName) {
        Clip clip = this.getClip(fileName);
        if (clip != null) {
            clip.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playAndWait(String fileName) {
        Clip clip = this.getClip(fileName);
        if (clip != null) {
            clip.start();
            try {
                Clip clip2 = clip;
                synchronized (clip2) {
                    clip.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void loop(String fileName) {
        this.loop(fileName, -1);
    }

    public void loop(String fileName, int numTimes) {
        Clip clip = this.getClip(fileName);
        if (clip != null) {
            clip.loop(numTimes);
        }
    }

    public void loopAndWait(String fileName) {
        this.loopAndWait(fileName, -1);
    }

    public void loopAndWait(String fileName, int numTimes) {
        Clip clip = this.getClip(fileName);
        if (clip != null) {
            clip.loop(numTimes);
            try {
                clip.wait();
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
    }

    public void pause(String fileName) {
        Clip clip = this.getClip(fileName);
        if (clip != null) {
            int pos = clip.getFramePosition();
            clip.stop();
            clip.setFramePosition(pos);
        }
    }

    public void stop(String fileName) {
        Clip clip = this.getClip(fileName);
        this.stopClip(clip);
    }

    public void stopAll() {
        Enumeration clips = this.myClips.elements();
        while (clips.hasMoreElements()) {
            Clip clip = (Clip)clips.nextElement();
            this.stopClip(clip);
        }
    }

    public void preLoad(String fileName) {
        this.getClip(fileName);
    }

    public boolean contains(String fileName) {
        return this.myClips.containsKey(fileName);
    }

    public void clear() {
        this.myClips.clear();
    }

    public void update(LineEvent le) {
        if (le.getType() == LineEvent.Type.STOP) {
            this.stopClip((Clip)le.getSource());
        }
    }

    private Clip getClip(String fileName) {
        Clip clip = null;
        AudioInputStream ais = null;
        if (this.myClips.containsKey(fileName)) {
            clip = (Clip)this.myClips.get(fileName);
        } else {
            try {
                ais = AudioSystem.getAudioInputStream(Mario.class.getResource(fileName));
                clip = (Clip)AudioSystem.getLine(new Line.Info(Clip.class));
                clip.open(ais);
                clip.addLineListener(this);
                this.myClips.put(fileName, clip);
            }
            catch (UnsupportedAudioFileException uafe) {
                throw new RuntimeException("Not a valid supported audio file: \"" + fileName + "\"");
            }
            catch (LineUnavailableException lue) {
                throw new RuntimeException("Line is not available to play sound \"" + fileName + "\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException("I/O error while reading file: \"" + fileName + "\"");
            }
        }
        return clip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopClip(Clip clip) {
        if (clip != null) {
            clip.stop();
            clip.setFramePosition(0);
            Clip clip2 = clip;
            synchronized (clip2) {
                clip.notifyAll();
            }
        }
    }
}

