/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev;

import com.golden.gamedev.Game;
import com.golden.gamedev.engine.BaseGraphics;
import com.golden.gamedev.engine.graphics.AppletMode;
import com.golden.gamedev.engine.graphics.FullScreenMode;
import com.golden.gamedev.engine.graphics.WindowExitListener;
import com.golden.gamedev.engine.graphics.WindowedMode;
import com.golden.gamedev.funbox.ErrorNotificationDialog;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;

public class GameLoader
extends AppletMode
implements WindowListener,
Runnable {
    private static final long serialVersionUID = 7164725885243400217L;
    public static final String JAVA_VERSION;
    public String MINIMUM_VERSION = "1.4";
    private boolean VALID_JAVA_VERSION = true;
    private String[] INFO_MSG = new String[]{"Loading Game, please wait a moment"};
    protected BaseGraphics gfx;
    protected Game game;

    public void start() {
        if (!this.VALID_JAVA_VERSION) {
            return;
        }
        if (this.gfx != null) {
            if (this.game != null) {
                this.game.start();
            }
            return;
        }
        try {
            String param = this.getParameter("MINIMUM_VERSION");
            if (param != null) {
                this.MINIMUM_VERSION = param;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "ERROR: GameLoader.setup(Game, Dimension, Fullscreen); need to be called\nbefore calling GameLoader.start();", "Game Initialization", 0);
            System.exit(0);
        }
        try {
            if (this.game == null) {
                this.game = this.createAppletGame();
                if (this.game == null) {
                    JOptionPane.showMessageDialog(null, "FATAL ERROR: Game main-class is not specified!\nPlease subclass GameLoader class and override\ncreateAppletGame() method to return your game main class.\n\nFor example :\npublic class YourGameApplet extends GameLoader {\n   protected Game createAppletGame() {\n      return new YourGame();\n   }\n}", "Game Initialization", 0);
                    this.VALID_JAVA_VERSION = false;
                    return;
                }
                this.game.bsGraphics = this.gfx = this;
            }
            super.start();
            new Thread(this).start();
        }
        catch (Throwable e) {
            this.INFO_MSG = new String[]{"UNRECOVERABLE ERROR", "PLEASE CONTACT THE GAME AUTHOR"};
            this.removeAll();
            this.setIgnoreRepaint(false);
            new ErrorNotificationDialog(e, this, this.getClass().getName(), null);
        }
    }

    public void stop() {
        if (this.game != null) {
            this.game.stop();
        }
    }

    public final void run() {
        if (this.game != null) {
            this.game.start();
        }
    }

    protected Game createAppletGame() {
        try {
            String className = this.getParameter("GAME");
            if (className != null) {
                if (className.endsWith(".class")) {
                    className = className.substring(0, className.length() - 6);
                }
                Class<?> mainClass = Class.forName(className);
                return (Game)mainClass.newInstance();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public void setup(Game game, Dimension d, boolean fullscreen, boolean bufferstrategy) {
        try {
            BaseGraphics mode;
            block6: {
                if (fullscreen) {
                    mode = null;
                    try {
                        mode = new FullScreenMode(d, bufferstrategy);
                        ((FullScreenMode)mode).getFrame().removeWindowListener(WindowExitListener.getInstance());
                        ((FullScreenMode)mode).getFrame().addWindowListener(this);
                        this.gfx = mode;
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        JOptionPane.showMessageDialog(null, "ERROR: Entering FullScreen Mode\nCaused by: " + e.toString(), "Graphics Engine Initialization", 0);
                        fullscreen = false;
                        if (mode == null) break block6;
                        ((FullScreenMode)mode).cleanup();
                    }
                }
            }
            if (!fullscreen) {
                mode = new WindowedMode(d, bufferstrategy);
                ((WindowedMode)mode).getFrame().removeWindowListener(WindowExitListener.getInstance());
                ((WindowedMode)mode).getFrame().addWindowListener(this);
                this.gfx = mode;
            }
            this.game = game;
            this.game.bsGraphics = this.gfx;
        }
        catch (Throwable e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Fatal Error: Failed to initialize game environment!\nCaused by:\n       " + e + "\n" + "Please send above exception to the Game Author.\n", "Game Initialization", 0);
            System.exit(-1);
        }
    }

    public void setup(Game game, Dimension d, boolean fullscreen) {
        this.setup(game, d, fullscreen, true);
    }

    public Game getGame() {
        return this.game;
    }

    public void paint(Graphics g) {
        int width = this.getSize().width;
        int height = this.getSize().height;
        g.setColor(new Color(255, 0, 0));
        g.fillRect(0, 0, width, height);
        g.setFont(new Font("Monospaced", 0, 16));
        FontMetrics fm = g.getFontMetrics();
        int y = height / 2 - (fm.getHeight() + 10) * (this.INFO_MSG.length / 2);
        g.setColor(new Color(0, 0, 0));
        try {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        catch (Exception e) {
            // empty catch block
        }
        for (int i = 0; i < this.INFO_MSG.length; ++i) {
            g.drawString(this.INFO_MSG[i], width / 2 - fm.stringWidth(this.INFO_MSG[i]) / 2, y);
            y += fm.getHeight() + 10;
        }
    }

    private boolean isValidVersion() {
        try {
            StringTokenizer versionToken = new StringTokenizer(JAVA_VERSION, ".");
            StringTokenizer minimumToken = new StringTokenizer(this.MINIMUM_VERSION, ".");
            int total = versionToken.countTokens() > minimumToken.countTokens() ? versionToken.countTokens() : minimumToken.countTokens();
            String version = "";
            String minimum = "";
            String parsed = "";
            for (int i = 0; i < total; ++i) {
                char inc;
                try {
                    inc = versionToken.nextToken().charAt(0);
                }
                catch (Exception e) {
                    inc = '0';
                }
                version = version + inc;
                try {
                    inc = minimumToken.nextToken().charAt(0);
                    if (parsed.length() > 0) {
                        parsed = parsed + ".";
                    }
                    parsed = parsed + inc;
                }
                catch (Exception e) {
                    inc = '0';
                }
                minimum = minimum + inc;
            }
            int ver = Integer.parseInt(version);
            int min = Integer.parseInt(minimum);
            this.MINIMUM_VERSION = parsed;
            return ver >= min;
        }
        catch (Exception e) {
            System.err.println("WARNING: MINIMUM_VERSION [" + this.MINIMUM_VERSION + "] and/or " + "JAVA_VERSION [" + JAVA_VERSION + "] value is not valid!");
            return true;
        }
    }

    public String getGraphicsDescription() {
        try {
            return this.gfx != null ? this.gfx.getGraphicsDescription() : super.getGraphicsDescription();
        }
        catch (Exception e) {
            return this.gfx != null ? this.gfx.getClass().toString() : this.getClass().toString();
        }
    }

    public void windowClosing(WindowEvent e) {
        if (this.game != null) {
            this.game.finish();
        }
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    static {
        String ver = "1.4.1";
        try {
            ver = System.getProperty("java.version");
        }
        catch (Exception exception) {
            // empty catch block
        }
        JAVA_VERSION = ver;
    }
}

