/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.engine.graphics;

import com.golden.gamedev.engine.BaseGraphics;
import com.golden.gamedev.engine.graphics.WindowExitListener;
import com.golden.gamedev.util.ImageUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferStrategy;
import java.awt.image.VolatileImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

public class FullScreenMode
implements BaseGraphics,
Comparator {
    public static final GraphicsDevice DEVICE = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
    public static final GraphicsConfiguration CONFIG = DEVICE.getDefaultConfiguration();
    private Frame frame;
    private Dimension size;
    private VolatileImage offscreen;
    private BufferStrategy strategy;
    private Graphics2D currentGraphics;

    public FullScreenMode(Dimension d, boolean bufferstrategy) {
        this.size = d;
        if (!DEVICE.isFullScreenSupported()) {
            throw new RuntimeException("Full Screen Exclusive Mode is not supported");
        }
        this.frame = new Frame("Golden T Game Engine", CONFIG);
        try {
            this.frame.setIconImage(ImageUtil.getImage(FullScreenMode.class.getResource("Icon.png")));
        }
        catch (Exception e) {
            // empty catch block
        }
        this.frame.addWindowListener(WindowExitListener.getInstance());
        this.frame.setResizable(false);
        this.frame.setIgnoreRepaint(true);
        this.frame.setLayout(null);
        this.frame.setUndecorated(true);
        this.frame.dispose();
        DEVICE.setFullScreenWindow(this.frame);
        if (!DEVICE.isDisplayChangeSupported()) {
            DEVICE.setFullScreenWindow(null);
            this.frame.dispose();
            throw new RuntimeException("Changing Display Mode is not supported");
        }
        DisplayMode bestDisplay = this.getBestDisplay(this.size);
        if (bestDisplay == null) {
            DEVICE.setFullScreenWindow(null);
            this.frame.dispose();
            throw new RuntimeException("Changing Display Mode to " + this.size.width + "x" + this.size.height + " is not supported");
        }
        DEVICE.setDisplayMode(bestDisplay);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (bufferstrategy) {
            bufferstrategy = this.createBufferStrategy();
        }
        if (!bufferstrategy) {
            this.createBackBuffer();
        }
        this.frame.requestFocus();
    }

    private boolean createBufferStrategy() {
        boolean bufferCreated;
        int num = 0;
        do {
            bufferCreated = true;
            try {
                this.frame.createBufferStrategy(2);
            }
            catch (Exception e) {
                bufferCreated = false;
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException excp) {
                    // empty catch block
                }
            }
        } while (num++ <= 5 && !bufferCreated);
        if (!bufferCreated) {
            System.err.println("BufferStrategy is not available!");
            return false;
        }
        while (this.strategy == null) {
            try {
                this.strategy = this.frame.getBufferStrategy();
            }
            catch (Exception e) {}
        }
        Graphics2D gfx = null;
        while (gfx == null) {
            try {
                gfx = this.getBackBuffer();
            }
            catch (Exception e) {}
        }
        return true;
    }

    private void createBackBuffer() {
        if (this.offscreen != null) {
            this.offscreen.flush();
            this.offscreen = null;
        }
        this.offscreen = CONFIG.createCompatibleVolatileImage(this.size.width, this.size.height);
    }

    public Graphics2D getBackBuffer() {
        if (this.currentGraphics == null) {
            if (this.strategy == null) {
                if (this.offscreen.validate(CONFIG) == 2) {
                    this.createBackBuffer();
                }
                this.currentGraphics = this.offscreen.createGraphics();
            } else {
                this.currentGraphics = (Graphics2D)this.strategy.getDrawGraphics();
            }
        }
        return this.currentGraphics;
    }

    public boolean flip() {
        this.currentGraphics.dispose();
        this.currentGraphics = null;
        if (this.strategy == null) {
            this.frame.getGraphics().drawImage(this.offscreen, 0, 0, null);
            Toolkit.getDefaultToolkit().sync();
            return !this.offscreen.contentsLost();
        }
        this.strategy.show();
        Toolkit.getDefaultToolkit().sync();
        return !this.strategy.contentsLost();
    }

    public void cleanup() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        try {
            Thread.sleep(200L);
            if (this.frame != null) {
                this.frame.dispose();
            }
        }
        catch (Exception e) {
            System.err.println("ERROR: Shutting down graphics context " + e);
            System.exit(-1);
        }
    }

    public Dimension getSize() {
        return this.size;
    }

    public Component getComponent() {
        return this.frame;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public boolean isBufferStrategy() {
        return this.strategy != null;
    }

    public String getGraphicsDescription() {
        return "Full Screen Mode [" + this.getSize().width + "x" + this.getSize().height + "]" + (this.strategy != null ? " with BufferStrategy" : "");
    }

    public void setWindowTitle(String st) {
        this.frame.setTitle(st);
    }

    public String getWindowTitle() {
        return this.frame.getTitle();
    }

    public void setWindowIcon(Image icon) {
        try {
            this.frame.setIconImage(icon);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Image getWindowIcon() {
        return this.frame.getIconImage();
    }

    private DisplayMode getBestDisplay(Dimension size) {
        DisplayMode[] mode = DEVICE.getDisplayModes();
        ArrayList<DisplayMode> modeList = new ArrayList<DisplayMode>();
        for (int i = 0; i < mode.length; ++i) {
            if (mode[i].getWidth() != size.width || mode[i].getHeight() != size.height) continue;
            modeList.add(mode[i]);
        }
        if (modeList.size() == 0) {
            return null;
        }
        DisplayMode[] match = modeList.toArray(new DisplayMode[0]);
        Arrays.sort(match, this);
        return match[0];
    }

    public int compare(Object o1, Object o2) {
        DisplayMode mode1 = (DisplayMode)o1;
        DisplayMode mode2 = (DisplayMode)o2;
        int removed1 = mode1.getRefreshRate() > 75 ? 5000 * mode1.getRefreshRate() : 0;
        int removed2 = mode2.getRefreshRate() > 75 ? 5000 * mode2.getRefreshRate() : 0;
        return (mode2.getBitDepth() - mode1.getBitDepth()) * 1000 + (mode2.getRefreshRate() - mode1.getRefreshRate()) - (removed2 - removed1);
    }
}

