/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.object;

import java.io.Serializable;

public class Timer
implements Serializable {
    private static final long serialVersionUID = -5183805739820889052L;
    private boolean active = true;
    private long delay;
    private long currentTick;

    public Timer(int delay) {
        this.delay = delay;
    }

    public boolean action(long elapsedTime) {
        if (this.active) {
            this.currentTick += elapsedTime;
            if (this.currentTick >= this.delay) {
                this.currentTick -= this.delay;
                return true;
            }
        }
        return false;
    }

    public void refresh() {
        this.currentTick = 0L;
    }

    public void setEquals(Timer other) {
        this.active = other.active;
        this.delay = other.delay;
        this.currentTick = other.currentTick;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean b) {
        this.active = b;
        this.refresh();
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long i) {
        this.delay = i;
        this.refresh();
    }

    public long getCurrentTick() {
        return this.currentTick;
    }

    public void setCurrentTick(long tick) {
        this.currentTick = tick;
    }
}

