/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.object.background;

import com.golden.gamedev.engine.BaseGraphics;
import com.golden.gamedev.object.background.TileBackground;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.VolatileImage;

public class CachedTileBackground
extends TileBackground {
    private static final long serialVersionUID = -4682118408949172952L;
    private VolatileImage cache;
    private boolean validated;
    private double oldX;
    private double oldY;

    public CachedTileBackground(BaseGraphics bsGraphics, BufferedImage[] images, int[][] tiles) {
        super(images, tiles);
        this.cache = bsGraphics.getComponent().createVolatileImage(bsGraphics.getSize().width, bsGraphics.getSize().height);
    }

    protected void checkMutations() {
        this.validated = this.validated && this.oldX == this.getX() && this.oldY == this.getY();
    }

    public void update(long elapsedTime) {
        super.update(elapsedTime);
        this.checkMutations();
    }

    public void render(Graphics2D g) {
        if (!this.validated) {
            super.render(this.cache.createGraphics());
            this.validated = true;
            this.oldX = this.getX();
            this.oldY = this.getY();
        }
        g.drawImage(this.cache, 0, 0, null);
    }
}

