/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.object.font;

import com.golden.gamedev.object.GameFont;
import com.golden.gamedev.util.ImageUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;

public class SystemFont
implements GameFont {
    private final Font font;
    private final FontMetrics fm;
    private int height;
    private int gap;
    private Color color;

    public SystemFont(Font font, Color color) {
        this.font = font;
        this.color = color;
        Graphics2D g = ImageUtil.createImage(1, 1).createGraphics();
        this.fm = g.getFontMetrics(font);
        this.height = this.fm.getMaxAscent() + this.fm.getMaxDescent() + this.fm.getLeading();
        this.gap = this.height - this.fm.getDescent();
        g.dispose();
    }

    public SystemFont(Font font) {
        this(font, null);
    }

    public int drawString(Graphics2D g, String s, int x, int y) {
        if (g.getFont() != this.font) {
            g.setFont(this.font);
        }
        if (this.color != null) {
            g.setColor(this.color);
        }
        g.drawString(s, x, y + this.gap);
        return x + this.getWidth(s);
    }

    public int drawString(Graphics2D g, String s, int alignment, int x, int y, int width) {
        if (alignment == 1) {
            return this.drawString(g, s, x, y);
        }
        if (alignment == 3) {
            return this.drawString(g, s, x + width / 2 - this.getWidth(s) / 2, y);
        }
        if (alignment == 2) {
            return this.drawString(g, s, x + width - this.getWidth(s), y);
        }
        if (alignment == 4) {
            int mod = width - this.getWidth(s);
            if (mod <= 0) {
                return this.drawString(g, s, x, y);
            }
            int len = s.length();
            int space = 0;
            int curpos = 0;
            int endpos = 0;
            while (curpos < len) {
                if (s.charAt(curpos++) != ' ') continue;
                ++space;
            }
            if (space > 0) {
                mod += space * this.getWidth(' ');
                space = mod / space;
            }
            endpos = 0;
            curpos = 0;
            while (curpos < len) {
                endpos = s.indexOf(32, curpos);
                if (endpos == -1) {
                    endpos = len;
                }
                String st = s.substring(curpos, endpos);
                this.drawString(g, st, x, y);
                x += this.getWidth(st) + space;
                curpos = endpos + 1;
            }
            return x;
        }
        return 0;
    }

    public int drawText(Graphics2D g, String text, int alignment, int x, int y, int width, int vspace, int firstIndent) {
        boolean firstLine = true;
        int len = text.length();
        int posx = firstIndent;
        int endpos = 0;
        int startpos = 0;
        int curpos = 0;
        while (curpos < len) {
            char curChr = text.charAt(curpos++);
            posx += this.getWidth(curChr);
            if (curChr - 32 == 0) {
                endpos = curpos - 1;
            }
            if (posx < width) continue;
            if (firstLine) {
                this.drawString(g, text.substring(startpos, endpos), alignment, alignment == 2 ? x : x + firstIndent, y, width - firstIndent);
                firstLine = false;
            } else {
                this.drawString(g, text.substring(startpos, endpos), alignment, x, y, width);
            }
            y += this.getHeight() + vspace;
            posx = 0;
            startpos = curpos = endpos + 1;
        }
        if (firstLine) {
            this.drawString(g, text.substring(startpos, curpos), alignment, alignment == 2 ? x : x + firstIndent, y, width - firstIndent);
        } else if (posx != 0) {
            this.drawString(g, text.substring(startpos, curpos), alignment, x, y, width);
        }
        return y + this.getHeight();
    }

    public Font getFont() {
        return this.font;
    }

    public FontMetrics getFontMetrics() {
        return this.fm;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color c) {
        this.color = c;
    }

    public int getWidth(String st) {
        return this.fm.stringWidth(st);
    }

    public int getWidth(char c) {
        return this.fm.charWidth(c);
    }

    public int getHeight() {
        return this.height;
    }

    public String toString() {
        return super.toString() + " " + "[basefont=" + this.font + ", color=" + this.color + "]";
    }

    public boolean isAvailable(char c) {
        return true;
    }
}

