/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.util;

import com.golden.gamedev.util.Utility;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;

public class FileUtil {
    private FileUtil() {
    }

    public static boolean fileWrite(String[] text, File file) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(file));
            PrintWriter writeOut = new PrintWriter(out);
            for (int i = 0; i < text.length; ++i) {
                writeOut.println(text[i]);
            }
            writeOut.close();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String[] fileRead(File file) {
        try {
            String data;
            FileReader in = new FileReader(file);
            BufferedReader readIn = new BufferedReader(in);
            ArrayList<String> list = new ArrayList<String>(50);
            while ((data = readIn.readLine()) != null) {
                list.add(data);
            }
            readIn.close();
            return Utility.compactStrings(list.toArray(new String[0]));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String[] fileRead(InputStream stream) {
        try {
            String data;
            InputStreamReader in = new InputStreamReader(stream);
            BufferedReader readIn = new BufferedReader(in);
            ArrayList<String> list = new ArrayList<String>(50);
            while ((data = readIn.readLine()) != null) {
                list.add(data);
            }
            readIn.close();
            return Utility.compactStrings(list.toArray(new String[0]));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String[] fileRead(URL url) {
        try {
            return FileUtil.fileRead(url.openStream());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static File setExtension(File f, String ext) {
        String s = f.getAbsolutePath();
        int i = s.lastIndexOf(46);
        if (i < 0) {
            return new File(s + "." + ext);
        }
        return new File(s.substring(0, i) + "." + ext);
    }

    public static String getExtension(File f) {
        return FileUtil.getExtension(f.getName());
    }

    public static String getExtension(String st) {
        int index = FileUtil.getIndex(st);
        String s = index <= 0 ? st : st.substring(index + 1);
        String ext = "";
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1);
        }
        return ext;
    }

    public static String getName(File f) {
        return FileUtil.getName(f.getName());
    }

    public static String getName(String st) {
        String s;
        int index = FileUtil.getIndex(st);
        String name = s = index <= 0 ? st : st.substring(index + 1);
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length()) {
            name = s.substring(0, i);
        }
        return name;
    }

    public static String getPath(File f) {
        try {
            return FileUtil.getPath(f.getCanonicalPath());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getPath(String st) {
        String path = "";
        int index = FileUtil.getIndex(st);
        if (index > 0) {
            path = st.substring(0, index + 1);
        }
        return path;
    }

    public static String getPathName(File f) {
        try {
            return FileUtil.getPathName(f.getCanonicalPath());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getPathName(String st) {
        String s;
        String path = "";
        int index = FileUtil.getIndex(st);
        if (index > 0) {
            path = st.substring(0, index + 1);
        } else {
            index = 0;
        }
        String name = s = index <= 0 ? st : st.substring(index + 1);
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length()) {
            name = s.substring(0, i);
        }
        return path + name;
    }

    private static int getIndex(String st) {
        int index = st.lastIndexOf(47);
        if (index < 0) {
            index = st.lastIndexOf(File.separatorChar);
        }
        return index;
    }
}

