/*
 * Decompiled with CFR 0.152.
 */
package biege;

import biege.Element;
import biege.GUI;
import biege.Player;
import biege.Player2;
import biege.Position;
import biege.TextBox;
import biege.ToumbStone;
import biege.WorldData;
import java.util.AbstractCollection;
import java.util.ArrayList;

public class AdventureApp {
    public static int LEFT = 0;
    public static int RIGHT = 200;
    public static int TOP = 0;
    public static int BOTTOM = 150;
    public static double TALK_RANGE = 8.2;
    private static String[] GAME_OVER = new String[]{"", "Game Over", "", ""};
    private static String GAME_OVER_THEME_LOCATION = "file:sound/gameover.wav";
    private static Position PLAYER_START_POSITION = new Position(100.0, 120.0);
    private GUI theGui;
    private ArrayList content;
    private ArrayList newContent;
    private Player you;
    private Player2 friend;
    private boolean twoPlayer;
    private int xScreen = 0;
    private int yScreen = 1;
    private ToumbStone p1toumb = new ToumbStone(new Position());

    public AdventureApp(GUI caller, boolean player2On) {
        this.twoPlayer = player2On;
        System.out.println("Starting new Game...");
        WorldData load = new WorldData();
        this.theGui = caller;
        this.you = new Player(PLAYER_START_POSITION);
        this.friend = new Player2(PLAYER_START_POSITION);
        this.you.emptyPouch();
        this.content = WorldData.loadWorld(this.xScreen, this.yScreen, this.you, this.friend);
        String[] welcome = new String[]{"Welcome to Biege the Adventure Game", "Press Ctrl to spear enemies", "Press Space to Talk to the King here and other folk", "Press M to view the world Map", "", "              Press ENTER to close this box"};
        caller.setTextBox(new TextBox(welcome));
    }

    public Player2 getPlayer2() {
        return this.friend;
    }

    public boolean twoPlayer() {
        return this.twoPlayer;
    }

    public Player getPlayer() {
        return this.you;
    }

    public int getPlayerHealth() {
        return this.you.getHealth();
    }

    public int getPlayer2Health() {
        return this.friend.getHealth();
    }

    public void advance() {
        this.newContent = new ArrayList();
        for (int i = 0; i < this.content.size(); ++i) {
            Element closest;
            Element temp = (Element)this.content.get(i);
            temp.advance(this.theGui);
            for (int other = 0; other < this.content.size(); ++other) {
                if (this.content.get(other) == temp) continue;
                temp.interact((Element)this.content.get(other));
            }
            if (GUI.isSpacePressed() && (closest = this.whatPlayerFaces()) != null) {
                closest.talk(this.theGui);
            }
            if (!temp.shoulVanish()) {
                this.newContent.add(temp);
                continue;
            }
            temp.onDeath(this.theGui);
        }
        this.content = this.newContent;
        this.checkScreen();
        if (this.you.isDead()) {
            ((AbstractCollection)this.content).remove(this.you);
            this.p1toumb.changePosition(this.you.getPosition());
            if (!this.content.contains(this.p1toumb)) {
                this.content.add(this.p1toumb);
            }
            this.theGui.setTextBox(new TextBox(GAME_OVER));
            WorldData.changeSong(GAME_OVER_THEME_LOCATION);
        }
    }

    public int getXScreen() {
        return this.xScreen;
    }

    public int getYScreen() {
        return this.yScreen;
    }

    public boolean gameIsOver() {
        return this.you.isDead() || this.you.finnished();
    }

    private Element whatPlayerFaces() {
        Position centre = this.you.directlyFacing();
        Element closest = null;
        for (int i = 0; i < this.content.size(); ++i) {
            Element temp = (Element)this.content.get(i);
            if (temp == this.you || !(Position.distance(centre, temp.getPosition()) < TALK_RANGE + temp.getGurth())) continue;
            closest = temp;
        }
        return closest;
    }

    private void checkScreen() {
        double yourX = this.you.getPosition().getX();
        double yourY = this.you.getPosition().getY();
        if (yourX >= (double)RIGHT && this.you.getDirection() == Position.DIRECTION_EAST) {
            ++this.xScreen;
            this.you.changePosition(new Position(0.0, yourY));
            this.friend.changePosition(this.you.getPosition());
            this.content = WorldData.loadWorld(this.xScreen, this.yScreen, this.you, this.friend);
            this.theGui.setTextBox(null);
        }
        if (yourX <= (double)LEFT && this.you.getDirection() == Position.DIRECTION_WEST) {
            --this.xScreen;
            this.you.changePosition(new Position(RIGHT, yourY));
            this.friend.changePosition(this.you.getPosition());
            this.content = WorldData.loadWorld(this.xScreen, this.yScreen, this.you, this.friend);
            this.theGui.setTextBox(null);
        }
        if (yourY >= (double)BOTTOM && this.you.getDirection() == Position.DIRECTION_SOUTH) {
            ++this.yScreen;
            this.you.changePosition(new Position(yourX, 0.0));
            this.friend.changePosition(this.you.getPosition());
            this.content = WorldData.loadWorld(this.xScreen, this.yScreen, this.you, this.friend);
            this.theGui.setTextBox(null);
        }
        if (yourY <= (double)TOP && this.you.getDirection() == Position.DIRECTION_NORTH) {
            --this.yScreen;
            this.you.changePosition(new Position(yourX, BOTTOM));
            this.friend.changePosition(this.you.getPosition());
            this.content = WorldData.loadWorld(this.xScreen, this.yScreen, this.you, this.friend);
            this.theGui.setTextBox(null);
        }
        if (!this.twoPlayer) {
            ((AbstractCollection)this.content).remove(this.friend);
        }
    }

    public ArrayList getGameParts() {
        return this.content;
    }

    public void setScreen(int xs, int ys) {
        this.xScreen = xs;
        this.yScreen = ys;
        this.content = WorldData.loadWorld(this.xScreen, this.yScreen, this.you, this.friend);
        this.newContent = new ArrayList();
        for (int i = 0; i < this.content.size(); ++i) {
            this.newContent.add(this.content.get(i));
        }
    }
}

