/*
 * Decompiled with CFR 0.152.
 */
package biege;

import biege.Element;
import biege.GUI;
import biege.Player;
import biege.Position;
import biege.TextBox;
import java.applet.AudioClip;
import java.awt.Color;
import java.awt.Graphics;

public class Crystal
extends Element {
    private static String[] MESSAGE = new String[]{"You found a crystal!", ""};
    private static int CRYSTAL_WIDTH = 2;
    private static int CRYSTAL_HEIGHT = 3;
    private static AudioClip GET_CRYSTAL_SOUND = Element.loadAudioClip("file:sound/get.wav");
    private int id;

    public Crystal(Position p, int i) {
        super(p);
        this.id = i;
    }

    public void draw(Graphics g, int viewW, int viewH) {
        int[] xPts = new int[]{this.scaleX(viewW), this.scaleX(viewW) + Element.scaleWidth(CRYSTAL_WIDTH, viewW), this.scaleX(viewW), this.scaleX(viewW) - Element.scaleWidth(CRYSTAL_WIDTH, viewW)};
        int[] yPts = new int[]{this.scaleY(viewH) - Element.scaleHeight(CRYSTAL_HEIGHT, viewH), this.scaleY(viewH), this.scaleY(viewH) + Element.scaleHeight(CRYSTAL_HEIGHT, viewH), this.scaleY(viewH)};
        g.setColor(Color.blue);
        g.fillPolygon(xPts, yPts, 4);
        g.setColor(Color.black);
        g.drawPolygon(xPts, yPts, 4);
    }

    public void interact(Element e) {
        if (e.hasCystal(this.id)) {
            this.delete();
        }
    }

    public void advance(GUI tempGui) {
        if (Position.distance(this.getPosition(), tempGui.getPlayer().getPosition()) < this.getGurth() + tempGui.getPlayer().getGurth()) {
            this.talk(tempGui);
        }
    }

    public void talk(GUI tempGui) {
        Player p = tempGui.getPlayer();
        if (!p.hasCystal(this.id)) {
            if (GET_CRYSTAL_SOUND != null) {
                GET_CRYSTAL_SOUND.play();
            }
            p.giveCrystal(this.id);
            tempGui.setTextBox(new TextBox(MESSAGE));
            this.delete();
        }
    }

    public double getGurth() {
        return Math.max(CRYSTAL_WIDTH, CRYSTAL_HEIGHT) / 2;
    }
}

