/*
 * Decompiled with CFR 0.152.
 */
package biege;

import biege.Element;
import biege.Enemy;
import biege.GUI;
import biege.Position;
import biege.Projectile;
import java.applet.AudioClip;
import java.awt.Color;
import java.awt.Graphics;

public class Spiter
extends Enemy {
    private static int WIDTH = 6;
    private static Color SHOT_COLOUR = Color.orange;
    private static double SHOT_SPEED = 5.0;
    private static double SHOT_RADIUS = 4.2;
    private static AudioClip SPIT_SOUND = Element.loadAudioClip("file:sound/shoot.wav");
    private Projectile shot = null;

    public Spiter(Position p) {
        super(p);
    }

    public void draw(Graphics g, int viewW, int viewH) {
        g.setColor(Color.gray);
        g.fillOval(this.scaleX(viewW) - Element.scaleWidth(viewW, WIDTH / 2), this.scaleY(viewH) - Element.scaleHeight(viewH, WIDTH / 2), Element.scaleWidth(viewW, WIDTH), Element.scaleHeight(viewH, WIDTH));
        if (this.shot != null) {
            this.shot.draw(g, viewW, viewH);
        }
    }

    public void interact(Element e) {
        if (Position.distance(this.getPosition(), e.getPosition()) < (double)WIDTH + e.getGurth()) {
            e.hurt();
        }
        if (this.shot != null) {
            this.shot.interact(e);
        }
    }

    public void advance(GUI tempGui) {
        if (this.shot == null) {
            if (SPIT_SOUND != null) {
                SPIT_SOUND.play();
            }
            Position shotVector = Position.calculateDirectionVector(this.getPosition(), tempGui.getPlayer().getPosition());
            shotVector = Position.calculateVelocityVector(shotVector, SHOT_SPEED);
            this.shot = new Projectile(this.getPosition(), shotVector.getX(), shotVector.getY(), SHOT_RADIUS, SHOT_COLOUR);
        } else if (this.shot.shoulVanish()) {
            this.shot = null;
        } else {
            this.shot.advance(tempGui);
        }
    }

    public double getGurth() {
        return WIDTH / 2;
    }

    public void onDeath(GUI tempGui) {
        super.onDeath(tempGui);
        tempGui.getPlayer().increaseScore(15);
    }

    public void talk(GUI tempGui) {
    }
}

