/*
 * Decompiled with CFR 0.152.
 */
package biege;

import biege.BadEye;
import biege.BiGhost;
import biege.Bloob;
import biege.Crystal;
import biege.CrystalGiver;
import biege.DownSpike;
import biege.Element;
import biege.Folk;
import biege.Ghost;
import biege.GreenTree;
import biege.Guard;
import biege.Healer;
import biege.King;
import biege.PlayAreaView;
import biege.Player;
import biege.Player2;
import biege.Position;
import biege.Projectile;
import biege.RectangleObstacle;
import biege.RedTree;
import biege.SpikePit;
import biege.Spiter;
import biege.ToumbStone;
import biege.UpSpike;
import biege.YellowTree;
import java.applet.AudioClip;
import java.awt.Color;
import java.util.AbstractCollection;
import java.util.ArrayList;

public class WorldData {
    private static String[][] dialogue;
    private static String MAIN_THEME_LOCATION;
    private static String KING_THEME_LOCATION;
    private static String CASTLE_THEME_LOCATION;
    private static String CURRENT_SONG_LOACTION;
    private static AudioClip song;

    public WorldData() {
        WorldData.loadDialogue();
        this.precacheObjects();
    }

    private void precacheObjects() {
        new BadEye(new Position(0.0, 0.0), 0, 0);
        new BiGhost(new Position(0.0, 0.0));
        new Bloob(new Position(0.0, 0.0));
        new Crystal(new Position(0.0, 0.0), 0);
        new CrystalGiver(new Position(0.0, 0.0), 0);
        new DownSpike(new Position(0.0, 0.0));
        new Folk(new Position(0.0, 0.0), 0);
        new Ghost(new Position(0.0, 0.0));
        new GreenTree(new Position(0.0, 0.0));
        new Healer(new Position(0.0, 0.0));
        new King(new Position(0.0, 0.0));
        new Player(new Position(0.0, 0.0));
        new Projectile(new Position(0.0, 0.0), 0.0, 0.0, 0.0, null);
        new RectangleObstacle(new Position(0.0, 0.0), 0, 0, null);
        new RedTree(new Position(0.0, 0.0));
        new SpikePit(new Position(0.0, 0.0), 0, 0, null);
        new Spiter(new Position(0.0, 0.0));
        new ToumbStone(new Position(0.0, 0.0));
        new UpSpike(new Position(0.0, 0.0));
        new YellowTree(new Position(0.0, 0.0));
    }

    private static void loadDialogue() {
        dialogue = new String[11][];
        WorldData.dialogue[0] = new String[3];
        WorldData.dialogue[0][0] = "Hello there, wary traveller.";
        WorldData.dialogue[0][1] = "They say there's a blue crystal on the Ereal Plane.";
        WorldData.dialogue[0][2] = "I heard it is directly south of here.";
        WorldData.dialogue[1] = new String[3];
        WorldData.dialogue[1][0] = "I am the healing goddess. I can heal you!";
        WorldData.dialogue[1][1] = "There... Isn't that much better?";
        WorldData.dialogue[1][2] = "Good luck!";
        WorldData.dialogue[2] = new String[3];
        WorldData.dialogue[2][0] = "I found a blue crystal... Here, you can have it!";
        WorldData.dialogue[2][1] = "...";
        WorldData.dialogue[2][2] = "You found a crystal!";
        WorldData.dialogue[3] = new String[3];
        WorldData.dialogue[3][0] = "I am a happy gardener!";
        WorldData.dialogue[3][1] = "This stream nourishes the crop.";
        WorldData.dialogue[3][2] = "It won't flow if the crystals are not collected...";
        WorldData.dialogue[4] = new String[3];
        WorldData.dialogue[4][0] = "We're twins.";
        WorldData.dialogue[4][1] = "Can't you tell?";
        WorldData.dialogue[4][2] = "We look exactly the same, don't we?";
        WorldData.dialogue[5] = new String[1];
        WorldData.dialogue[5][0] = "I'm a fair dwarf maiden...";
        WorldData.dialogue[6] = new String[2];
        WorldData.dialogue[6][0] = "There is a crystal on South Rock";
        WorldData.dialogue[6][1] = "Ther's one just east of Albi Desert and some more in a desert cave.";
        WorldData.dialogue[7] = new String[2];
        WorldData.dialogue[7][0] = "Press CTRL to kill enemies with your spear.";
        WorldData.dialogue[7][1] = "Something good happens when your score reaches 250, 500, 1000 and 2000";
        WorldData.dialogue[8] = new String[2];
        WorldData.dialogue[8][0] = "The only exit to this town is the door to the king's palace.";
        WorldData.dialogue[8][1] = "Its on the west wall just above that red building.";
        WorldData.dialogue[9] = new String[2];
        WorldData.dialogue[9][0] = "There is a lonely old hermit who lives on the Ereal Hills";
        WorldData.dialogue[9][1] = "I believe that he possesses one crystal.";
        WorldData.dialogue[10] = new String[4];
        WorldData.dialogue[10][0] = "There is a deep dark forest to the east called Dethenwood.";
        WorldData.dialogue[10][1] = "We have an ancient grave yard deep within which contains a crystal.";
        WorldData.dialogue[10][2] = "The forest is tricky to navigate. Just start when you enter";
        WorldData.dialogue[10][3] = "and see a healer goddess and remember the word NESS...";
    }

    public static int getHealMessageIndex() {
        return 1;
    }

    public static int getGiveCrystalMessageIndex() {
        return 2;
    }

    public static String[] getDialogue(int index) {
        if (index >= 0 && index < dialogue.length) {
            return dialogue[index];
        }
        return new String[0];
    }

    public static ArrayList loadWorld(int x, int y, Player you, Player2 friend) {
        System.out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf("Now entering area (").concat(String.valueOf(x))).concat(String.valueOf(", "))).concat(String.valueOf(y))).concat(String.valueOf(").")));
        ArrayList<Element> temp = new ArrayList<Element>();
        temp.add(friend);
        temp.add(you);
        PlayAreaView.setBackgroundImage(null);
        if (x == 0 && y == 1) {
            WorldData.changeSong(KING_THEME_LOCATION);
            PlayAreaView.setBackgroundImage(Element.loadImage("throne.gif"));
            temp.add(new King(new Position(100.0, 95.0)));
            temp.add(new Folk(new Position(120.0, 95.0), 0));
            temp.add(new Healer(new Position(52.0, 85.0)));
            temp.add(new RectangleObstacle(new Position(0.0, 0.0), 200, 91, null));
            temp.add(new RectangleObstacle(new Position(0.0, 0.0), 5, 150, null));
            temp.add(new RectangleObstacle(new Position(195.0, 109.0), 5, 41, null));
        } else if (x == 0 && y == 2) {
            WorldData.changeSong(MAIN_THEME_LOCATION);
            PlayAreaView.setBackgroundImage(Element.loadImage("foresta1.gif"));
            temp.add(new RectangleObstacle(new Position(0.0, 0.0), 5, 150, null));
            temp.add(new RectangleObstacle(new Position(195.0, 0.0), 5, 5, null));
            temp.add(new Bloob(new Position(80.0, 75.0)));
            temp.add(new Bloob(new Position(120.0, 75.0)));
        } else if (x == 0 && y == 3) {
            WorldData.changeSong(MAIN_THEME_LOCATION);
            PlayAreaView.setBackgroundImage(Element.loadImage("foresta2.gif"));
            temp.add(new RectangleObstacle(new Position(0.0, 0.0), 5, 150, null));
            temp.add(new Bloob(new Position(100.0, 75.0)));
            temp.add(new GreenTree(new Position(30.0, 20.0)));
            temp.add(new GreenTree(new Position(150.0, 60.0)));
            temp.add(new GreenTree(new Position(90.0, 110.0)));
        } else if (x == 0 && y == 4) {
            WorldData.changeSong(MAIN_THEME_LOCATION);
            PlayAreaView.setBackgroundImage(Element.loadImage("foresta3.gif"));
            temp.add(new RectangleObstacle(new Position(0.0, 0.0), 5, 150, null));
            temp.add(new Crystal(new Position(100.0, 75.0), 0));
        } else if (x == 0 && y == 5) {
            WorldData.changeSong(MAIN_THEME_LOCATION);
            PlayAreaView.setBackgroundImage(Element.loadImage("foresta4.gif"));
            temp.add(new RectangleObstacle(new Position(0.0, 0.0), 5, 150, null));
            temp.add(new RectangleObstacle(new Position(0.0, 145.0), 200, 5, null));
            temp.add(new Bloob(new Position(40.0, 45.0)));
            temp.add(new Ghost(new Position(100.0, 100.0), 7, 2.4, 20, Color.pink));
        } else if (x == 1 && y == 1) {
            WorldData.changeSong("file:sound/town.wav");
            PlayAreaView.setBackgroundImage(Element.loadImage("town.gif"));
            temp.add(new RectangleObstacle(new Position(0.0, 0.0), 200, 5, null));
            temp.add(new RectangleObstacle(new Position(0.0, 0.0), 5, 91, null));
            temp.add(new RectangleObstacle(new Position(195.0, 0.0), 5, 150, null));
            temp.add(new RectangleObstacle(new Position(0.0, 145.0), 200, 5, null));
            temp.add(new RectangleObstacle(new Position(0.0, 109.0), 25, 41, null));
            temp.add(new RectangleObstacle(new Position(0.0, 0.0), 61, 64, null));
            temp.add(new RectangleObstacle(new Position(42.0, 96.0), 43, 27, null));
            temp.add(new RectangleObstacle(new Position(122.0, 64.0), 56, 31, null));
            temp.add(new RectangleObstacle(new Position(85.0, 28.0), 58, 35, null));
            temp.add(new RectangleObstacle(new Position(149.0, 19.0), 43, 26, null));
            temp.add(new Folk(new Position(65.0, 13.0), 4));
            temp.add(new Folk(new Position(55.0, 26.0), 4));
            temp.add(new Folk(new Position(182.0, 136.0), 3));
            temp.add(new Folk(new Position(5.0, 65.0), 9));
            temp.add(new Folk(new Position(40.0, 61.0), 5));
            temp.add(new Folk(new Position(63.0, 122.0), 7));
            temp.add(new Folk(new Position(172.0, 45.0), 10));
            temp.add(new Folk(new Position(160.0, 95.0), 6));
            temp.add(new Folk(new Position(100.0, 61.0), 8));
        } else if (x == 1 && y == 2) {
            WorldData.changeSong(MAIN_THEME_LOCATION);
            PlayAreaView.setBackgroundImage(Element.loadImage("forestb1.gif"));
            temp.add(new RectangleObstacle(new Position(0.0, 0.0), 200, 5, null));
            temp.add(new Ghost(new Position(122.0, 100.0), 7, 1.2, 40, Color.pink));
            temp.add(new Ghost(new Position(120.0, 110.0), 7, 1.2, 40, Color.pink));
        } else if (x == 1 && y == 3) {
            WorldData.changeSong(MAIN_THEME_LOCATION);
            PlayAreaView.setBackgroundImage(Element.loadImage("forestb2.gif"));
            temp.add(new Bloob(new Position(100.0, 40.0)));
            temp.add(new Bloob(new Position(50.0, 130.0)));
            temp.add(new Bloob(new Position(150.0, 130.0)));
            temp.add(new GreenTree(new Position(60.0, 50.0)));
        } else if (x == 1 && y == 4) {
            WorldData.changeSong(MAIN_THEME_LOCATION);
            PlayAreaView.setBackgroundImage(Element.loadImage("forestb3.gif"));
            temp.add(new Bloob(new Position(80.0, 75.0)));
            temp.add(new Bloob(new Position(40.0, 135.0)));
            temp.add(new Bloob(new Position(160.0, 55.0)));
            temp.add(new Bloob(new Position(110.0, 95.0)));
            temp.add(new Bloob(new Position(90.0, 85.0)));
            temp.add(new Bloob(new Position(130.0, 65.0)));
            temp.add(new Bloob(new Position(170.0, 125.0)));
            temp.add(new Bloob(new Position(30.0, 120.0)));
        } else if (x == 1 && y == 5) {
            WorldData.changeSong(MAIN_THEME_LOCATION);
            PlayAreaView.setBackgroundImage(Element.loadImage("forestb4.gif"));
            temp.add(new RectangleObstacle(new Position(0.0, 145.0), 200, 5, null));
            temp.add(new Bloob(new Position(90.0, 85.0)));
            temp.add(new Bloob(new Position(130.0, 75.0)));
            temp.add(new GreenTree(new Position(70.0, 20.0)));
            temp.add(new GreenTree(new Position(72.0, 40.0)));
            temp.add(new GreenTree(new Position(74.0, 60.0)));
            temp.add(new GreenTree(new Position(69.0, 80.0)));
            temp.add(new Ghost(new Position(100.0, 100.0), 7, 2.4, 20, Color.pink));
        } else if (x == 2 && y == 2) {
            WorldData.changeSong(MAIN_THEME_LOCATION);
            PlayAreaView.setBackgroundImage(Element.loadImage("forestc1.gif"));
            temp.add(new RectangleObstacle(new Position(0.0, 0.0), 200, 5, null));
            temp.add(new Bloob(new Position(81.0, 72.0)));
            temp.add(new Bloob(new Position(43.0, 34.0)));
            temp.add(new Bloob(new Position(163.0, 53.0)));
            temp.add(new Bloob(new Position(82.0, 93.0)));
            temp.add(new Bloob(new Position(93.0, 82.0)));
            temp.add(new Bloob(new Position(133.0, 35.0)));
            temp.add(new Bloob(new Position(173.0, 124.0)));
            temp.add(new Bloob(new Position(34.0, 124.0)));
            temp.add(new Bloob(new Position(100.0, 77.0)));
            temp.add(new Bloob(new Position(114.0, 23.0)));
            temp.add(new Bloob(new Position(33.0, 35.0)));
            temp.add(new Bloob(new Position(93.0, 94.0)));
            temp.add(new Bloob(new Position(25.0, 134.0)));
        } else if (x == 2 && y == 3) {
            WorldData.changeSong(MAIN_THEME_LOCATION);
            PlayAreaView.setBackgroundImage(Element.loadImage("forestc2.gif"));
            temp.add(new Ghost(new Position(122.0, 100.0), 7, 2.4, 40, Color.pink));
        } else if (x == 2 && y == 4) {
            WorldData.changeSong(MAIN_THEME_LOCATION);
            PlayAreaView.setBackgroundImage(Element.loadImage("forestc3.gif"));
            temp.add(new Healer(new Position(95.0, 60.0)));
        } else if (x == 2 && y == 5) {
            WorldData.changeSong(MAIN_THEME_LOCATION);
            PlayAreaView.setBackgroundImage(Element.loadImage("forestc4.gif"));
            temp.add(new RectangleObstacle(new Position(0.0, 145.0), 200, 5, null));
            temp.add(new Ghost(new Position(100.0, 40.0), 7, 2.4, 20, Color.pink));
            temp.add(new Ghost(new Position(100.0, 110.0), 7, 2.4, 20, Color.pink));
        } else if (x == 3 && y == 0) {
            WorldData.changeSong("file:sound/mountain.wav");
            PlayAreaView.setBackgroundImage(Element.loadImage("mountaina1.gif"));
            temp.add(new RectangleObstacle(new Position(0.0, 0.0), 200, 43, null));
            temp.add(new RectangleObstacle(new Position(0.0, 87.0), 77, 63, null));
            temp.add(new RectangleObstacle(new Position(0.0, 0.0), 20, 150, null));
            temp.add(new RectangleObstacle(new Position(0.0, 0.0), 45, 62, null));
            temp.add(new RectangleObstacle(new Position(113.0, 132.0), 87, 18, null));
            temp.add(new RectangleObstacle(new Position(107.0, 116.0), 93, 16, null));
            temp.add(new RectangleObstacle(new Position(94.0, 96.0), 106, 20, null));
            temp.add(new RectangleObstacle(new Position(88.0, 73.0), 101, 20, null));
            temp.add(new RectangleObstacle(new Position(113.0, 59.0), 15, 40, null));
            temp.add(new RectangleObstacle(new Position(162.0, 58.0), 25, 36, null));
            temp.add(new RectangleObstacle(new Position(199.0, 0.0), 1, 55, null));
            temp.add(new RectangleObstacle(new Position(199.0, 75.0), 1, 75, null));
            temp.add(new Guard(new Position(85.0, 95.0), 9));
            temp.add(new Crystal(new Position(195.0, 65.0), 1));
        } else if (x == 3 && y == 1) {
            WorldData.changeSong("file:sound/mountain.wav");
            PlayAreaView.setBackgroundImage(Element.loadImage("mountaina2.gif"));
            temp.add(new RectangleObstacle(new Position(0.0, 0.0), 5, 150, null));
            temp.add(new RectangleObstacle(new Position(0.0, 0.0), 50, 133, null));
            temp.add(new RectangleObstacle(new Position(0.0, 90.0), 75, 45, null));
            temp.add(new RectangleObstacle(new Position(0.0, 0.0), 50, 134, null));
            temp.add(new RectangleObstacle(new Position(0.0, 0.0), 69, 80, null));
            temp.add(new RectangleObstacle(new Position(0.0, 0.0), 90, 64, null));
            temp.add(new RectangleObstacle(new Position(118.0, 51.0), 82, 19, null));
            temp.add(new RectangleObstacle(new Position(163.0, 0.0), 37, 51, null));
            temp.add(new RectangleObstacle(new Position(133.0, 0.0), 67, 19, null));
            temp.add(new RectangleObstacle(new Position(104.0, 70.0), 96, 30, null));
            temp.add(new RectangleObstacle(new Position(148.0, 100.0), 52, 24, null));
            temp.add(new RectangleObstacle(new Position(113.0, 0.0), 87, 5, null));
            temp.add(new Bloob(new Position(140.0, 55.0)));
            temp.add(new Bloob(new Position(105.0, 110.0)));
        } else if (x == 3 && y == 2) {
            WorldData.changeSong(MAIN_THEME_LOCATION);
            PlayAreaView.setBackgroundImage(Element.loadImage("forestd1.gif"));
            temp.add(new RectangleObstacle(new Position(0.0, 0.0), 5, 5, null));
            temp.add(new RectangleObstacle(new Position(195.0, 137.0), 5, 13, null));
            temp.add(new Ghost(new Position(120.0, 110.0), 6, 1.6, 25, Color.blue));
            temp.add(new Ghost(new Position(50.0, 110.0), 6, 1.6, 25, Color.blue));
            temp.add(new Ghost(new Position(40.0, 35.0), 21, 0.6, 15, Color.yellow));
            temp.add(new Ghost(new Position(140.0, 35.0), 21, 0.6, 15, Color.yellow));
        } else if (x == 3 && y == 3) {
            WorldData.changeSong(MAIN_THEME_LOCATION);
            PlayAreaView.setBackgroundImage(Element.loadImage("forestd2.gif"));
            temp.add(new RectangleObstacle(new Position(195.0, 137.0), 5, 13, null));
            temp.add(new Ghost(new Position(120.0, 110.0), 6, 0.6, 21, Color.yellow));
            temp.add(new Ghost(new Position(40.0, 20.0), 12, 0.6, 50, Color.cyan));
            temp.add(new Ghost(new Position(170.0, 140.0), 10, 1.2, 22, Color.green));
            temp.add(new Ghost(new Position(30.0, 135.0), 15, 0.9, 80, Color.orange));
            temp.add(new Ghost(new Position(12.0, 100.0), 7, 2.4, 40, Color.pink));
            temp.add(new Ghost(new Position(100.0, 75.0), 6, 0.7, 25, Color.yellow));
            temp.add(new Ghost(new Position(40.0, 35.0), 12, 1.6, 15, Color.red));
            temp.add(new Crystal(new Position(100.0, 70.0), 11));
            temp.add(new GreenTree(new Position(110.0, 80.0)));
            temp.add(new GreenTree(new Position(175.0, 40.0)));
            temp.add(new GreenTree(new Position(90.0, 30.0)));
            temp.add(new GreenTree(new Position(30.0, 70.0)));
            temp.add(new GreenTree(new Position(35.0, 85.0)));
            temp.add(new YellowTree(new Position(170.0, 90.0)));
            temp.add(new YellowTree(new Position(100.0, 95.0)));
            temp.add(new YellowTree(new Position(10.0, 140.0)));
        } else if (x == 3 && y == 4) {
            WorldData.changeSong("file:sound/desert.wav");
            PlayAreaView.setBackgroundImage(Element.loadImage("forestd3.gif"));
            temp.add(new Bloob(new Position(20.0, 72.0)));
            temp.add(new Bloob(new Position(20.0, 122.0)));
            temp.add(new Bloob(new Position(81.0, 122.0)));
            temp.add(new Bloob(new Position(130.0, 138.0)));
            temp.add(new Bloob(new Position(172.0, 72.0)));
            temp.add(new Bloob(new Position(110.0, 72.0)));
            temp.add(new RedTree(new Position(30.0, 80.0)));
            temp.add(new RedTree(new Position(90.0, 83.0)));
            temp.add(new RedTree(new Position(170.0, 77.0)));
        } else if (x == 3 && y == 5) {
            WorldData.changeSong("file:sound/desert.wav");
            PlayAreaView.setBackgroundImage(Element.loadImage("forestd4.gif"));
            temp.add(new RectangleObstacle(new Position(0.0, 145.0), 200, 5, null));
            temp.add(new RectangleObstacle(new Position(195.0, 0.0), 5, 150, null));
            temp.add(new Ghost(new Position(40.0, 40.0), 7, 2.6, 20, Color.gray));
            temp.add(new Ghost(new Position(40.0, 110.0), 7, 2.6, 20, Color.gray));
            temp.add(new Ghost(new Position(160.0, 40.0), 7, 2.1, 20, Color.gray));
            temp.add(new Ghost(new Position(160.0, 110.0), 7, 2.1, 20, Color.gray));
            temp.add(new Ghost(new Position(100.0, 75.0), 7, 1.1, 20, Color.gray));
            temp.add(new Crystal(new Position(89.0, 111.0), 2));
        } else if (x == 4 && y == 0) {
            WorldData.changeSong("file:sound/mountain.wav");
            PlayAreaView.setBackgroundImage(Element.loadImage("entrence.gif"));
            temp.add(new RectangleObstacle(new Position(0.0, 0.0), 200, 61, null));
            temp.add(new RectangleObstacle(new Position(0.0, 70.0), 200, 80, null));
            temp.add(new DownSpike(new Position(40.0, 10.0)));
            temp.add(new DownSpike(new Position(100.0, 10.0)));
            temp.add(new DownSpike(new Position(160.0, 10.0)));
        } else if (x == 4 && y == 1) {
            WorldData.changeSong("file:sound/mountain.wav");
            PlayAreaView.setBackgroundImage(Element.loadImage("hilla1.gif"));
            temp.add(new RectangleObstacle(new Position(0.0, 0.0), 200, 5, null));
            temp.add(new RectangleObstacle(new Position(0.0, 0.0), 5, 124, null));
            temp.add(new Projectile(new Position(20.0, 10.0), 0.4, 6.6, 10.0, Color.lightGray));
            temp.add(new Projectile(new Position(65.0, 10.0), 0.0, 15.9, 12.0, Color.gray));
            temp.add(new Projectile(new Position(120.0, 10.0), -0.1, 13.6, 8.0, Color.lightGray));
            temp.add(new Projectile(new Position(160.0, 10.0), -0.6, 11.6, 11.0, Color.gray));
        } else if (x == 4 && y == 2) {
            WorldData.changeSong("file:sound/mountain.wav");
            PlayAreaView.setBackgroundImage(Element.loadImage("hilla2.gif"));
        } else if (x == 4 && y == 3) {
            WorldData.changeSong("file:sound/desert.wav");
            PlayAreaView.setBackgroundImage(Element.loadImage("deserta1.gif"));
        } else if (x == 4 && y == 4) {
            WorldData.changeSong("file:sound/desert.wav");
            PlayAreaView.setBackgroundImage(Element.loadImage("deserta2.gif"));
            temp.add(new RectangleObstacle(new Position(0.0, 137.0), 89, 13, null));
            temp.add(new RectangleObstacle(new Position(116.0, 137.0), 84, 13, null));
            temp.add(new Projectile(new Position(25.0, 20.0), 3.5, 0.0, 4.0, Color.darkGray));
            temp.add(new Projectile(new Position(195.0, 40.0), -2.5, 0.0, 4.0, Color.darkGray));
            temp.add(new Projectile(new Position(195.0, 60.0), -3.5, 0.0, 4.0, Color.darkGray));
            temp.add(new Projectile(new Position(25.0, 80.0), 1.9, 0.0, 4.0, Color.darkGray));
            temp.add(new Projectile(new Position(195.0, 100.0), -3.5, 0.0, 4.0, Color.darkGray));
            temp.add(new Projectile(new Position(25.0, 120.0), 2.5, 0.0, 4.0, Color.darkGray));
            temp.add(new Projectile(new Position(195.0, 140.0), -3.5, 0.0, 4.0, Color.darkGray));
        } else if (x == 4 && y == 5) {
            WorldData.changeSong("file:sound/cave.wav");
            PlayAreaView.setBackgroundImage(Element.loadImage("cavea1.gif"));
            ((AbstractCollection)temp).remove(you);
            temp.add(new SpikePit(new Position(160.0, 110.0), 40, 40, null));
            temp.add(you);
            temp.add(new RectangleObstacle(new Position(0.0, 0.0), 89, 26, null));
            temp.add(new RectangleObstacle(new Position(0.0, 0.0), 31, 150, null));
            temp.add(new RectangleObstacle(new Position(116.0, 0.0), 84, 30, null));
            temp.add(new Bloob(new Position(100.0, 70.0)));
        } else if (x == 4 && y == 6) {
            WorldData.changeSong("file:sound/cave.wav");
            ((AbstractCollection)temp).remove(you);
            temp.add(new SpikePit(new Position(160.0, 0.0), 40, 40, null));
            temp.add(you);
            PlayAreaView.setBackgroundImage(Element.loadImage("cavea2.gif"));
            temp.add(new RectangleObstacle(new Position(0.0, 0.0), 31, 150, null));
            temp.add(new RectangleObstacle(new Position(0.0, 100.0), 53, 50, null));
            temp.add(new RectangleObstacle(new Position(0.0, 126.0), 200, 24, null));
            temp.add(new Spiter(new Position(120.0, 115.0)));
            temp.add(new Crystal(new Position(100.0, 115.0), 3));
        } else if (x == 5 && y == 0) {
            WorldData.changeSong("file:sound/castle.wav");
            PlayAreaView.setBackgroundImage(Element.loadImage("dungeona1.gif"));
            temp.add(new RectangleObstacle(new Position(0.0, 0.0), 11, 55, null));
            temp.add(new RectangleObstacle(new Position(0.0, 75.0), 11, 75, null));
            temp.add(new RectangleObstacle(new Position(0.0, 0.0), 200, 8, null));
            temp.add(new RectangleObstacle(new Position(0.0, 140.0), 200, 10, null));
            temp.add(new RectangleObstacle(new Position(0.0, 0.0), 200, 8, null));
            temp.add(new RectangleObstacle(new Position(184.0, 0.0), 11, 71, null));
            temp.add(new RectangleObstacle(new Position(34.0, 48.0), 124, 41, null));
            temp.add(new RectangleObstacle(new Position(147.0, 89.0), 11, 61, null));
            temp.add(new RectangleObstacle(new Position(195.0, 0.0), 5, 28, null));
            temp.add(new Crystal(new Position(140.0, 110.0), 4));
            temp.add(new Bloob(new Position(130.0, 107.0)));
            temp.add(new Bloob(new Position(50.0, 117.0)));
            temp.add(new Bloob(new Position(100.0, 95.0)));
            temp.add(new Bloob(new Position(90.0, 50.0)));
            temp.add(new Bloob(new Position(175.0, 60.0)));
            temp.add(new Ghost(new Position(120.0, 110.0), 6, 0.6, 21, Color.white));
            temp.add(new Ghost(new Position(40.0, 20.0), 12, 0.6, 50, Color.gray));
            temp.add(new Ghost(new Position(170.0, 140.0), 10, 1.2, 22, Color.blue));
            temp.add(new Ghost(new Position(30.0, 135.0), 15, 0.9, 80, Color.darkGray));
            temp.add(new Ghost(new Position(12.0, 100.0), 7, 2.4, 40, Color.cyan));
            temp.add(new Ghost(new Position(100.0, 75.0), 6, 0.7, 25, Color.black));
            temp.add(new Ghost(new Position(40.0, 35.0), 12, 1.6, 15, Color.gray));
        } else if (x == 5 && y == 1) {
            WorldData.changeSong("file:sound/mountain.wav");
            PlayAreaView.setBackgroundImage(Element.loadImage("hillb1.gif"));
            temp.add(new RectangleObstacle(new Position(0.0, 0.0), 200, 5, null));
            temp.add(new CrystalGiver(new Position(120.0, 70.0), 5));
        } else if (x == 5 && y == 2) {
            WorldData.changeSong("file:sound/mountain.wav");
            PlayAreaView.setBackgroundImage(Element.loadImage("hillb2.gif"));
        } else if (x == 5 && y == 3) {
            WorldData.changeSong("file:sound/desert.wav");
            PlayAreaView.setBackgroundImage(Element.loadImage("desertb1.gif"));
            temp.add(new RectangleObstacle(new Position(195.0, 0.0), 5, 5, null));
            temp.add(new RectangleObstacle(new Position(195.0, 145.0), 5, 5, null));
            temp.add(new Projectile(new Position(190.0, 25.0), -3.5, 0.0, 4.0, Color.darkGray));
            temp.add(new Projectile(new Position(190.0, 45.0), -2.5, 0.0, 4.0, Color.darkGray));
            temp.add(new Projectile(new Position(190.0, 65.0), -3.5, 0.0, 4.0, Color.darkGray));
            temp.add(new Projectile(new Position(190.0, 85.0), -1.8, 0.0, 4.0, Color.darkGray));
            temp.add(new Projectile(new Position(190.0, 105.0), -3.5, 0.0, 4.0, Color.darkGray));
            temp.add(new Projectile(new Position(190.0, 125.0), -2.5, 0.0, 4.0, Color.darkGray));
            temp.add(new Projectile(new Position(190.0, 140.0), -3.5, 0.0, 4.0, Color.darkGray));
        } else if (x == 5 && y == 4) {
            WorldData.changeSong("file:sound/desert.wav");
            PlayAreaView.setBackgroundImage(Element.loadImage("desertb2.gif"));
            temp.add(new RectangleObstacle(new Position(0.0, 137.0), 200, 13, null));
            temp.add(new RectangleObstacle(new Position(195.0, 0.0), 5, 150, null));
            temp.add(new Projectile(new Position(190.0, 25.0), -3.5, 0.0, 4.0, Color.darkGray));
            temp.add(new Projectile(new Position(190.0, 45.0), -2.5, 0.0, 4.0, Color.darkGray));
            temp.add(new Projectile(new Position(190.0, 65.0), -3.5, 0.0, 4.0, Color.darkGray));
            temp.add(new Projectile(new Position(190.0, 85.0), -1.8, 0.0, 4.0, Color.darkGray));
            temp.add(new Projectile(new Position(190.0, 105.0), -3.5, 0.0, 4.0, Color.darkGray));
            temp.add(new Projectile(new Position(190.0, 125.0), -2.5, 0.0, 4.0, Color.darkGray));
            temp.add(new Projectile(new Position(190.0, 140.0), -3.5, 0.0, 4.0, Color.darkGray));
        } else if (x == 5 && y == 5) {
            WorldData.changeSong("file:sound/cave.wav");
            PlayAreaView.setBackgroundImage(Element.loadImage("caveb1.gif"));
            ((AbstractCollection)temp).remove(you);
            temp.add(new SpikePit(new Position(0.0, 110.0), 40, 40, null));
            temp.add(you);
            temp.add(new RectangleObstacle(new Position(179.0, 0.0), 21, 150, null));
            temp.add(new RectangleObstacle(new Position(0.0, 0.0), 200, 30, null));
            temp.add(new DownSpike(new Position(67.0, 10.0)));
            temp.add(new UpSpike(new Position(67.0, 140.0)));
            temp.add(new DownSpike(new Position(134.0, 10.0)));
            temp.add(new UpSpike(new Position(134.0, 140.0)));
            temp.add(new Crystal(new Position(134.0, 80.0), 6));
        } else if (x == 5 && y == 6) {
            WorldData.changeSong("file:sound/cave.wav");
            PlayAreaView.setBackgroundImage(Element.loadImage("caveb2.gif"));
            ((AbstractCollection)temp).remove(you);
            temp.add(new SpikePit(new Position(0.0, 0.0), 40, 40, null));
            temp.add(you);
            temp.add(new RectangleObstacle(new Position(0.0, 126.0), 200, 24, null));
            temp.add(new RectangleObstacle(new Position(161.0, 42.0), 39, 108, null));
            temp.add(new RectangleObstacle(new Position(179.0, 0.0), 21, 42, null));
            temp.add(new BiGhost(new Position(100.0, 80.0)));
            temp.add(new Crystal(new Position(160.0, 120.0), 7));
        } else if (x == 6 && y == 0) {
            WorldData.changeSong("file:sound/castle.wav");
            PlayAreaView.setBackgroundImage(Element.loadImage("dungeonb1.gif"));
            temp.add(new RectangleObstacle(new Position(0.0, 0.0), 111, 28, null));
            temp.add(new RectangleObstacle(new Position(0.0, 139.0), 200, 11, null));
            temp.add(new RectangleObstacle(new Position(10.0, 76.0), 16, 74, null));
            temp.add(new RectangleObstacle(new Position(65.0, 0.0), 16, 109, null));
            temp.add(new RectangleObstacle(new Position(111.0, 0.0), 89, 7, null));
            temp.add(new RectangleObstacle(new Position(135.0, 29.0), 65, 29, null));
            temp.add(new RectangleObstacle(new Position(135.0, 79.0), 65, 32, null));
            temp.add(new Ghost(new Position(60.0, 75.0)));
            temp.add(new Ghost(new Position(100.0, 75.0)));
            temp.add(new UpSpike(new Position(40.0, 140.0)));
            temp.add(new DownSpike(new Position(40.0, 10.0)));
        } else if (x == 6 && y == 1) {
            WorldData.changeSong("file:sound/forest.wav");
            PlayAreaView.setBackgroundImage(Element.loadImage("forest.gif"));
            temp.add(new RectangleObstacle(new Position(0.0, 0.0), 200, 5, null));
            temp.add(new RedTree(new Position(192.0, 144.0)));
            temp.add(new RedTree(new Position(100.0, 73.0)));
            temp.add(new RedTree(new Position(50.0, 93.0)));
            temp.add(new RedTree(new Position(35.0, -4.0)));
            temp.add(new YellowTree(new Position(60.0, -5.0)));
            temp.add(new YellowTree(new Position(73.0, -1.0)));
            temp.add(new GreenTree(new Position(70.0, 20.0)));
            temp.add(new YellowTree(new Position(0.0, -7.0)));
            temp.add(new RedTree(new Position(101.0, 7.0)));
            temp.add(new RedTree(new Position(45.0, 19.0)));
            temp.add(new RedTree(new Position(55.0, 32.0)));
            temp.add(new YellowTree(new Position(75.0, 49.0)));
            temp.add(new YellowTree(new Position(34.0, 50.0)));
            temp.add(new GreenTree(new Position(70.0, 125.0)));
            temp.add(new YellowTree(new Position(20.0, 130.0)));
            temp.add(new GreenTree(new Position(90.0, 115.0)));
            temp.add(new GreenTree(new Position(170.0, 140.0)));
            temp.add(new GreenTree(new Position(40.0, 100.0)));
            temp.add(new YellowTree(new Position(120.0, 30.0)));
            temp.add(new GreenTree(new Position(150.0, 115.0)));
            temp.add(new GreenTree(new Position(190.0, 40.0)));
            temp.add(new RedTree(new Position(170.0, 80.0)));
            temp.add(new GreenTree(new Position(0.0, 110.0)));
            temp.add(new RedTree(new Position(185.0, 10.0)));
        } else if (x == 6 && y == 2) {
            WorldData.changeSong("file:sound/forest.wav");
            PlayAreaView.setBackgroundImage(Element.loadImage("forest.gif"));
            temp.add(new RectangleObstacle(new Position(195.0, 0.0), 5, 150, null));
            temp.add(new RedTree(new Position(50.0, 93.0)));
            temp.add(new RedTree(new Position(175.0, 130.0)));
            temp.add(new GreenTree(new Position(70.0, 20.0)));
            temp.add(new RedTree(new Position(101.0, 7.0)));
            temp.add(new RedTree(new Position(45.0, 19.0)));
            temp.add(new RedTree(new Position(55.0, 32.0)));
            temp.add(new YellowTree(new Position(75.0, 49.0)));
            temp.add(new YellowTree(new Position(34.0, 50.0)));
            temp.add(new GreenTree(new Position(70.0, 125.0)));
            temp.add(new YellowTree(new Position(20.0, 130.0)));
            temp.add(new GreenTree(new Position(90.0, 115.0)));
            temp.add(new GreenTree(new Position(170.0, 140.0)));
            temp.add(new GreenTree(new Position(40.0, 100.0)));
            temp.add(new YellowTree(new Position(120.0, 30.0)));
            temp.add(new GreenTree(new Position(150.0, 115.0)));
            temp.add(new GreenTree(new Position(190.0, 40.0)));
            temp.add(new RedTree(new Position(170.0, 80.0)));
            temp.add(new GreenTree(new Position(0.0, 110.0)));
            temp.add(new RedTree(new Position(185.0, 10.0)));
            temp.add(new Healer(new Position(159.0, 25.0)));
        } else if (x == 6 && y == 3) {
            WorldData.changeSong("file:sound/desert.wav");
            PlayAreaView.setBackgroundImage(Element.loadImage("place.gif"));
            temp.add(new RectangleObstacle(new Position(0.0, 145.0), 200, 5, null));
            temp.add(new RectangleObstacle(new Position(195.0, 0.0), 5, 150, null));
            temp.add(new Crystal(new Position(100.0, 75.0), 8));
        } else if (x == 7 && y == 0) {
            WorldData.changeSong("file:sound/castle.wav");
            PlayAreaView.setBackgroundImage(Element.loadImage("dungeonc1.gif"));
            temp.add(new RectangleObstacle(new Position(0.0, 0.0), 110, 7, null));
            temp.add(new RectangleObstacle(new Position(0.0, 29.0), 76, 29, null));
            temp.add(new RectangleObstacle(new Position(0.0, 79.0), 76, 32, null));
            temp.add(new RectangleObstacle(new Position(0.0, 139.0), 200, 11, null));
            temp.add(new RectangleObstacle(new Position(59.0, 29.0), 17, 82, null));
            temp.add(new RectangleObstacle(new Position(110.0, 0.0), 90, 42, null));
            temp.add(new RectangleObstacle(new Position(65.0, 61.0), 91, 31, null));
            temp.add(new RectangleObstacle(new Position(141.0, 61.0), 15, 89, null));
            temp.add(new RectangleObstacle(new Position(189.0, 0.0), 11, 57, null));
            temp.add(new RectangleObstacle(new Position(189.0, 79.0), 11, 71, null));
            temp.add(new Guard(new Position(140.0, 55.0), 12));
            temp.add(new Healer(new Position(115.0, 108.0)));
            temp.add(new Bloob(new Position(25.0, 70.0)));
            temp.add(new Crystal(new Position(48.0, 70.0), 9));
        } else if (x == 7 && y == 1) {
            WorldData.changeSong("file:sound/forest.wav");
            PlayAreaView.setBackgroundImage(Element.loadImage("forest.gif"));
            temp.add(new RectangleObstacle(new Position(0.0, 0.0), 200, 5, null));
            temp.add(new RectangleObstacle(new Position(195.0, 0.0), 5, 150, null));
            temp.add(new YellowTree(new Position(3.0, 145.0)));
            temp.add(new RedTree(new Position(50.0, 93.0)));
            temp.add(new RedTree(new Position(175.0, 130.0)));
            temp.add(new RedTree(new Position(35.0, -4.0)));
            temp.add(new YellowTree(new Position(60.0, -5.0)));
            temp.add(new YellowTree(new Position(73.0, -1.0)));
            temp.add(new GreenTree(new Position(70.0, 20.0)));
            temp.add(new YellowTree(new Position(0.0, -7.0)));
            temp.add(new RedTree(new Position(101.0, 7.0)));
            temp.add(new RedTree(new Position(45.0, 19.0)));
            temp.add(new RedTree(new Position(55.0, 32.0)));
            temp.add(new YellowTree(new Position(75.0, 49.0)));
            temp.add(new YellowTree(new Position(34.0, 50.0)));
            temp.add(new GreenTree(new Position(70.0, 125.0)));
            temp.add(new YellowTree(new Position(20.0, 130.0)));
            temp.add(new GreenTree(new Position(90.0, 115.0)));
            temp.add(new GreenTree(new Position(170.0, 140.0)));
            temp.add(new GreenTree(new Position(40.0, 100.0)));
            temp.add(new YellowTree(new Position(120.0, 30.0)));
            temp.add(new GreenTree(new Position(150.0, 115.0)));
            temp.add(new GreenTree(new Position(190.0, 40.0)));
            temp.add(new RedTree(new Position(170.0, 80.0)));
            temp.add(new GreenTree(new Position(0.0, 110.0)));
            temp.add(new RedTree(new Position(185.0, 10.0)));
        } else if (x == 7 && y == 2) {
            WorldData.changeSong("file:sound/forest.wav");
            PlayAreaView.setBackgroundImage(Element.loadImage("forest.gif"));
            temp.add(new RectangleObstacle(new Position(195.0, 0.0), 5, 150, null));
            temp.add(new RectangleObstacle(new Position(0.0, 0.0), 5, 150, null));
            temp.add(new RedTree(new Position(50.0, 93.0)));
            temp.add(new RedTree(new Position(175.0, 130.0)));
            temp.add(new GreenTree(new Position(70.0, 20.0)));
            temp.add(new RedTree(new Position(101.0, 7.0)));
            temp.add(new RedTree(new Position(45.0, 19.0)));
            temp.add(new RedTree(new Position(55.0, 32.0)));
            temp.add(new YellowTree(new Position(75.0, 49.0)));
            temp.add(new YellowTree(new Position(34.0, 50.0)));
            temp.add(new GreenTree(new Position(70.0, 125.0)));
            temp.add(new YellowTree(new Position(20.0, 130.0)));
            temp.add(new GreenTree(new Position(90.0, 115.0)));
            temp.add(new GreenTree(new Position(170.0, 140.0)));
            temp.add(new GreenTree(new Position(40.0, 100.0)));
            temp.add(new YellowTree(new Position(120.0, 30.0)));
            temp.add(new GreenTree(new Position(150.0, 115.0)));
            temp.add(new GreenTree(new Position(190.0, 40.0)));
            temp.add(new RedTree(new Position(170.0, 80.0)));
            temp.add(new GreenTree(new Position(0.0, 110.0)));
            temp.add(new RedTree(new Position(185.0, 10.0)));
        } else if (x == 7 && y == 3) {
            WorldData.changeSong("file:sound/grave.wav");
            PlayAreaView.setBackgroundImage(Element.loadImage("grave.gif"));
            temp.add(new RectangleObstacle(new Position(0.0, 145.0), 200, 5, null));
            temp.add(new RectangleObstacle(new Position(195.0, 0.0), 5, 150, null));
            temp.add(new RectangleObstacle(new Position(0.0, 0.0), 5, 150, null));
            temp.add(new Ghost(new Position(100.0, 80.0)));
            temp.add(new Spiter(new Position(100.0, 75.0)));
            temp.add(new Crystal(new Position(190.0, 140.0), 10));
        } else if (x == 8 && y == 0) {
            WorldData.changeSong("file:sound/boss.wav");
            PlayAreaView.setBackgroundImage(Element.loadImage("boss.gif"));
            temp.add(new RectangleObstacle(new Position(0.0, 0.0), 15, 57, null));
            temp.add(new RectangleObstacle(new Position(0.0, 79.0), 15, 71, null));
            temp.add(new RectangleObstacle(new Position(0.0, 0.0), 200, 8, null));
            temp.add(new RectangleObstacle(new Position(0.0, 134.0), 200, 16, null));
            temp.add(new RectangleObstacle(new Position(180.0, 0.0), 20, 150, null));
            temp.add(new BadEye(new Position(160.0, 70.0), 12, 8));
            temp.add(new Spiter(new Position(16.0, 9.0)));
            temp.add(new Spiter(new Position(16.0, 133.0)));
            temp.add(new Spiter(new Position(179.0, 9.0)));
            temp.add(new Spiter(new Position(179.0, 133.0)));
            temp.add(new Ghost(new Position(30.0, 30.0), 6, 1.2, 60, Color.gray));
            temp.add(new Ghost(new Position(33.0, 34.0), 6, 0.5, 60, Color.gray));
            temp.add(new Ghost(new Position(160.0, 30.0), 6, 1.2, 60, Color.gray));
            temp.add(new Ghost(new Position(163.0, 34.0), 6, 0.5, 60, Color.gray));
            temp.add(new Ghost(new Position(30.0, 130.0), 6, 1.2, 60, Color.gray));
            temp.add(new Ghost(new Position(33.0, 134.0), 6, 0.5, 60, Color.gray));
            temp.add(new Ghost(new Position(130.0, 130.0), 6, 1.2, 60, Color.gray));
            temp.add(new Ghost(new Position(133.0, 134.0), 6, 0.5, 60, Color.gray));
        }
        return temp;
    }

    public static void changeSong(String newSong) {
        if (!CURRENT_SONG_LOACTION.equals(newSong)) {
            if (song != null) {
                WorldData.stopSong();
            }
            song = Element.loadAudioClip(newSong);
            CURRENT_SONG_LOACTION = newSong;
            if (song != null) {
                song.loop();
            }
        }
    }

    public static void playSong(String newSong) {
        if (!CURRENT_SONG_LOACTION.equals(newSong)) {
            if (song != null) {
                WorldData.stopSong();
            }
            song = Element.loadAudioClip(newSong);
            CURRENT_SONG_LOACTION = newSong;
            if (song != null) {
                song.play();
            }
        }
    }

    public static void stopSong() {
        if (song != null) {
            song.stop();
        }
    }

    static {
        MAIN_THEME_LOCATION = "file:sound/main.wav";
        KING_THEME_LOCATION = "file:sound/king.wav";
        CASTLE_THEME_LOCATION = "file:sound/castle.wav";
        CURRENT_SONG_LOACTION = "";
    }
}

