/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.WindowConstants;

public class JDialog
extends Dialog
implements WindowConstants,
Accessible,
RootPaneContainer {
    private int defaultCloseOperation = 1;
    protected JRootPane rootPane;
    protected boolean rootPaneCheckingEnabled = false;
    protected AccessibleContext accessibleContext = null;

    public JDialog() {
        this((Frame)null, false);
    }

    public JDialog(Dialog dialog) {
        this(dialog, false);
    }

    public JDialog(Dialog dialog, String string) {
        this(dialog, string, false);
    }

    public JDialog(Dialog dialog, String string, boolean bl) {
        super(dialog, string, bl);
        this.dialogInit();
    }

    public JDialog(Dialog dialog, boolean bl) {
        this(dialog, null, bl);
    }

    public JDialog(Frame frame) {
        this(frame, false);
    }

    public JDialog(Frame frame, String string) {
        this(frame, string, false);
    }

    public JDialog(Frame frame, String string, boolean bl) {
        super(frame == null ? SwingUtilities.getSharedOwnerFrame() : frame, string, bl);
        this.dialogInit();
    }

    public JDialog(Frame frame, boolean bl) {
        this(frame, null, bl);
    }

    protected void addImpl(Component component, Object object, int n) {
        if (this.isRootPaneCheckingEnabled()) {
            throw this.createRootPaneException("add");
        }
        super.addImpl(component, object, n);
    }

    protected JRootPane createRootPane() {
        return new JRootPane();
    }

    private Error createRootPaneException(String string) {
        String string2 = this.getClass().getName();
        return new Error("Do not use " + string2 + "." + string + "() use " + string2 + ".getContentPane()." + string + "() instead");
    }

    protected void dialogInit() {
        this.enableEvents(64L);
        this.setRootPane(this.createRootPane());
        this.setRootPaneCheckingEnabled(true);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJDialog();
        }
        return this.accessibleContext;
    }

    public Container getContentPane() {
        return this.getRootPane().getContentPane();
    }

    public int getDefaultCloseOperation() {
        return this.defaultCloseOperation;
    }

    public Component getGlassPane() {
        return this.getRootPane().getGlassPane();
    }

    public JMenuBar getJMenuBar() {
        return this.getRootPane().getMenuBar();
    }

    public JLayeredPane getLayeredPane() {
        return this.getRootPane().getLayeredPane();
    }

    public JRootPane getRootPane() {
        return this.rootPane;
    }

    protected boolean isRootPaneCheckingEnabled() {
        return this.rootPaneCheckingEnabled;
    }

    protected String paramString() {
        String string = this.defaultCloseOperation == 1 ? "HIDE_ON_CLOSE" : (this.defaultCloseOperation == 2 ? "DISPOSE_ON_CLOSE" : (this.defaultCloseOperation == 0 ? "DO_NOTHING_ON_CLOSE" : ""));
        String string2 = this.rootPane != null ? this.rootPane.toString() : "";
        String string3 = this.rootPaneCheckingEnabled ? "true" : "false";
        return String.valueOf(super.paramString()) + ",defaultCloseOperation=" + string + ",rootPane=" + string2 + ",rootPaneCheckingEnabled=" + string3;
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        if (windowEvent.getID() == 201) {
            switch (this.defaultCloseOperation) {
                case 1: {
                    ((Component)this).setVisible(false);
                    break;
                }
                case 2: {
                    ((Component)this).setVisible(false);
                    this.dispose();
                    break;
                }
            }
        }
    }

    public void setContentPane(Container container) {
        this.getRootPane().setContentPane(container);
    }

    public void setDefaultCloseOperation(int n) {
        this.defaultCloseOperation = n;
    }

    public void setGlassPane(Component component) {
        this.getRootPane().setGlassPane(component);
    }

    public void setJMenuBar(JMenuBar jMenuBar) {
        this.getRootPane().setMenuBar(jMenuBar);
    }

    public void setLayeredPane(JLayeredPane jLayeredPane) {
        this.getRootPane().setLayeredPane(jLayeredPane);
    }

    public void setLayout(LayoutManager layoutManager) {
        if (this.isRootPaneCheckingEnabled()) {
            throw this.createRootPaneException("setLayout");
        }
        super.setLayout(layoutManager);
    }

    public void setLocationRelativeTo(Component component) {
        Serializable serializable;
        Serializable serializable2 = null;
        if (component != null) {
            if (component instanceof Window || component instanceof Applet) {
                serializable2 = (Container)component;
            } else {
                serializable = component.getParent();
                while (serializable != null) {
                    if (serializable instanceof Window || serializable instanceof Applet) {
                        serializable2 = serializable;
                        break;
                    }
                    serializable = ((Component)serializable).getParent();
                }
            }
        }
        if (component != null && !component.isShowing() || serializable2 == null || !serializable2.isShowing()) {
            serializable = this.getSize();
            Dimension dimension = this.getToolkit().getScreenSize();
            ((Component)this).setLocation((dimension.width - ((Dimension)serializable).width) / 2, (dimension.height - ((Dimension)serializable).height) / 2);
        } else {
            serializable = component.getSize();
            Point point = component.getLocationOnScreen();
            Rectangle rectangle = this.getBounds();
            int n = point.x + (((Dimension)serializable).width - rectangle.width >> 1);
            int n2 = point.y + (((Dimension)serializable).height - rectangle.height >> 1);
            Dimension dimension = this.getToolkit().getScreenSize();
            if (n2 + rectangle.height > dimension.height) {
                n2 = dimension.height - rectangle.height;
                int n3 = n = point.x < dimension.width >> 1 ? point.x + ((Dimension)serializable).width : point.x - rectangle.width;
            }
            if (n + rectangle.width > dimension.width) {
                n = dimension.width - rectangle.width;
            }
            if (n < 0) {
                n = 0;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            ((Component)this).setLocation(n, n2);
        }
    }

    protected void setRootPane(JRootPane jRootPane) {
        if (this.rootPane != null) {
            this.remove(this.rootPane);
        }
        this.rootPane = jRootPane;
        if (this.rootPane != null) {
            boolean bl = this.isRootPaneCheckingEnabled();
            try {
                this.setRootPaneCheckingEnabled(false);
                this.add((Component)this.rootPane, "Center");
            }
            finally {
                Object var4_3 = null;
                this.setRootPaneCheckingEnabled(bl);
            }
        }
    }

    protected void setRootPaneCheckingEnabled(boolean bl) {
        this.rootPaneCheckingEnabled = bl;
    }

    public void update(Graphics graphics) {
        ((Container)this).paint(graphics);
    }

    protected class AccessibleJDialog
    extends AccessibleContext
    implements Serializable,
    AccessibleComponent {
        protected AccessibleJDialog() {
        }

        public void addFocusListener(FocusListener focusListener) {
            JDialog.this.addFocusListener(focusListener);
        }

        public boolean contains(Point point) {
            return JDialog.this.contains(point);
        }

        public Accessible getAccessibleAt(Point point) {
            return SwingUtilities.getAccessibleAt(JDialog.this, point);
        }

        public Accessible getAccessibleChild(int n) {
            return SwingUtilities.getAccessibleChild(JDialog.this, n);
        }

        public int getAccessibleChildrenCount() {
            return SwingUtilities.getAccessibleChildrenCount(JDialog.this);
        }

        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        public int getAccessibleIndexInParent() {
            return SwingUtilities.getAccessibleIndexInParent(JDialog.this);
        }

        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            if (JDialog.this.getTitle() == null) {
                return super.getAccessibleName();
            }
            return JDialog.this.getTitle();
        }

        public Accessible getAccessibleParent() {
            if (this.accessibleParent != null) {
                return this.accessibleParent;
            }
            Container container = JDialog.this.getParent();
            if (container instanceof Accessible) {
                return (Accessible)((Object)container);
            }
            return null;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.DIALOG;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = SwingUtilities.getAccessibleStateSet(JDialog.this);
            if (JDialog.this.isResizable()) {
                accessibleStateSet.add(AccessibleState.RESIZABLE);
            }
            if (JDialog.this.getFocusOwner() != null) {
                accessibleStateSet.add(AccessibleState.ACTIVE);
            }
            if (JDialog.this.isModal()) {
                accessibleStateSet.add(AccessibleState.MODAL);
            }
            return accessibleStateSet;
        }

        public Color getBackground() {
            return ((Component)JDialog.this).getBackground();
        }

        public Rectangle getBounds() {
            return JDialog.this.getBounds();
        }

        public Cursor getCursor() {
            return JDialog.this.getCursor();
        }

        public Font getFont() {
            return JDialog.this.getFont();
        }

        public FontMetrics getFontMetrics(Font font) {
            return JDialog.this.getFontMetrics(font);
        }

        public Color getForeground() {
            return JDialog.this.getForeground();
        }

        public Locale getLocale() {
            return JDialog.this.getLocale();
        }

        public Point getLocation() {
            return JDialog.this.getLocation();
        }

        public Point getLocationOnScreen() {
            return JDialog.this.getLocationOnScreen();
        }

        public Dimension getSize() {
            return JDialog.this.getSize();
        }

        public boolean isEnabled() {
            return JDialog.this.isEnabled();
        }

        public boolean isFocusTraversable() {
            return JDialog.this.isFocusTraversable();
        }

        public boolean isShowing() {
            return JDialog.this.isShowing();
        }

        public boolean isVisible() {
            return JDialog.this.isVisible();
        }

        public void removeFocusListener(FocusListener focusListener) {
            JDialog.this.removeFocusListener(focusListener);
        }

        public void requestFocus() {
            JDialog.this.requestFocus();
        }

        public void setBackground(Color color) {
            ((Component)JDialog.this).setBackground(color);
        }

        public void setBounds(Rectangle rectangle) {
            ((Component)JDialog.this).setBounds(rectangle);
        }

        public void setCursor(Cursor cursor) {
            ((Component)JDialog.this).setCursor(cursor);
        }

        public void setEnabled(boolean bl) {
            JDialog.this.setEnabled(bl);
        }

        public void setFont(Font font) {
            JDialog.this.setFont(font);
        }

        public void setForeground(Color color) {
            JDialog.this.setForeground(color);
        }

        public void setLocation(Point point) {
            ((Component)JDialog.this).setLocation(point);
        }

        public void setSize(Dimension dimension) {
            ((Component)JDialog.this).setSize(dimension);
        }

        public void setVisible(boolean bl) {
            ((Component)JDialog.this).setVisible(bl);
        }
    }
}

