/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.lang.reflect.Method;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.BreakIterator;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Segment;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.TabExpander;

public class Utilities {
    static boolean is1dot2 = false;
    static /* synthetic */ Class class$java$awt$Toolkit;

    static {
        try {
            Method method = (class$java$awt$Toolkit != null ? class$java$awt$Toolkit : (class$java$awt$Toolkit = Utilities.class$("java.awt.Toolkit"))).getMethod("getMaximumCursorColors", null);
            is1dot2 = method != null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            is1dot2 = false;
        }
        if (!is1dot2) {
            System.err.println("warning: running 1.2 version of Utilities");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static int drawComposedText(AttributeSet attributeSet, Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
        Graphics2D graphics2D = (Graphics2D)graphics;
        AttributedString attributedString = (AttributedString)attributeSet.getAttribute(StyleConstants.ComposedTextAttribute);
        attributedString.addAttribute(TextAttribute.FONT, graphics.getFont());
        if (n3 >= n4) {
            return n;
        }
        AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator(null, n3, n4);
        TextLayout textLayout = new TextLayout(attributedCharacterIterator, graphics2D.getFontRenderContext());
        textLayout.draw(graphics2D, n, n2);
        return n + (int)textLayout.getAdvance();
    }

    public static final int drawTabbedText(Segment segment, int n, int n2, Graphics graphics, TabExpander tabExpander, int n3) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n4 = n;
        char[] cArray = segment.array;
        int n5 = 0;
        int n6 = segment.offset;
        int n7 = segment.offset + segment.count;
        int n8 = segment.offset;
        while (n8 < n7) {
            if (cArray[n8] == '\t') {
                if (n5 > 0) {
                    graphics.drawChars(cArray, n6, n5, n, n2);
                    n5 = 0;
                }
                n6 = n8 + 1;
                n4 = tabExpander != null ? (int)tabExpander.nextTabStop(n4, n3 + n8 - segment.offset) : (n4 += fontMetrics.charWidth(' '));
                n = n4;
            } else if (cArray[n8] == '\n' || cArray[n8] == '\r') {
                if (n5 > 0) {
                    graphics.drawChars(cArray, n6, n5, n, n2);
                    n5 = 0;
                }
                n6 = n8 + 1;
                n = n4;
            } else {
                ++n5;
                n4 += fontMetrics.charWidth(cArray[n8]);
            }
            ++n8;
        }
        if (n5 > 0) {
            graphics.drawChars(cArray, n6, n5, n, n2);
        }
        return n4;
    }

    public static final int getBreakLocation(Segment segment, FontMetrics fontMetrics, int n, int n2, TabExpander tabExpander, int n3) {
        int n4 = Utilities.getTabbedTextOffset(segment, fontMetrics, n, n2, tabExpander, n3, false);
        int n5 = segment.offset + Math.min(n4, segment.count - 1);
        while (n5 >= segment.offset) {
            char c = segment.array[n5];
            if (Character.isWhitespace(c)) {
                n4 = n5 - segment.offset + 1;
                break;
            }
            --n5;
        }
        return n4;
    }

    public static final int getNextWord(JTextComponent jTextComponent, int n) throws BadLocationException {
        Element element = Utilities.getParagraphElement(jTextComponent, n);
        int n2 = Utilities.getNextWordInParagraph(element, n, false);
        while (n2 == -1) {
            n = element.getEndOffset();
            element = Utilities.getParagraphElement(jTextComponent, n);
            n2 = Utilities.getNextWordInParagraph(element, n, true);
        }
        return n2;
    }

    static int getNextWordInParagraph(Element element, int n, boolean bl) throws BadLocationException {
        if (element == null) {
            throw new BadLocationException("No more words", n);
        }
        Document document = element.getDocument();
        int n2 = element.getStartOffset();
        int n3 = Math.min(element.getEndOffset(), document.getLength());
        if (n >= n3 || n < n2) {
            throw new BadLocationException("No more words", n);
        }
        String string = document.getText(n2, n3 - n2);
        BreakIterator breakIterator = BreakIterator.getWordInstance();
        breakIterator.setText(string);
        if (bl && breakIterator.first() == n - n2 && !Character.isWhitespace(string.charAt(breakIterator.first()))) {
            return n;
        }
        int n4 = breakIterator.following(n - n2);
        if (n4 == -1 || n4 >= string.length()) {
            return -1;
        }
        char c = string.charAt(n4);
        if (!Character.isWhitespace(c)) {
            return n2 + n4;
        }
        n4 = breakIterator.next();
        if (n4 != -1 && (n = n2 + n4) != n3) {
            return n;
        }
        return -1;
    }

    public static final Element getParagraphElement(JTextComponent jTextComponent, int n) {
        int n2;
        Document document = jTextComponent.getDocument();
        if (document instanceof StyledDocument) {
            return ((StyledDocument)document).getParagraphElement(n);
        }
        Element element = document.getDefaultRootElement();
        Element element2 = element.getElement(n2 = element.getElementIndex(n));
        if (n >= element2.getStartOffset() && n < element2.getEndOffset()) {
            return element2;
        }
        return null;
    }

    public static final int getPositionAbove(JTextComponent jTextComponent, int n, int n2) throws BadLocationException {
        int n3 = Utilities.getRowStart(jTextComponent, n) - 1;
        int n4 = Short.MAX_VALUE;
        int n5 = 0;
        Rectangle rectangle = null;
        if (n3 >= 0) {
            rectangle = jTextComponent.modelToView(n3);
            n5 = rectangle.y;
        }
        while (rectangle != null && n5 == rectangle.y) {
            int n6 = Math.abs(rectangle.x - n2);
            if (n6 < n4) {
                n = n3;
                n4 = n6;
            }
            Rectangle rectangle2 = rectangle = --n3 >= 0 ? jTextComponent.modelToView(n3) : null;
        }
        return n;
    }

    public static final int getPositionBelow(JTextComponent jTextComponent, int n, int n2) throws BadLocationException {
        int n3 = Utilities.getRowEnd(jTextComponent, n) + 1;
        int n4 = Short.MAX_VALUE;
        int n5 = jTextComponent.getDocument().getLength();
        int n6 = 0;
        Rectangle rectangle = null;
        if (n3 <= n5) {
            rectangle = jTextComponent.modelToView(n3);
            n6 = rectangle.y;
        }
        while (rectangle != null && n6 == rectangle.y) {
            int n7 = Math.abs(n2 - rectangle.x);
            if (n7 < n4) {
                n = n3;
                n4 = n7;
            }
            Rectangle rectangle2 = rectangle = ++n3 <= n5 ? jTextComponent.modelToView(n3) : null;
        }
        return n;
    }

    static int getPrevWordInParagraph(Element element, int n) throws BadLocationException {
        int n2;
        if (element == null) {
            throw new BadLocationException("No more words", n);
        }
        Document document = element.getDocument();
        int n3 = element.getStartOffset();
        int n4 = element.getEndOffset();
        if (n > n4 || n < n3) {
            throw new BadLocationException("No more words", n);
        }
        String string = document.getText(n3, n4 - n3);
        BreakIterator breakIterator = BreakIterator.getWordInstance();
        breakIterator.setText(string);
        if (breakIterator.following(n - n3) == -1) {
            breakIterator.last();
        }
        if ((n2 = breakIterator.previous()) == n - n3) {
            n2 = breakIterator.previous();
        }
        if (n2 == -1) {
            return -1;
        }
        char c = string.charAt(n2);
        if (!Character.isWhitespace(c)) {
            return n3 + n2;
        }
        n2 = breakIterator.previous();
        if (n2 != -1) {
            return n3 + n2;
        }
        return -1;
    }

    public static final int getPreviousWord(JTextComponent jTextComponent, int n) throws BadLocationException {
        Element element = Utilities.getParagraphElement(jTextComponent, n);
        int n2 = Utilities.getPrevWordInParagraph(element, n);
        while (n2 == -1) {
            n = element.getStartOffset() - 1;
            element = Utilities.getParagraphElement(jTextComponent, n);
            n2 = Utilities.getPrevWordInParagraph(element, n);
        }
        return n2;
    }

    public static final int getRowEnd(JTextComponent jTextComponent, int n) throws BadLocationException {
        Rectangle rectangle = jTextComponent.modelToView(n);
        int n2 = jTextComponent.getDocument().getLength();
        int n3 = n;
        int n4 = rectangle.y;
        while (rectangle != null && n4 == rectangle.y) {
            n = n3++;
            Rectangle rectangle2 = rectangle = n3 <= n2 ? jTextComponent.modelToView(n3) : null;
        }
        return n;
    }

    public static final int getRowStart(JTextComponent jTextComponent, int n) throws BadLocationException {
        Rectangle rectangle = jTextComponent.modelToView(n);
        int n2 = n;
        int n3 = rectangle.y;
        while (rectangle != null && n3 == rectangle.y) {
            n = n2--;
            Rectangle rectangle2 = rectangle = n2 >= 0 ? jTextComponent.modelToView(n2) : null;
        }
        return n;
    }

    public static final int getTabbedTextOffset(Segment segment, FontMetrics fontMetrics, int n, int n2, TabExpander tabExpander, int n3) {
        return Utilities.getTabbedTextOffset(segment, fontMetrics, n, n2, tabExpander, n3, true);
    }

    public static final int getTabbedTextOffset(Segment segment, FontMetrics fontMetrics, int n, int n2, TabExpander tabExpander, int n3, boolean bl) {
        int n4;
        int n5 = n4 = n;
        char[] cArray = segment.array;
        int n6 = segment.offset + segment.count;
        int n7 = segment.offset;
        while (n7 < n6) {
            n5 = cArray[n7] == '\t' ? (tabExpander != null ? (int)tabExpander.nextTabStop(n5, n3 + n7 - segment.offset) : (n5 += fontMetrics.charWidth(' '))) : (n5 += fontMetrics.charWidth(cArray[n7]));
            if (n2 >= n4 && n2 < n5) {
                if (!bl || n2 - n4 < n5 - n2) {
                    return n7 - segment.offset;
                }
                return n7 + 1 - segment.offset;
            }
            n4 = n5;
            ++n7;
        }
        return segment.count;
    }

    public static final int getTabbedTextWidth(Segment segment, FontMetrics fontMetrics, int n, TabExpander tabExpander, int n2) {
        int n3 = n;
        char[] cArray = segment.array;
        int n4 = segment.offset + segment.count;
        int n5 = segment.offset;
        while (n5 < n4) {
            if (cArray[n5] == '\t') {
                n3 = tabExpander != null ? (int)tabExpander.nextTabStop(n3, n2 + n5 - segment.offset) : (n3 += fontMetrics.charWidth(' '));
            } else if (cArray[n5] != '\n') {
                n3 += fontMetrics.charWidth(cArray[n5]);
            }
            ++n5;
        }
        return n3 - n;
    }

    public static final int getWordEnd(JTextComponent jTextComponent, int n) throws BadLocationException {
        int n2;
        Element element;
        int n3;
        Document document = jTextComponent.getDocument();
        String string = document.getText(n3 = (element = Utilities.getParagraphElement(jTextComponent, n)).getStartOffset(), (n2 = Math.min(element.getEndOffset(), document.getLength())) - n3);
        if (string != null && string.length() > 0) {
            BreakIterator breakIterator = BreakIterator.getWordInstance();
            breakIterator.setText(string);
            int n4 = n - n3;
            if (n4 >= breakIterator.last()) {
                n4 = breakIterator.last() - 1;
            }
            n = n3 + breakIterator.following(n4);
        }
        return n;
    }

    public static final int getWordStart(JTextComponent jTextComponent, int n) throws BadLocationException {
        int n2;
        Element element;
        int n3;
        Document document = jTextComponent.getDocument();
        String string = document.getText(n3 = (element = Utilities.getParagraphElement(jTextComponent, n)).getStartOffset(), (n2 = Math.min(element.getEndOffset(), document.getLength())) - n3);
        if (string != null && string.length() > 0) {
            BreakIterator breakIterator = BreakIterator.getWordInstance();
            breakIterator.setText(string);
            int n4 = n - n3;
            if (n4 >= breakIterator.last()) {
                n4 = breakIterator.last() - 1;
            }
            breakIterator.following(n4);
            n = n3 + breakIterator.previous();
        }
        return n;
    }

    static boolean isComposedTextAttributeDefined(AttributeSet attributeSet) {
        return attributeSet != null && attributeSet.isDefined(StyleConstants.ComposedTextAttribute);
    }

    static boolean isComposedTextElement(Element element) {
        AttributeSet attributeSet = element.getAttributes();
        return Utilities.isComposedTextAttributeDefined(attributeSet);
    }
}

