package biege;
import java.lang.Math;

/**
 * A class that represents an angle in radians
 *@author Nick Miller, Minh Ngoc Hao Huynh, Simon Leon
 */
public class Angle extends Object
{
  //The vlue of the angle in radians
  private double value;

  /**
    * The Angle constructor that makes an angle based on the given double value
    * @param init the initial value for the angle in radians
   */
  public Angle (double init)
  {
    super();
    value = reduce(init);
  }

  /**
   * Increases the angle by a given amount of radians
   * @param inc the value in radians by which the angle in incremented
   */
  public void increment (double inc)
  {
    value = reduce(value + inc);
  }

  /**
   * Retrieves the value of the angle in radians in the form a double
   * @return a double representing the value of an angle in radians
   */
  public double get()
  {
    return value;
  }

  /**
   * Sets the value of the angle to a given double in radians
   * @param newValue a double which is the value of the desired angle in radians
   */
  public void set(double newValue)
  {
    value = reduce(newValue);
  }


  /**
   * Reduces a double of an angle value in radians to an angle on [0, 2pi]
   * @param theta a double of the value in radians of the angle to be reduced
   * @return the new value of the angle on [0, 2pi]
   */
  public static double reduce (double theta)
  {
    if (theta > 2*Math.PI)
      theta = theta - 2*Math.PI;
    else if (theta < 0)
      theta = theta + 2 * Math.PI;

    return theta;
  }



}
