package biege;
import java.applet.AudioClip;



public abstract class Enemy extends Element
{
    private int direction = Position.DIRECTION_SOUTH;
    private static AudioClip KILLED_ENEMY = Element.loadAudioClip("file:sound/killed.wav");

    public Enemy (Position p)
    {
      super(p);
    }

    public int getDirection()
    {
      return direction;
    }

    public void interact (Element e)
    {
      if (Position.distance(getPosition(), e.getPosition()) < getGurth() + e.getGurth())
        e.hurt();
    }


    public void setDirection (int newDir)
    {
      direction = newDir;
    }

    public boolean isBad()
    {
      return true;
    }

    public void onDeath(GUI tempGui)
    {
      super.onDeath(tempGui);
      
      if (KILLED_ENEMY != null)
        KILLED_ENEMY.play();

      tempGui.getPlayer().increaseScore(10);
    }

}
