package biege;
import java.awt.Graphics;
import java.awt.Color;
import java.awt.Image;


public class King extends RectangleObstacle
{

    private static String[] END_MESSAGE = {"You found all of the crystals!", "My kingdom is safe", "Thank you mighty warrior!"};
    private static String[] BEGIN_MESSAGE = {"You must collect all twenty of the blue crystals", "or our kingdom is ruined....", "", "Good luck, warrior." };
    private static int KING_WIDTH = 14;
    private static int KING_HEIGHT = 16;
    private static String KING_IMAGE_LOCATION =  "king.gif";
    private static String WIN_SONG_LOCATION = "file:sound/win.wav";
    private static Image SPRITE;

    public King(Position p)
    {
      super(new Position(p.getX() - KING_WIDTH/2, p.getY()-KING_HEIGHT/2), KING_WIDTH, KING_HEIGHT, Color.blue);
      if (SPRITE == null)
      {
        SPRITE = Element.loadImage(KING_IMAGE_LOCATION);
      }

    }

    public void draw(Graphics g, int viewW, int viewH)
    {
      g.setColor(Color.cyan);
      if(SPRITE != null)
      Element.drawImage(SPRITE, g, scaleX(viewW), scaleY(viewH),
                        Element.scaleWidth(viewW, KING_WIDTH), Element.scaleHeight(viewH, KING_HEIGHT));

    }

    public void interact(Element e)
    {
      super.interact(e);
    }

    public void advance(GUI tempGui)
    {
    }

    public void talk (GUI tempGui)
    {
      String[] msg;
      Player p = tempGui.getPlayer();

      if (p.hasAllCrystals())
      {
        WorldData.playSong(WIN_SONG_LOCATION);
        msg = END_MESSAGE;
        p.beatGame();
        p.disengageControls();
      }
      else
      {
        msg = BEGIN_MESSAGE;
        if (p.countCrystals() != 0)
          msg[2] = "You have found: " + p.countCrystals() + " out of the 20 crystals.";
      }

      tempGui.setTextBox(new TextBox(msg));
    }

    public double getGurth()
    {
      return (double)KING_WIDTH;
    }

    public void changePosition(Position p) {}//do nothing. Does not move

    public void delete() {}

}