/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.entity;

import games.stendhal.client.entity.Entity;
import games.stendhal.client.entity.Property;
import games.stendhal.client.entity.RPEntity;
import games.stendhal.client.gui.wt.core.WtWindowManager;
import games.stendhal.common.constants.SoundLayer;
import java.awt.geom.Rectangle2D;
import marauroa.common.game.RPObject;

public class Creature
extends RPEntity {
    public static final Property PROP_DEBUG = new Property();
    public static final Property PROP_METAMORPHOSIS = new Property();
    private String debug;
    private String metamorphosis;

    @Override
    protected void nonCreatureClientAddEventLine(String string) {
    }

    public String getDebug() {
        return this.debug;
    }

    public String getMetamorphosis() {
        return this.metamorphosis;
    }

    @Override
    public Rectangle2D getArea() {
        if (Math.abs(this.getWidth() - 1.0) < 0.1 && Math.abs(this.getHeight() - 2.0) < 0.1) {
            return new Rectangle2D.Double(this.getX(), this.getY() + 1.0, 1.0, 1.0);
        }
        return super.getArea();
    }

    @Override
    public void initialize(RPObject rPObject) {
        super.initialize(rPObject);
        this.metamorphosis = rPObject.has("metamorphosis") ? rPObject.get("metamorphosis") : null;
    }

    @Override
    public void onDamaged(Entity entity, int n) {
        super.onDamaged(entity, n);
        this.playRandomSoundFromCategory(SoundLayer.FIGHTING_NOISE.groupName, "attack");
    }

    @Override
    public void onChangedAdded(RPObject rPObject, RPObject rPObject2) {
        super.onChangedAdded(rPObject, rPObject2);
        if (rPObject2.has("debug")) {
            this.debug = rPObject2.get("debug");
            this.fireChange(PROP_DEBUG);
        }
        if (rPObject2.has("metamorphosis")) {
            this.metamorphosis = rPObject.get("metamorphosis");
            this.fireChange(PROP_METAMORPHOSIS);
        }
    }

    @Override
    public void onChangedRemoved(RPObject rPObject, RPObject rPObject2) {
        super.onChangedRemoved(rPObject, rPObject2);
        if (rPObject2.has("metamorphosis")) {
            this.metamorphosis = null;
            this.fireChange(PROP_METAMORPHOSIS);
        }
    }

    @Override
    public void onTalk(String string) {
        boolean bl = Boolean.parseBoolean(WtWindowManager.getInstance().getProperty("gamescreen.creaturespeech", "true"));
        if (bl) {
            super.onTalk(string);
        }
    }
}

