/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.events;

import games.stendhal.client.ClientSingletonRepository;
import games.stendhal.client.entity.Entity;
import games.stendhal.client.events.Event;
import games.stendhal.client.sound.facade.AudibleArea;
import games.stendhal.client.sound.facade.AudibleCircleArea;
import games.stendhal.client.sound.facade.InfiniteAudibleArea;
import games.stendhal.client.sound.facade.SoundFileType;
import games.stendhal.client.sound.facade.SoundGroup;
import games.stendhal.common.constants.SoundLayer;
import games.stendhal.common.math.Algebra;
import games.stendhal.common.math.Numeric;

class SoundEvent
extends Event<Entity> {
    SoundEvent() {
    }

    @Override
    public void execute() {
        AudibleArea audibleArea;
        SoundLayer soundLayer = SoundLayer.AMBIENT_SOUND;
        int n = this.event.getInt("layer");
        if (n < SoundLayer.values().length) {
            soundLayer = SoundLayer.values()[n];
        }
        float f = 1.0f;
        if (this.event.has("volume")) {
            f = Numeric.intToFloat(this.event.getInt("volume"), 100.0f);
        }
        String string = this.event.get("sound");
        if (this.event.has("radius")) {
            int n2 = this.event.getInt("radius");
            audibleArea = new AudibleCircleArea(Algebra.vecf((float)this.entity.getX(), (float)this.entity.getY()), (float)n2 / 4.0f, n2);
        } else {
            audibleArea = new InfiniteAudibleArea();
        }
        SoundGroup soundGroup = ClientSingletonRepository.getSound().getGroup(soundLayer.groupName);
        soundGroup.loadSound(string, string + ".ogg", SoundFileType.OGG, false);
        soundGroup.play(string, f, 0, audibleArea, null, false, true);
    }
}

