/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui;

import games.stendhal.client.gui.BareBonesBrowserLaunch;
import games.stendhal.client.gui.MousePopupAdapter;
import games.stendhal.client.gui.chatlog.ChatTextSink;
import games.stendhal.client.gui.chatlog.EventLine;
import games.stendhal.client.gui.chatlog.HeaderLessEventLine;
import games.stendhal.client.gui.textformat.StringFormatter;
import games.stendhal.client.gui.textformat.StyleSet;
import games.stendhal.client.stendhal;
import games.stendhal.common.MathHelper;
import games.stendhal.common.NotificationType;
import java.awt.Adjustable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.Caret;
import javax.swing.text.ComponentView;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.LabelView;
import javax.swing.text.ParagraphView;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.apache.log4j.Logger;

class KTextEdit
extends JComponent {
    protected static final Color HEADER_COLOR = Color.gray;
    private static final Logger logger = Logger.getLogger(KTextEdit.class);
    JTextPane textPane;
    private String name = "";
    private Color defaultBackground = Color.white;
    private final StringFormatter<Style, StyleSet> formatter = new StringFormatter();
    private final Format dateFormatter = new SimpleDateFormat("[HH:mm] ");

    @Override
    public void setFont(Font font) {
        this.initStylesForTextPane(this.textPane, font.getSize() - 1);
    }

    KTextEdit() {
        this.buildGUI();
    }

    private void buildGUI() {
        this.textPane = new JTextPane();
        this.textPane.setEditorKit(new WrapEditorKit());
        this.textPane.setEditable(false);
        this.textPane.setAutoscrolls(true);
        Caret caret = this.textPane.getCaret();
        if (caret instanceof DefaultCaret) {
            ((DefaultCaret)caret).setUpdatePolicy(1);
        } else {
            logger.warn((Object)"Failed to turn off caret following");
        }
        this.textPane.addMouseListener(new TextPaneMouseListener());
        this.initStylesForTextPane(this.textPane, this.textPane.getFont().getSize());
        this.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.textPane){

            @Override
            public JScrollBar createVerticalScrollBar() {
                JScrollBar jScrollBar = super.createVerticalScrollBar();
                jScrollBar.setModel(new VerticalScollbarModel());
                return jScrollBar;
            }
        };
        jScrollPane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                JScrollBar jScrollBar = (JScrollBar)adjustmentEvent.getAdjustable();
                if (!jScrollBar.getValueIsAdjusting() && KTextEdit.this.isAtMaximum(jScrollBar)) {
                    KTextEdit.this.setUnreadLinesWarning(false);
                }
            }
        });
        this.add((Component)jScrollPane, "Center");
    }

    protected void initStylesForTextPane(JTextPane jTextPane, int n) {
        Style style;
        Style style2 = jTextPane.getStyle("regular");
        if (style2 == null) {
            style = StyleContext.getDefaultStyleContext().getStyle("default");
            style2 = jTextPane.addStyle("regular", style);
            StyleConstants.setFontFamily(style, "Dialog");
        }
        StyleConstants.setFontSize(style2, n);
        style = jTextPane.getStyle("normal");
        if (style == null) {
            style = jTextPane.addStyle("normal", style2);
            StyleConstants.setBold(style, true);
            StyleConstants.setForeground(style, HEADER_COLOR);
        }
        if ((style = jTextPane.getStyle("bold")) == null) {
            style = jTextPane.addStyle("bold", style2);
            StyleConstants.setItalic(style, true);
            StyleConstants.setBold(style, true);
            StyleConstants.setForeground(style, Color.blue);
        }
        StyleConstants.setFontSize(style2, n + 1);
        style = jTextPane.getStyle("header");
        if (style == null) {
            style = jTextPane.addStyle("header", style2);
            StyleConstants.setItalic(style, true);
            StyleConstants.setForeground(style, HEADER_COLOR);
        }
        StyleConstants.setFontSize(style, n);
        style = jTextPane.getStyle("timestamp");
        if (style == null) {
            style = jTextPane.addStyle("timestamp", style2);
            StyleConstants.setItalic(style, true);
            StyleConstants.setForeground(style, HEADER_COLOR);
        }
        StyleConstants.setFontSize(style, n - 1);
        StyleSet styleSet = new StyleSet(StyleContext.getDefaultStyleContext(), style2);
        StyleSet styleSet2 = styleSet.copy();
        styleSet2.setAttribute(StyleConstants.Italic, Boolean.TRUE);
        styleSet2.setAttribute(StyleConstants.Foreground, Color.blue);
        styleSet2.setAttribute("linkact", new LinkListener());
        this.formatter.addStyle(Character.valueOf('#'), styleSet2);
        styleSet2 = styleSet.copy();
        styleSet2.setAttribute(StyleConstants.Underline, Boolean.TRUE);
        this.formatter.addStyle(Character.valueOf('\u00a7'), styleSet2);
    }

    private Style getStyle(Color color, String string) {
        Style style = this.textPane.getStyle(string);
        StyleConstants.setForeground(style, color);
        return style;
    }

    protected void insertHeader(String string) {
        Document document = this.textPane.getDocument();
        try {
            if (string.length() > 0) {
                document.insertString(document.getLength(), "<" + string + "> ", this.textPane.getStyle("header"));
            }
        }
        catch (BadLocationException badLocationException) {
            logger.error((Object)"Couldn't insert initial text.", (Throwable)badLocationException);
        }
    }

    protected void insertTimestamp(String string) {
        Document document = this.textPane.getDocument();
        try {
            if (string.length() > 0) {
                document.insertString(document.getLength(), string, this.textPane.getStyle("timestamp"));
            }
        }
        catch (BadLocationException badLocationException) {
            logger.error((Object)"Couldn't insert initial text.", (Throwable)badLocationException);
        }
    }

    protected void insertText(String string, NotificationType notificationType) {
        ChatTextSink chatTextSink = new ChatTextSink(this.textPane.getDocument());
        StyleSet styleSet = new StyleSet(StyleContext.getDefaultStyleContext(), this.getStyle(notificationType.getColor(), notificationType.getStyleDescription()));
        styleSet.setAttribute(StyleConstants.Foreground, notificationType.getColor());
        this.formatter.format(string, styleSet, chatTextSink);
    }

    protected void insertNewline() {
        Document document = this.textPane.getDocument();
        try {
            document.insertString(document.getLength(), "\r\n", this.getStyle(Color.black, "normal"));
        }
        catch (BadLocationException badLocationException) {
            logger.error((Object)"Couldn't insert initial text.", (Throwable)badLocationException);
        }
    }

    private void addLine(final String string, final String string2, final NotificationType notificationType) {
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                this.handleAddLine(string, string2, notificationType);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        KTextEdit.this.handleAddLine(string, string2, notificationType);
                    }
                });
            }
        }
        catch (RuntimeException runtimeException) {
            logger.error((Object)runtimeException, (Throwable)runtimeException);
        }
    }

    private void handleAddLine(String string, String string2, NotificationType notificationType) {
        this.insertNewline();
        String string3 = this.dateFormatter.format(new Date());
        this.insertTimestamp(string3);
        this.insertHeader(string);
        this.insertText(string2, notificationType);
    }

    private boolean isAtMaximum(Adjustable adjustable) {
        return adjustable.getValue() + adjustable.getVisibleAmount() >= adjustable.getMaximum();
    }

    void addLine(EventLine eventLine) {
        this.addLine(eventLine.getHeader(), eventLine.getText(), eventLine.getType());
    }

    void clear() {
        this.textPane.setText("");
    }

    void setDefaultBackground(Color color) {
        this.defaultBackground = color;
    }

    void setChannelName(String string) {
        this.name = string;
    }

    private void setUnreadLinesWarning(boolean bl) {
        if (bl) {
            this.textPane.setBackground(Color.pink);
        } else {
            this.textPane.setBackground(this.defaultBackground);
        }
    }

    private String getSaveFileName() {
        if ("".equals(this.name)) {
            return stendhal.getGameFolder() + "gamechat.log";
        }
        return stendhal.getGameFolder() + "gamechat-" + this.name + ".log";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save() {
        String string = this.getSaveFileName();
        try {
            try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(string), "UTF-8");){
                this.textPane.write(outputStreamWriter);
            }
            this.addLine("", "Chat log has been saved to " + string, NotificationType.CLIENT);
        }
        catch (IOException iOException) {
            logger.error((Object)iOException, (Throwable)iOException);
        }
    }

    private static class WrapLabelView
    extends LabelView {
        public WrapLabelView(Element element) {
            super(element);
        }

        @Override
        public float getMinimumSpan(int n) {
            switch (n) {
                case 0: {
                    return 0.0f;
                }
                case 1: {
                    return super.getMinimumSpan(n);
                }
            }
            throw new IllegalArgumentException("Invalid axis: " + n);
        }
    }

    private static class WrapColumnFactory
    implements ViewFactory {
        private WrapColumnFactory() {
        }

        @Override
        public View create(Element element) {
            String string = element.getName();
            if (string != null) {
                if (string.equals("content")) {
                    return new WrapLabelView(element);
                }
                if (string.equals("paragraph")) {
                    return new ParagraphView(element);
                }
                if (string.equals("section")) {
                    return new BoxView(element, 1);
                }
                if (string.equals("component")) {
                    return new ComponentView(element);
                }
                if (string.equals("icon")) {
                    return new IconView(element);
                }
            }
            return new LabelView(element);
        }
    }

    private static class WrapEditorKit
    extends StyledEditorKit {
        private final ViewFactory defaultFactory = new WrapColumnFactory();

        private WrapEditorKit() {
        }

        @Override
        public ViewFactory getViewFactory() {
            return this.defaultFactory;
        }
    }

    class LinkListener {
        final Pattern whitelist = Pattern.compile("^https?://stendhalgame\\.org(/.*)*$");

        LinkListener() {
        }

        void linkClicked(String string) {
            if (this.whitelist.matcher(string).matches()) {
                KTextEdit.this.addLine(new HeaderLessEventLine("Trying to open #'" + string + "' in your browser.", NotificationType.CLIENT));
                BareBonesBrowserLaunch.openURL(string);
            }
        }
    }

    private class VerticalScollbarModel
    extends DefaultBoundedRangeModel {
        private VerticalScollbarModel() {
        }

        @Override
        public void setRangeProperties(int n, int n2, int n3, int n4, boolean bl) {
            boolean bl2;
            boolean bl3 = bl2 = this.getValue() + this.getExtent() >= this.getMaximum();
            if (bl2 && n == this.getValue()) {
                n = MathHelper.clamp(n4 - n2, n3, n4);
            } else if (n4 > this.getMaximum()) {
                n = MathHelper.clamp(this.getValue(), n3, n4);
                KTextEdit.this.setUnreadLinesWarning(true);
            }
            super.setRangeProperties(n, n2, n3, n4, bl);
        }
    }

    private final class TextPaneMouseListener
    extends MousePopupAdapter {
        private TextPaneMouseListener() {
        }

        @Override
        protected void showPopup(MouseEvent mouseEvent) {
            JPopupMenu jPopupMenu = new JPopupMenu("save");
            JMenuItem jMenuItem = new JMenuItem("Save");
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    KTextEdit.this.save();
                }
            });
            jPopupMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Clear");
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    KTextEdit.this.clear();
                }
            });
            jPopupMenu.add(jMenuItem);
            jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            StyledDocument styledDocument = (StyledDocument)KTextEdit.this.textPane.getDocument();
            Element element = styledDocument.getCharacterElement(KTextEdit.this.textPane.viewToModel(mouseEvent.getPoint()));
            AttributeSet attributeSet = element.getAttributes();
            Object object = attributeSet.getAttribute("linkact");
            if (object instanceof LinkListener) {
                try {
                    ((LinkListener)object).linkClicked(styledDocument.getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset()));
                }
                catch (BadLocationException badLocationException) {
                    logger.error((Object)"Trying to extract link from invalid range", (Throwable)badLocationException);
                }
            }
        }
    }
}

