/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui;

import games.stendhal.client.StendhalClient;
import games.stendhal.client.gui.BareBonesBrowserLaunch;
import games.stendhal.client.gui.CreditsDialog;
import games.stendhal.client.gui.Initializer;
import games.stendhal.client.gui.WindowUtils;
import games.stendhal.client.gui.login.CreateAccountDialog;
import games.stendhal.client.gui.login.LoginDialog;
import games.stendhal.client.sprite.DataLoader;
import games.stendhal.client.stendhal;
import games.stendhal.client.update.ClientGameConfiguration;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class StendhalFirstScreen
extends JFrame {
    private static final long serialVersionUID = -7825572598938892220L;
    private static final String FONT_NAME = "BlackChancery";
    private static final int FONT_SIZE = 16;
    private final StendhalClient client;
    private JButton loginButton;
    private JButton createAccountButton;
    private JButton helpButton;
    private JButton creditButton;

    public StendhalFirstScreen(StendhalClient stendhalClient) {
        super(StendhalFirstScreen.detectScreen());
        this.setLocationByPlatform(true);
        WindowUtils.trackLocation(this, "main", true);
        this.client = stendhalClient;
        stendhalClient.setSplashScreen(this);
        this.initializeComponent();
        this.setVisible(true);
    }

    private static GraphicsConfiguration detectScreen() {
        PointerInfo pointerInfo = MouseInfo.getPointerInfo();
        if (pointerInfo != null) {
            return pointerInfo.getDevice().getDefaultConfiguration();
        }
        return null;
    }

    private void initializeComponent() {
        URL uRL = DataLoader.getResource(ClientGameConfiguration.get((String)"GAME_SPLASH_BACKGROUND"));
        ImageIcon imageIcon = new ImageIcon(uRL);
        ResizableLabel resizableLabel = new ResizableLabel(imageIcon);
        this.setContentPane(resizableLabel);
        Font font = new Font(FONT_NAME, 0, 16);
        String string = ClientGameConfiguration.get((String)"GAME_NAME");
        AbstractAction abstractAction = new AbstractAction("Login to " + string){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new LoginDialog((Frame)StendhalFirstScreen.this, StendhalFirstScreen.this.client).setVisible(true);
            }
        };
        abstractAction.putValue("MnemonicKey", 76);
        abstractAction.putValue("ShortDescription", "Press this button to login to a " + string + " server");
        this.loginButton = new JButton();
        this.loginButton.setAction(abstractAction);
        this.loginButton.setFont(font);
        AbstractAction abstractAction2 = new AbstractAction("Create an account"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new CreateAccountDialog((Frame)StendhalFirstScreen.this, StendhalFirstScreen.this.client);
            }
        };
        abstractAction2.putValue("MnemonicKey", 65);
        abstractAction2.putValue("ShortDescription", "Press this button to create an account on a " + string + " server.");
        this.createAccountButton = new JButton();
        this.createAccountButton.setFont(font);
        this.createAccountButton.setAction(abstractAction2);
        AbstractAction abstractAction3 = new AbstractAction("Help"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BareBonesBrowserLaunch.openURL("https://stendhalgame.org/wiki/Stendhal_Manual");
            }
        };
        abstractAction3.putValue("MnemonicKey", 72);
        this.helpButton = new JButton();
        this.helpButton.setFont(font);
        this.helpButton.setAction(abstractAction3);
        AbstractAction abstractAction4 = new AbstractAction("Credits"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new CreditsDialog(StendhalFirstScreen.this);
            }
        };
        abstractAction4.putValue("MnemonicKey", 67);
        this.creditButton = new JButton();
        this.creditButton.setFont(font);
        this.creditButton.setAction(abstractAction4);
        this.setDefaultCloseOperation(3);
        resizableLabel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.weighty = 1.0;
        resizableLabel.add(Box.createVerticalGlue(), gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        resizableLabel.add((Component)this.loginButton, gridBagConstraints);
        ++gridBagConstraints.gridy;
        resizableLabel.add((Component)this.createAccountButton, gridBagConstraints);
        ++gridBagConstraints.gridy;
        resizableLabel.add((Component)this.helpButton, gridBagConstraints);
        ++gridBagConstraints.gridy;
        resizableLabel.add((Component)this.creditButton, gridBagConstraints);
        ++gridBagConstraints.gridy;
        resizableLabel.add(Box.createVerticalStrut(10), gridBagConstraints);
        this.getRootPane().setDefaultButton(this.loginButton);
        this.setTitle(string + " " + stendhal.VERSION + " - a multiplayer online game using Arianne");
        uRL = DataLoader.getResource(ClientGameConfiguration.get((String)"GAME_ICON"));
        this.setIconImage(new ImageIcon(uRL).getImage());
        this.pack();
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.loginButton.setEnabled(bl);
        this.createAccountButton.setEnabled(bl);
        this.helpButton.setEnabled(bl);
        this.creditButton.setEnabled(bl);
    }

    static {
        Initializer.init();
    }

    private static class ResizableLabel
    extends JLabel {
        private final Image image;
        private Rectangle bounds;

        ResizableLabel(ImageIcon imageIcon) {
            super(imageIcon);
            this.image = imageIcon.getImage();
        }

        @Override
        public void setBounds(int n, int n2, int n3, int n4) {
            super.setBounds(n, n2, n3, n4);
            this.scale();
        }

        private void scale() {
            Rectangle rectangle = this.getBounds();
            if (!rectangle.equals(this.bounds)) {
                this.bounds = rectangle;
                double d = (double)this.bounds.width / (double)this.image.getWidth(this);
                double d2 = (double)this.bounds.height / (double)this.image.getHeight(this);
                double d3 = Math.max(d, d2);
                BufferedImage bufferedImage = this.getGraphicsConfiguration().createCompatibleImage(this.bounds.width, this.bounds.height);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                graphics2D.scale(d3, d3);
                graphics2D.drawImage(this.image, 0, 0, this);
                graphics2D.dispose();
                this.setIcon(new ImageIcon(bufferedImage));
            }
        }
    }
}

