/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui;

import games.stendhal.client.gui.wt.core.WtWindowManager;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import org.apache.log4j.Logger;

public final class TransparencyMode {
    public static final int TRANSPARENCY = TransparencyMode.getMode();

    private TransparencyMode() {
    }

    private static int getMode() {
        String string = WtWindowManager.getInstance().getProperty("ui.transparency", "auto");
        if ("bitmask".equals(string)) {
            return 2;
        }
        if ("translucent".equals(string)) {
            return 3;
        }
        return TransparencyMode.autoMode();
    }

    private static int autoMode() {
        long l = TransparencyMode.speedTest();
        if (l < 300000000L) {
            return 3;
        }
        Logger.getLogger(TransparencyMode.class).info((Object)"The system is slow - disabling translucency.");
        return 2;
    }

    private static long speedTest() {
        BufferedImage bufferedImage = new BufferedImage(32, 32, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(new Color(255, 232, 12, 128));
        long l = System.nanoTime();
        for (int i = 0; i < 1000; ++i) {
            graphics2D.fillRect(0, 0, 32, 32);
        }
        return System.nanoTime() - l;
    }
}

