/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.chattext;

import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;

public class CharacterMap
extends JButton {
    public CharacterMap(final JTextComponent jTextComponent) {
        super("\u263a");
        this.setFocusable(false);
        this.setToolTipText("Insert a special character");
        final JPopupMenu jPopupMenu = new JPopupMenu();
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jPopupMenu.show(CharacterMap.this, CharacterMap.this.getWidth() - jPopupMenu.getPreferredSize().width, CharacterMap.this.getHeight());
            }
        });
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object instanceof AbstractButton) {
                    String string = ((AbstractButton)object).getText();
                    int n = jTextComponent.getCaretPosition();
                    try {
                        jTextComponent.getDocument().insertString(n, string, null);
                    }
                    catch (BadLocationException badLocationException) {
                        Logger.getLogger(CharacterMap.class).error((Object)"Bug", (Throwable)badLocationException);
                    }
                }
            }
        };
        this.fillMenu(jPopupMenu, actionListener);
    }

    private void fillMenu(JComponent jComponent, ActionListener actionListener) {
        String[][] stringArrayArray = new String[][]{{"\u263a", "\u2639", "\ud83d\ude03", "\ud83d\ude32", "\ud83d\ude07", "\ud83d\ude08", "\ud83d\ude0a", "\ud83d\ude0c", "\ud83d\ude0d", "\ud83d\ude0e", "\ud83d\ude0f", "\ud83d\ude10", "\ud83d\ude34"}, {"\ud83d\udc2d", "\ud83d\udc2e", "\ud83d\udc31", "\ud83d\udc35", "\ud83d\udc2f", "\ud83d\udc30", "\ud83d\udc34", "\ud83d\udc36", "\ud83d\udc37", "\ud83d\udc39", "\ud83d\udc3a", "\ud83d\udc3b", "\ud83d\udc3c"}, {"\u2665", "\u2661", "\ud83d\udc94", "\ud83d\udca1", "\u2620"}, {"\u00a3", "$", "\u20ac", "\u20a4", "\u20b1", "\u00a5"}, {"\u2669", "\u266a", "\u266b", "\u266c", "\u266d", "\u266e", "\u266f", "\ud834\udd1e", "\ud834\udd22"}};
        jComponent.setLayout(new GridLayout(0, stringArrayArray[0].length));
        Insets insets = new Insets(1, 1, 1, 1);
        this.setMargin(insets);
        String[][] stringArrayArray2 = stringArrayArray;
        int n = stringArrayArray2.length;
        for (int i = 0; i < n; ++i) {
            String[] stringArray;
            for (String string : stringArray = stringArrayArray2[i]) {
                JMenuItem jMenuItem = new JMenuItem(string);
                jMenuItem.setMargin(insets);
                jMenuItem.addActionListener(actionListener);
                jMenuItem.setBorder(null);
                jMenuItem.setHorizontalTextPosition(0);
                jComponent.add(jMenuItem);
            }
        }
    }
}

