/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.j2d.entity;

import games.stendhal.client.entity.StackableItem;
import games.stendhal.client.gui.j2d.entity.Item2DView;
import games.stendhal.client.gui.j2d.entity.helpers.DrawingHelper;
import games.stendhal.client.gui.j2d.entity.helpers.HorizontalAlignment;
import games.stendhal.client.gui.j2d.entity.helpers.VerticalAlignment;
import games.stendhal.client.sprite.Sprite;
import games.stendhal.client.sprite.TextSprite;
import java.awt.Color;
import java.awt.Graphics2D;

public class StackableItem2DView<T extends StackableItem>
extends Item2DView<T> {
    private volatile boolean quantityChanged;
    private Sprite quantitySprite;
    private boolean showQuantity;

    @Override
    public void initialize(T t) {
        super.initialize(t);
        this.quantitySprite = this.getQuantitySprite(t);
        this.quantityChanged = false;
        this.showQuantity = true;
    }

    private Sprite getQuantitySprite(T t) {
        int n = ((StackableItem)t).getQuantity();
        if (n <= 1) {
            return null;
        }
        String string = this.isContained() && n > 9999999 ? n / 1000000 + "M" : (this.isContained() && n > 9999 ? n / 1000 + "K" : Integer.toString(n));
        return TextSprite.createTextSprite(string, Color.WHITE);
    }

    public void setShowQuantity(boolean bl) {
        this.showQuantity = bl;
    }

    @Override
    protected void draw(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        super.draw(graphics2D, n, n2, n3, n4);
        if (this.showQuantity && this.quantitySprite != null) {
            this.drawQuantity(graphics2D, n, n2, n3, n4);
        }
    }

    private void drawQuantity(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        if (this.isContained()) {
            DrawingHelper.drawAlignedSprite(graphics2D, this.quantitySprite, HorizontalAlignment.RIGHT, VerticalAlignment.TOP, n, n2, n3, n4);
        } else {
            DrawingHelper.drawAlignedSprite(graphics2D, this.quantitySprite, HorizontalAlignment.CENTER, VerticalAlignment.TOP, n, n2, n3, n4);
        }
    }

    @Override
    public void setContained(boolean bl) {
        super.setContained(bl);
        this.quantityChanged = true;
        this.markChanged();
    }

    @Override
    protected void update() {
        super.update();
        StackableItem stackableItem = (StackableItem)this.entity;
        if (this.quantityChanged && stackableItem != null) {
            this.quantityChanged = false;
            this.quantitySprite = this.getQuantitySprite(stackableItem);
        }
    }

    @Override
    void entityChanged(Object object) {
        super.entityChanged(object);
        if (object == StackableItem.PROP_QUANTITY) {
            this.quantityChanged = true;
        }
    }
}

