/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.styled;

import games.stendhal.client.gui.styled.Style;
import games.stendhal.client.gui.styled.StyleUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonUI;

public class StyledButtonUI
extends BasicButtonUI {
    private static final StyledButtonUI UI = new StyledButtonUI(StyleUtil.getStyle());
    private static final DefaultButtonFocusListener FOCUS_LISTENER = new DefaultButtonFocusListener();
    private final Style style;

    public StyledButtonUI(Style style) {
        this.style = style;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return UI;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        this.paintBackground(graphics, jComponent);
        if (jComponent instanceof AbstractButton) {
            ButtonModel buttonModel = ((AbstractButton)jComponent).getModel();
            if (!buttonModel.isPressed() && jComponent.getBorder().equals(this.style.getBorderDown())) {
                jComponent.setBorder(this.style.getBorder());
            }
            if (buttonModel.isRollover()) {
                this.hilite(graphics, jComponent);
            }
            if (jComponent instanceof JButton && ((JButton)jComponent).isDefaultButton()) {
                Insets insets = jComponent.getInsets();
                graphics.setColor(this.style.getShadowColor());
                int n = jComponent.getWidth() - insets.right - insets.left - 3;
                int n2 = jComponent.getHeight() - insets.top - insets.bottom - 3;
                graphics.drawRect(insets.left + 1, insets.right + 1, n, n2);
            }
        }
        super.paint(graphics, jComponent);
    }

    @Override
    protected void paintButtonPressed(Graphics graphics, AbstractButton abstractButton) {
        if (this.style.getBorder().equals(abstractButton.getBorder())) {
            abstractButton.setBorder(this.style.getBorderDown());
        }
    }

    @Override
    protected void paintText(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, String string) {
        if (abstractButton.isEnabled()) {
            super.paintText(graphics, abstractButton, rectangle, string);
        } else {
            int n = graphics.getFontMetrics().getAscent();
            StyleUtil.paintDisabledText(this.style, graphics, string, rectangle.x, rectangle.y + n);
        }
    }

    @Override
    protected void paintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        graphics.setColor(this.style.getShadowColor());
        graphics.drawRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = super.getPreferredSize(jComponent);
        if (jComponent instanceof AbstractButton) {
            Insets insets = ((AbstractButton)jComponent).getMargin();
            dimension.width += insets.left + insets.right;
            dimension.height += insets.top + insets.bottom;
        }
        return dimension;
    }

    private void paintBackground(Graphics graphics, JComponent jComponent) {
        StyleUtil.fillBackground(this.style, graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight());
    }

    private void hilite(Graphics graphics, JComponent jComponent) {
        graphics.setColor(this.style.getHighLightColor());
        Insets insets = jComponent.getInsets();
        int n = jComponent.getWidth() - insets.right - insets.left - 1;
        int n2 = jComponent.getHeight() - insets.top - insets.bottom - 1;
        graphics.drawRect(insets.left, insets.top, n, n2);
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        jComponent.addFocusListener(FOCUS_LISTENER);
        jComponent.setForeground(this.style.getForeground());
        jComponent.setBorder(this.style.getBorder());
    }

    private static class DefaultButtonFocusListener
    implements FocusListener {
        private DefaultButtonFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.changeDefault(focusEvent.getComponent(), true);
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.changeDefault(focusEvent.getComponent(), false);
        }

        private void changeDefault(Component component, boolean bl) {
            JButton jButton;
            JRootPane jRootPane;
            if (component instanceof JButton && (jRootPane = (jButton = (JButton)component).getRootPane()) != null) {
                if (bl) {
                    jRootPane.setDefaultButton(jButton);
                } else {
                    jRootPane.setDefaultButton(null);
                }
            }
        }
    }
}

