/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.styled;

import games.stendhal.client.gui.styled.Style;
import games.stendhal.client.gui.styled.StyleUtil;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;

public class StyledSliderUI
extends BasicSliderUI {
    private static final int TRACK_HEIGHT = 6;
    private static final int SLIDER_WIDTH = 8;
    private final Style style;

    public static ComponentUI createUI(JComponent jComponent) {
        if (jComponent instanceof JSlider) {
            return new StyledSliderUI(StyleUtil.getStyle(), (JSlider)jComponent);
        }
        return null;
    }

    public StyledSliderUI(Style style, JSlider jSlider) {
        super(jSlider);
        this.style = style;
    }

    @Override
    public void paintTrack(Graphics graphics) {
        Point point;
        int n = this.trackRect.x;
        int n2 = this.trackRect.y + (this.trackRect.height - 6) / 2;
        int n3 = this.xPositionForValue(this.slider.getValue());
        if (this.isDragging() && (point = this.slider.getMousePosition()) != null) {
            n3 = point.x;
        }
        n3 -= this.thumbRect.width / 2;
        n3 = Math.max(0, n3);
        if (this.slider.isEnabled()) {
            graphics.setColor(this.slider.getForeground());
        } else {
            graphics.setColor(this.slider.getBackground());
        }
        graphics.fillRect(n + n3, n2, this.trackRect.width - n3, 6);
        this.style.getBorderDown().paintBorder(null, graphics, n, n2, this.trackRect.width, 6);
    }

    @Override
    public void paintThumb(Graphics graphics) {
        Rectangle rectangle = this.getThumbShape();
        StyleUtil.fillBackground(this.style, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.style.getBorder().paintBorder(null, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    @Override
    public void paintFocus(Graphics graphics) {
        graphics.setColor(this.style.getHighLightColor());
        Rectangle rectangle = this.getThumbShape();
        graphics.drawRect(rectangle.x - 1, rectangle.y, rectangle.width + 1, rectangle.height - 1);
    }

    private Rectangle getThumbShape() {
        int n = this.thumbRect.x - (8 - this.thumbRect.width) / 2;
        return new Rectangle(n, this.thumbRect.y, 8, this.thumbRect.height);
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        jComponent.setOpaque(false);
        jComponent.setForeground(this.style.getForeground());
        jComponent.setBackground(this.style.getShadowColor());
    }
}

