/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.sound.system.processors;

import games.stendhal.client.sound.system.SignalProcessor;
import games.stendhal.common.memory.Field;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;

public class PCMStreamConverter
extends SignalProcessor {
    private InputStream mInputStream;
    private AudioFormat mAudioFormat;
    private float[] mOutputBuffer = null;
    private byte[] mInputBuffer = null;
    private int mNumSamplesToBuffer;
    private boolean mEndOfStream;
    private boolean mConverterIsOpened;

    public PCMStreamConverter(InputStream inputStream, AudioFormat audioFormat, int n) {
        this.init(inputStream, audioFormat, n);
    }

    public boolean reachedEndOfStream() {
        return this.mEndOfStream;
    }

    public void open(InputStream inputStream, AudioFormat audioFormat, int n) {
        if (!this.mConverterIsOpened) {
            this.init(inputStream, audioFormat, n);
        }
    }

    public void close() {
        this.mEndOfStream = true;
        this.mConverterIsOpened = false;
        if (this.mInputStream != null) {
            block3: {
                try {
                    this.mInputStream.close();
                }
                catch (IOException iOException) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError((Object)iOException.toString());
                }
            }
            this.mInputStream = null;
        }
    }

    private void init(InputStream inputStream, AudioFormat audioFormat, int n) {
        assert (inputStream != null && audioFormat != null);
        assert (n > 0) : "given buffer size too small";
        assert (audioFormat.getSampleSizeInBits() % 8 == 0) : "invalid sample size";
        assert (!audioFormat.isBigEndian()) : "cannot convert fom big-endian TO little-endian (not implemented jet)";
        int n2 = n * audioFormat.getChannels();
        int n3 = n * audioFormat.getFrameSize();
        this.mInputBuffer = Field.expand(this.mInputBuffer, n3, false);
        this.mOutputBuffer = Field.expand(this.mOutputBuffer, n2, false);
        this.mInputStream = inputStream;
        this.mAudioFormat = audioFormat;
        this.mNumSamplesToBuffer = n;
        this.mEndOfStream = false;
        this.mConverterIsOpened = true;
    }

    private void convertToUniformPCM(int n) {
        int n2 = this.mAudioFormat.getSampleSizeInBits() / 8;
        int n3 = this.mAudioFormat.getChannels();
        int n4 = this.mAudioFormat.getFrameSize();
        long l = (long)Math.pow(2.0, this.mAudioFormat.getSampleSizeInBits());
        long l2 = l / 2L;
        if (n3 * n2 == n4) {
            for (int i = 0; i < n * n3; ++i) {
                int n5 = i * n2;
                long l3 = 0L;
                for (int j = 0; j < n2; ++j) {
                    l3 |= (long)((this.mInputBuffer[n5 + j] & 0xFF) << j * 8);
                }
                if (l3 >= l2) {
                    l3 -= l;
                }
                this.mOutputBuffer[i] = (float)l3 / (float)l2;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                int n6 = i * n3;
                int n7 = i * n4;
                for (int j = 0; j < n3; ++j) {
                    long l4 = 0L;
                    for (int k = 0; k < n2; ++k) {
                        l4 |= (long)((this.mInputBuffer[n7 + k] & 0xFF) << k * 8);
                    }
                    if (l4 >= l2) {
                        l4 -= l;
                    }
                    this.mOutputBuffer[n6 + j] = (float)l4 / (float)l2;
                    n7 += n2;
                }
            }
        }
    }

    @Override
    protected boolean generate() {
        if (this.reachedEndOfStream()) {
            super.quit();
            return false;
        }
        try {
            int n = this.mNumSamplesToBuffer * this.mAudioFormat.getFrameSize();
            int n2 = this.mInputStream.read(this.mInputBuffer, 0, n);
            int n3 = n2 / this.mAudioFormat.getFrameSize();
            this.convertToUniformPCM(n3);
            super.propagate(this.mOutputBuffer, n3, this.mAudioFormat.getChannels(), (int)this.mAudioFormat.getSampleRate());
            if (n2 < n) {
                this.close();
            }
        }
        catch (IOException iOException) {
            this.close();
        }
        return true;
    }
}

