/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.sound.system.processors;

import games.stendhal.client.sound.system.SignalProcessor;
import games.stendhal.common.math.Algebra;
import games.stendhal.common.math.Numeric;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

public class SoundLayers {
    private boolean mStateChanged = true;
    private TreeMap<Integer, Layer> mLayers = new TreeMap(new Comparator<Integer>(){

        @Override
        public int compare(Integer n, Integer n2) {
            return n2.compareTo(n);
        }
    });

    public synchronized VolumeAdjustor createVolumeAdjustor(int n) {
        Layer layer = this.getLayer(n);
        VolumeAdjustor volumeAdjustor = new VolumeAdjustor(layer);
        layer.adjustors.add(volumeAdjustor);
        return volumeAdjustor;
    }

    public synchronized void removeVolumeAdjustor(VolumeAdjustor volumeAdjustor) {
        ((VolumeAdjustor)volumeAdjustor).mLayer.adjustors.remove(volumeAdjustor);
    }

    private void computeVolumes() {
        int n = 0;
        for (Layer layer : this.mLayers.values()) {
            int n2 = 0;
            for (VolumeAdjustor volumeAdjustor : layer.adjustors) {
                n2 = Math.max(n2, volumeAdjustor.mIntensity.get());
            }
            n2 = Math.min(n2, SoundLayers.floatToInt(1.0f) - n);
            n2 = Math.max(n2, 0);
            n += n2;
            layer.volume.set(n2);
        }
        this.mStateChanged = false;
    }

    private Layer getLayer(int n) {
        Layer layer = this.mLayers.get(n);
        if (layer == null) {
            layer = new Layer(n);
            this.mLayers.put(n, layer);
        }
        return layer;
    }

    private static int floatToInt(float f) {
        return Numeric.floatToInt(f, 1.0E7f);
    }

    private static float intToFloat(int n) {
        return Numeric.intToFloat(n, 1.0E7f);
    }

    private static class Layer {
        int level;
        LinkedList<VolumeAdjustor> adjustors = new LinkedList();
        AtomicInteger volume = new AtomicInteger(SoundLayers.access$000(1.0f));

        Layer(int n) {
            this.level = n;
        }
    }

    public final class VolumeAdjustor
    extends SignalProcessor {
        private AtomicInteger mIntensity = new AtomicInteger(SoundLayers.access$000(1.0f));
        private Layer mLayer;

        private VolumeAdjustor(Layer layer) {
            this.mLayer = layer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setLayer(int n) {
            if (this.mLayer.level == n) {
                return;
            }
            SoundLayers soundLayers = SoundLayers.this;
            synchronized (soundLayers) {
                this.mLayer.adjustors.remove(this);
                this.mLayer = SoundLayers.this.getLayer(n);
                this.mLayer.adjustors.add(this);
                SoundLayers.this.mStateChanged = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setIntensity(float f) {
            if (Algebra.isEqual_Scalf(f, SoundLayers.intToFloat(this.mIntensity.get()))) {
                return;
            }
            SoundLayers soundLayers = SoundLayers.this;
            synchronized (soundLayers) {
                this.mIntensity.set(SoundLayers.floatToInt(f));
                SoundLayers.this.mStateChanged = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void modify(float[] fArray, int n, int n2, int n3) {
            SoundLayers soundLayers = SoundLayers.this;
            synchronized (soundLayers) {
                if (SoundLayers.this.mStateChanged) {
                    SoundLayers.this.computeVolumes();
                }
            }
            float f = SoundLayers.intToFloat(Math.min(this.mLayer.volume.get(), this.mIntensity.get()));
            if (Algebra.isEqual_Scalf(f, 0.0f)) {
                return;
            }
            if (!Algebra.isEqual_Scalf(f, 1.0f)) {
                int n4 = 0;
                while (n4 < n * n2) {
                    int n5 = n4++;
                    fArray[n5] = fArray[n5] * f;
                }
            }
            super.propagate(fArray, n, n2, n3);
        }
    }
}

