/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.sprite;

import games.stendhal.client.gui.TransparencyMode;
import games.stendhal.client.gui.j2d.Blend;
import games.stendhal.client.sprite.AnimatedSprite;
import games.stendhal.client.sprite.DataLoader;
import games.stendhal.client.sprite.EmptySprite;
import games.stendhal.client.sprite.ImageSprite;
import games.stendhal.client.sprite.Sprite;
import games.stendhal.client.sprite.SpriteCache;
import games.stendhal.client.sprite.TileSprite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;

public class SpriteStore {
    private static final Logger logger = Logger.getLogger(SpriteStore.class);
    private static SpriteStore single = new SpriteStore();
    private GraphicsConfiguration gc;
    private static final String FAILSAFE_ICON_REF = "data/sprites/failsafe.png";

    protected SpriteStore() {
        try {
            this.gc = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        }
        catch (HeadlessException headlessException) {
            logger.warn((Object)("Cannot initialize graphic user interface: " + headlessException));
        }
    }

    public static SpriteStore get() {
        return single;
    }

    public AnimatedSprite getAnimatedSprite(Sprite sprite, int n, int n2, int n3, int n4, int n5, int n6) {
        return new AnimatedSprite(this.getTiles(sprite, n, n2, n3, n4, n5), n6, true);
    }

    public AnimatedSprite getAnimatedSprite(Sprite sprite, int n, int n2) {
        int n3 = sprite.getHeight();
        int n4 = sprite.getWidth() / n;
        return this.getAnimatedSprite(sprite, 0, 0, n4, n, n3, n2);
    }

    public AnimatedSprite getAnimatedSprite(Sprite sprite, int n) {
        return this.getAnimatedSprite(sprite, sprite.getHeight(), n);
    }

    public Sprite[] getTiles(Sprite sprite, int n, int n2, int n3, int n4, int n5) {
        if (sprite == null) {
            return new Sprite[0];
        }
        Sprite[] spriteArray = new Sprite[n3];
        int n6 = n;
        for (int i = 0; i < n3; ++i) {
            spriteArray[i] = this.getTile(sprite, n6, n2, n4, n5);
            n6 += n4;
        }
        return spriteArray;
    }

    public Sprite getFailsafe() {
        return this.getSprite(FAILSAFE_ICON_REF);
    }

    public Sprite getSprite(String string) {
        SpriteCache spriteCache = SpriteCache.get();
        Sprite sprite = spriteCache.get(string);
        if (sprite == null && (sprite = this.loadSprite(string)) != null) {
            spriteCache.add(string, sprite);
        }
        return sprite;
    }

    public Sprite getCombatSprite(String string) {
        return this.getSprite("data/sprites/combat/" + string);
    }

    public Sprite getStatusSprite(String string) {
        return this.getSprite("data/sprites/status/" + string);
    }

    public Sprite getColoredSprite(String string, Color color) {
        if (color == null) {
            return this.getSprite(string);
        }
        return this.getModifiedSprite(string, color, Blend.TrueColor);
    }

    public Sprite getModifiedSprite(String string, Color color, Composite composite) {
        String string2;
        if (color == null || composite == null) {
            return this.getSprite(string);
        }
        SpriteCache spriteCache = SpriteCache.get();
        Sprite sprite = spriteCache.get(string2 = this.createModifiedRef(string, color, composite));
        if (sprite == null) {
            sprite = this.modifySprite(this.getSprite(string), color, composite, string2);
        }
        return sprite;
    }

    public String createModifiedRef(String string, Color color, Composite composite) {
        String string2 = Integer.toHexString(color.getRGB());
        return string + "@" + composite.toString() + "#" + string2;
    }

    public Sprite modifySprite(Sprite sprite, Color color, Composite composite, Object object) {
        int n = sprite.getWidth();
        int n2 = sprite.getHeight();
        BufferedImage bufferedImage = this.gc.createCompatibleImage(n, n2, TransparencyMode.TRANSPARENCY);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        sprite.draw(graphics2D, 0, 0);
        graphics2D.setColor(color);
        graphics2D.setComposite(composite);
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.dispose();
        ImageSprite imageSprite = new ImageSprite(bufferedImage, object);
        SpriteCache spriteCache = SpriteCache.get();
        spriteCache.add(object, imageSprite);
        return imageSprite;
    }

    public boolean existsSprite(String string) {
        URL uRL = DataLoader.getResource(string);
        return uRL != null;
    }

    private Sprite loadSprite(String string) {
        Object object;
        BufferedImage bufferedImage = null;
        try {
            if (string.startsWith("http://") || string.startsWith("https://")) {
                logger.info((Object)"Loading sprite from a URL...");
                object = new URL(string);
            } else {
                object = DataLoader.getResource(string);
            }
            if (object == null) {
                logger.error((Object)("Can't find ref: " + string));
                if (string.equals(FAILSAFE_ICON_REF)) {
                    logger.error((Object)"Cannot find FAILSAFE_ICON_REF: data/sprites/failsafe.png");
                    return null;
                }
                return this.getFailsafe();
            }
            bufferedImage = ImageIO.read((URL)object);
        }
        catch (IOException iOException) {
            logger.error((Object)("Failed to read: " + string), (Throwable)iOException);
            if (string.equals(FAILSAFE_ICON_REF)) {
                logger.error((Object)"Cannot read FAILSAFE_ICON_REF: data/sprites/failsafe.png");
                return null;
            }
            return this.getFailsafe();
        }
        object = this.gc.createCompatibleImage(bufferedImage.getWidth(), bufferedImage.getHeight(), TransparencyMode.TRANSPARENCY);
        ((Image)object).getGraphics().drawImage(bufferedImage, 0, 0, null);
        ImageSprite imageSprite = new ImageSprite((Image)object, (Object)string);
        return imageSprite;
    }

    public Sprite getEmptySprite() {
        return this.getEmptySprite(32, 32);
    }

    public Sprite getEmptySprite(int n, int n2) {
        Object object;
        SpriteCache spriteCache = SpriteCache.get();
        Sprite sprite = spriteCache.get(object = EmptySprite.createReference(n, n2));
        if (sprite == null) {
            sprite = new EmptySprite(n, n2, object);
            spriteCache.add(object, sprite);
        }
        return sprite;
    }

    public Sprite getTile(Sprite sprite, int n, int n2, int n3, int n4) {
        TileSprite.TSRef tSRef;
        SpriteCache spriteCache = SpriteCache.get();
        Sprite sprite2 = spriteCache.get(tSRef = TileSprite.createReference(sprite, n, n2, n3, n4));
        if (sprite2 == null) {
            sprite2 = sprite.createRegion(n, n2, n3, n4, tSRef);
            if (tSRef != null) {
                spriteCache.add(tSRef, sprite2);
            }
        }
        return sprite2;
    }
}

