/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.common.grammar;

import games.stendhal.common.grammar.Grammar;
import games.stendhal.common.grammar.ItemParserResult;
import games.stendhal.common.parser.Expression;
import games.stendhal.common.parser.NameSearch;
import games.stendhal.common.parser.Sentence;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ItemParser {
    protected Set<String> itemNames;

    public ItemParser() {
        this.itemNames = new HashSet<String>();
    }

    public ItemParser(Set<String> set) {
        this.itemNames = set;
    }

    public ItemParser(String string) {
        this.itemNames = new HashSet<String>();
        this.itemNames.add(string);
    }

    public Set<String> getItemNames() {
        return this.itemNames;
    }

    public ItemParserResult parse(Sentence sentence) {
        if (this.itemNames.isEmpty()) {
            String string;
            int n;
            List<Expression> list = sentence.getExpressions();
            if (list.size() == 1) {
                Expression expression = list.get(0);
                n = expression.getAmount();
                string = expression.getNormalized();
            } else {
                Expression expression = sentence.getNumeral();
                n = expression != null ? expression.getAmount() : 1;
                string = sentence.getExpressionStringAfterVerb();
            }
            return new ItemParserResult(false, string, n, null);
        }
        NameSearch nameSearch = sentence.findMatchingName(this.itemNames);
        boolean bl = nameSearch.found();
        String string = nameSearch.getName();
        int n = nameSearch.getAmount();
        HashSet<String> hashSet = null;
        if (!bl) {
            if (sentence.getNumeralCount() == 1 && sentence.getUnknownTypeCount() == 0 && sentence.getObjectCount() == 0) {
                Expression expression = sentence.getNumeral();
                n = expression.getAmount();
            } else {
                string = sentence.getExpressionStringAfterVerb();
                n = 1;
            }
            if (string == null && this.itemNames.size() == 1) {
                string = this.itemNames.iterator().next();
                bl = true;
            } else if (string != null) {
                hashSet = new HashSet<String>();
                for (String string2 : this.itemNames) {
                    if (!string2.endsWith(" " + string) && !string2.startsWith(string + " ")) continue;
                    hashSet.add(string2);
                }
            }
        }
        return new ItemParserResult(bl, string, n, hashSet);
    }

    public String getErrormessage(ItemParserResult itemParserResult, String string, String string2) {
        String string3 = itemParserResult.getChosenItemName();
        Set<String> set = itemParserResult.getMayBeItems();
        if (string3 == null) {
            return "Please tell me what you want to " + string + ".";
        }
        if (set != null && set.size() > 1) {
            return "There is more than one " + string3 + ". " + "Please specify which sort of " + string3 + " you want to " + string + ".";
        }
        if (set != null && !set.isEmpty()) {
            return "Please specify which sort of " + string3 + " you want to " + string + ".";
        }
        if (string2 != null) {
            return "Sorry, I don't " + string2 + " " + Grammar.plural(string3) + ".";
        }
        return null;
    }
}

