/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.common.memory;

import java.lang.reflect.Array;

public class Field {
    public static byte[] expand(byte[] byArray, int n, boolean bl) {
        if (byArray == null || byArray.length < n) {
            byte[] byArray2 = new byte[n];
            if (bl && byArray != null) {
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            }
            return byArray2;
        }
        return byArray;
    }

    public static int[] expand(int[] nArray, int n, boolean bl) {
        if (nArray == null || nArray.length < n) {
            int[] nArray2 = new int[n];
            if (bl && nArray != null) {
                System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            }
            return nArray2;
        }
        return nArray;
    }

    public static float[] expand(float[] fArray, int n, boolean bl) {
        if (fArray == null || fArray.length < n) {
            float[] fArray2 = new float[n];
            if (bl && fArray != null) {
                System.arraycopy(fArray, 0, fArray2, 0, fArray.length);
            }
            return fArray2;
        }
        return fArray;
    }

    public static <T> T[] expand(T[] TArray, int n, boolean bl) {
        if (TArray == null) {
            throw new IllegalArgumentException("argument field must not be null");
        }
        if (TArray.length < n) {
            Class<?> clazz = TArray.getClass().getComponentType();
            Object[] objectArray = (Object[])Array.newInstance(clazz, n);
            if (bl) {
                System.arraycopy(TArray, 0, objectArray, 0, TArray.length);
            }
            return objectArray;
        }
        return TArray;
    }

    public static float[] rshift(float[] fArray, int n, int n2, int n3, boolean bl) {
        if (fArray == null) {
            throw new IllegalArgumentException("the field argument must not be null");
        }
        if (n < 0 || n >= fArray.length) {
            throw new IllegalArgumentException("the offset argument must be in range 0 >= offset < field.length");
        }
        n2 = Math.min(fArray.length - n, n2);
        int n4 = n + n2 + n3;
        int n5 = n + n2;
        if (n4 > fArray.length) {
            if (bl) {
                fArray = Field.expand(fArray, n4, true);
            } else {
                n4 = fArray.length;
                n5 = fArray.length - n3;
            }
        }
        while (n5 > n) {
            fArray[--n4] = fArray[--n5];
        }
        return fArray;
    }

    public static <T> T[] rshift(T[] TArray, int n, int n2, int n3, boolean bl) {
        if (TArray == null) {
            throw new IllegalArgumentException("the field argument must not be null");
        }
        if (n < 0 || n >= TArray.length) {
            throw new IllegalArgumentException("the offset argument must be in range 0 >= offset < field.length");
        }
        n2 = Math.min(TArray.length - n, n2);
        int n4 = n + n2 + n3;
        int n5 = n + n2;
        if (n4 > TArray.length) {
            if (bl) {
                TArray = Field.expand(TArray, n4, true);
            } else {
                n4 = TArray.length;
                n5 = TArray.length - n3;
            }
        }
        while (n5 > n) {
            TArray[--n4] = TArray[--n5];
        }
        return TArray;
    }

    public static <T> T[] append(T[] TArray, int n, T ... TArray2) {
        TArray = Field.expand(TArray, n + TArray2.length, true);
        System.arraycopy(TArray2, 0, TArray, n, TArray2.length);
        return TArray;
    }

    public static float[] insert(float[] fArray, int n, int n2, float ... fArray2) {
        if (n < n2) {
            fArray = Field.rshift(fArray, n, n2 - n, fArray2.length, true);
        } else {
            fArray = Field.expand(fArray, n2 + fArray2.length, true);
            n = n2;
        }
        System.arraycopy(fArray2, 0, fArray, n, fArray2.length);
        return fArray;
    }

    public static <T> T[] insert(T[] TArray, int n, int n2, T ... TArray2) {
        if (n < n2) {
            TArray = Field.rshift(TArray, n, n2 - n, TArray2.length, true);
        } else {
            TArray = Field.expand(TArray, n2 + TArray2.length, true);
            n = n2;
        }
        System.arraycopy(TArray2, 0, TArray, n, TArray2.length);
        return TArray;
    }
}

