/*
 * Decompiled with CFR 0.152.
 */
package marauroa.client;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import marauroa.client.BannedAddressException;
import marauroa.client.LoginFailedException;
import marauroa.client.TimeoutException;
import marauroa.client.net.INetworkClientManagerInterface;
import marauroa.client.net.KeepAliveSender;
import marauroa.client.net.TCPNetworkClientManager;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.common.crypto.Hash;
import marauroa.common.crypto.RSAPublicKey;
import marauroa.common.game.AccountResult;
import marauroa.common.game.CharacterResult;
import marauroa.common.game.RPAction;
import marauroa.common.game.RPObject;
import marauroa.common.game.Result;
import marauroa.common.i18n.I18N;
import marauroa.common.net.InvalidVersionException;
import marauroa.common.net.message.Message;
import marauroa.common.net.message.MessageC2SAction;
import marauroa.common.net.message.MessageC2SChooseCharacter;
import marauroa.common.net.message.MessageC2SCreateAccount;
import marauroa.common.net.message.MessageC2SCreateCharacter;
import marauroa.common.net.message.MessageC2SKeepAlive;
import marauroa.common.net.message.MessageC2SLoginRequestKey;
import marauroa.common.net.message.MessageC2SLoginSendNonceNameAndPassword;
import marauroa.common.net.message.MessageC2SLoginSendNonceNamePasswordAndSeed;
import marauroa.common.net.message.MessageC2SLoginSendPromise;
import marauroa.common.net.message.MessageC2SLogout;
import marauroa.common.net.message.MessageC2SOutOfSync;
import marauroa.common.net.message.MessageC2STransferACK;
import marauroa.common.net.message.MessageS2CCharacterList;
import marauroa.common.net.message.MessageS2CConnectNACK;
import marauroa.common.net.message.MessageS2CCreateAccountACK;
import marauroa.common.net.message.MessageS2CCreateAccountNACK;
import marauroa.common.net.message.MessageS2CCreateCharacterACK;
import marauroa.common.net.message.MessageS2CCreateCharacterNACK;
import marauroa.common.net.message.MessageS2CInvalidMessage;
import marauroa.common.net.message.MessageS2CLoginACK;
import marauroa.common.net.message.MessageS2CLoginMessageNACK;
import marauroa.common.net.message.MessageS2CLoginNACK;
import marauroa.common.net.message.MessageS2CLoginSendKey;
import marauroa.common.net.message.MessageS2CLoginSendNonce;
import marauroa.common.net.message.MessageS2CPerception;
import marauroa.common.net.message.MessageS2CServerInfo;
import marauroa.common.net.message.MessageS2CTransfer;
import marauroa.common.net.message.MessageS2CTransferREQ;
import marauroa.common.net.message.TransferContent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClientFramework {
    private static final Logger logger = Log4J.getLogger(ClientFramework.class);
    public static final int TIMEOUT = 10000;
    private static final int TIMEOUT_EXTENDED = 300000;
    private Timer keepAliveTimer = null;
    protected INetworkClientManagerInterface netMan;
    private final List<Message> messages;

    public ClientFramework(String string) {
        Log4J.init(string);
        this.messages = new LinkedList<Message>();
        I18N.init(Locale.getDefault());
    }

    public ClientFramework() {
        Log4J.init();
        this.messages = new LinkedList<Message>();
        I18N.init(Locale.getDefault());
    }

    public void connect(String string, int n) throws IOException {
        InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n);
        IOException iOException = null;
        boolean bl = false;
        try {
            Proxy proxy = this.discoverProxy(string, n);
            if (proxy != Proxy.NO_PROXY) {
                this.connect(proxy, inetSocketAddress);
                bl = true;
            }
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            iOException = new IOException(illegalArgumentException);
        }
        if (!bl) {
            try {
                this.connect(Proxy.NO_PROXY, inetSocketAddress);
            }
            catch (IOException iOException3) {
                if (iOException != null) {
                    throw iOException;
                }
                throw iOException3;
            }
        }
    }

    private Proxy discoverProxy(String string, int n) throws IOException {
        ProxySelector proxySelector = ProxySelector.getDefault();
        if (proxySelector == null) {
            return Proxy.NO_PROXY;
        }
        String string2 = string;
        URI uRI = null;
        if (!string.startsWith("[") && string.indexOf(":") >= 0) {
            string2 = "[" + string + "]";
        }
        try {
            uRI = new URI("socket://" + string2 + ":" + n);
        }
        catch (URISyntaxException uRISyntaxException) {
            IOException iOException = new IOException(I18N.translate("Error while discovering proxyserver: %1$s", uRISyntaxException.toString()));
            iOException.initCause(uRISyntaxException);
            throw iOException;
        }
        List<Proxy> list = proxySelector.select(uRI);
        if (list == null) {
            return Proxy.NO_PROXY;
        }
        for (Proxy proxy : list) {
            if (proxy.type() != Proxy.Type.SOCKS) continue;
            return proxy;
        }
        return Proxy.NO_PROXY;
    }

    public void connect(Proxy proxy, InetSocketAddress inetSocketAddress) throws IOException {
        this.netMan = new TCPNetworkClientManager(proxy, inetSocketAddress);
    }

    private Message getMessage(int n) throws InvalidVersionException, TimeoutException, BannedAddressException {
        Message message = null;
        if (this.messages.isEmpty()) {
            message = this.netMan.getMessage(n);
            if (message instanceof MessageS2CConnectNACK) {
                throw new BannedAddressException();
            }
            if (message == null) {
                throw new TimeoutException();
            }
        } else {
            message = this.messages.remove(0);
        }
        logger.debug("CF getMessage: " + message);
        return message;
    }

    @Deprecated
    public synchronized void resync() {
        MessageC2SOutOfSync messageC2SOutOfSync = new MessageC2SOutOfSync();
        this.netMan.addMessage(messageC2SOutOfSync);
    }

    public synchronized void login(String string, String string2) throws InvalidVersionException, TimeoutException, LoginFailedException, BannedAddressException {
        this.login(string, string2, null);
    }

    public synchronized void login(String string, String string2, String string3) throws InvalidVersionException, TimeoutException, LoginFailedException, BannedAddressException {
        int n = 0;
        RSAPublicKey rSAPublicKey = null;
        byte[] byArray = null;
        byte[] byArray2 = null;
        this.netMan.addMessage(new MessageC2SLoginRequestKey(null, this.getGameName(), this.getVersionNumber()));
        int n2 = 10000;
        block12: while (n < 3) {
            Message message = this.getMessage(n2);
            n2 = 300000;
            switch (message.getType()) {
                case S2C_INVALIDMESSAGE: {
                    throw new LoginFailedException(((MessageS2CInvalidMessage)message).getReason());
                }
                case S2C_LOGIN_SENDKEY: {
                    logger.debug("Received Key");
                    rSAPublicKey = ((MessageS2CLoginSendKey)message).getKey();
                    byArray = Hash.random(Hash.hashLength());
                    Object object3 = Locale.getDefault();
                    this.netMan.addMessage(new MessageC2SLoginSendPromise(null, Hash.hash(byArray), ((Locale)object3).getLanguage()));
                    continue block12;
                }
                case S2C_LOGIN_SENDNONCE: {
                    Object object;
                    Object object2;
                    logger.debug("Received Server Nonce");
                    if (byArray2 != null) {
                        throw new LoginFailedException(I18N.translate("Already received a serverNonce", new Object[0]));
                    }
                    byArray2 = ((MessageS2CLoginSendNonce)message).getHash();
                    Object object3 = Hash.xor(byArray, byArray2);
                    if (object3 == null) {
                        throw new LoginFailedException(I18N.translate("Incorrect hash b1", new Object[0]));
                    }
                    Object object4 = Hash.xor((byte[])object3, Hash.hash(string2));
                    if (object4 == null) {
                        throw new LoginFailedException(I18N.translate("Incorrect hash b2", new Object[0]));
                    }
                    Object[] objectArray = rSAPublicKey.encodeByteArray((byte[])object4);
                    if (string3 != null) {
                        object2 = null;
                        try {
                            object2 = string3.getBytes("UTF-8");
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            logger.error(unsupportedEncodingException, unsupportedEncodingException);
                        }
                        if (((Object)object2).length != 16) {
                            throw new LoginFailedException(I18N.translate("Seed has not the correct length.", new Object[0]));
                        }
                        object = null;
                        object = Hash.xor((byte[])object3, (byte[])object2);
                        if (object == null) {
                            throw new LoginFailedException(I18N.translate("Incorrect hash seed", new Object[0]));
                        }
                        byte[] byArray3 = rSAPublicKey.encodeByteArray((byte[])object);
                        this.netMan.addMessage(new MessageC2SLoginSendNonceNamePasswordAndSeed(null, byArray, string, (byte[])objectArray, byArray3));
                        continue block12;
                    }
                    this.netMan.addMessage(new MessageC2SLoginSendNonceNameAndPassword(null, byArray, string, (byte[])objectArray));
                    continue block12;
                }
                case S2C_LOGIN_ACK: {
                    logger.debug("Login correct");
                    this.onPreviousLogins(((MessageS2CLoginACK)message).getPreviousLogins());
                    ++n;
                    continue block12;
                }
                case S2C_CHARACTERLIST: {
                    logger.debug("Received Character list");
                    Object object3 = ((MessageS2CCharacterList)message).getCharacters();
                    this.onAvailableCharacters((String[])object3);
                    Object object4 = ((MessageS2CCharacterList)message).getCharacterDetails();
                    this.onAvailableCharacterDetails((Map<String, RPObject>)object4);
                    ++n;
                    continue block12;
                }
                case S2C_SERVERINFO: {
                    logger.debug("Received Server info");
                    Object[] objectArray = ((MessageS2CServerInfo)message).getContents();
                    this.onServerInfo((String[])objectArray);
                    ++n;
                    continue block12;
                }
                case S2C_LOGIN_NACK: {
                    Object object2 = (MessageS2CLoginNACK)message;
                    logger.debug("Login failed. Reason: " + ((MessageS2CLoginNACK)object2).getResolution());
                    throw new LoginFailedException(((MessageS2CLoginNACK)object2).getResolution(), ((MessageS2CLoginNACK)object2).getResolutionCode());
                }
                case S2C_LOGIN_MESSAGE_NACK: {
                    Object object = (MessageS2CLoginMessageNACK)message;
                    logger.debug("Login failed. Reason: " + ((MessageS2CLoginMessageNACK)object).getReason());
                    throw new LoginFailedException(((MessageS2CLoginMessageNACK)object).getReason());
                }
            }
            this.messages.add(message);
        }
    }

    public synchronized boolean chooseCharacter(String string) throws TimeoutException, InvalidVersionException, BannedAddressException {
        MessageC2SChooseCharacter messageC2SChooseCharacter = new MessageC2SChooseCharacter(null, string);
        this.netMan.addMessage(messageC2SChooseCharacter);
        boolean bl = false;
        while (!bl) {
            Message message = this.getMessage(300000);
            switch (message.getType()) {
                case S2C_CHOOSECHARACTER_ACK: {
                    logger.debug("Choose Character ACK");
                    this.keepAliveTimer = new Timer("KeepAlive", true);
                    this.keepAliveTimer.schedule((TimerTask)new KeepAliveSender(this.netMan), 1000L, 10000L);
                    return true;
                }
                case S2C_CHOOSECHARACTER_NACK: {
                    logger.debug("Choose Character NACK");
                    return false;
                }
            }
            this.messages.add(message);
        }
        return false;
    }

    public synchronized AccountResult createAccount(String string, String string2, String string3) throws TimeoutException, InvalidVersionException, BannedAddressException {
        Locale locale = Locale.getDefault();
        MessageC2SCreateAccount messageC2SCreateAccount = new MessageC2SCreateAccount(null, string, string2, string3, locale.getLanguage());
        this.netMan.addMessage(messageC2SCreateAccount);
        int n = 0;
        AccountResult accountResult = null;
        block5: while (n != 1) {
            Message message = this.getMessage(300000);
            switch (message.getType()) {
                case S2C_INVALIDMESSAGE: {
                    accountResult = new AccountResult(Result.FAILED_EXCEPTION, string);
                    continue block5;
                }
                case S2C_CREATEACCOUNT_ACK: {
                    logger.debug("Create account ACK");
                    MessageS2CCreateAccountACK messageS2CCreateAccountACK = (MessageS2CCreateAccountACK)message;
                    accountResult = new AccountResult(Result.OK_CREATED, messageS2CCreateAccountACK.getUsername());
                    ++n;
                    continue block5;
                }
                case S2C_CREATEACCOUNT_NACK: {
                    logger.debug("Create account NACK");
                    MessageS2CCreateAccountNACK messageS2CCreateAccountNACK = (MessageS2CCreateAccountNACK)message;
                    accountResult = new AccountResult(messageS2CCreateAccountNACK.getResolutionCode(), string);
                    ++n;
                    continue block5;
                }
            }
            logger.debug("Unexpected method while waiting for confirmation of account creation: " + message);
        }
        return accountResult;
    }

    public synchronized CharacterResult createCharacter(String string, RPObject rPObject) throws TimeoutException, InvalidVersionException, BannedAddressException {
        MessageC2SCreateCharacter messageC2SCreateCharacter = new MessageC2SCreateCharacter(null, string, rPObject);
        this.netMan.addMessage(messageC2SCreateCharacter);
        int n = 0;
        CharacterResult characterResult = null;
        while (n != 2) {
            Message message = this.getMessage(300000);
            switch (message.getType()) {
                case S2C_CREATECHARACTER_ACK: {
                    logger.debug("Create character ACK");
                    MessageS2CCreateCharacterACK messageS2CCreateCharacterACK = (MessageS2CCreateCharacterACK)message;
                    characterResult = new CharacterResult(Result.OK_CREATED, messageS2CCreateCharacterACK.getCharacter(), messageS2CCreateCharacterACK.getTemplate());
                    ++n;
                    break;
                }
                case S2C_CHARACTERLIST: {
                    logger.debug("Received Character list");
                    String[] stringArray = ((MessageS2CCharacterList)message).getCharacters();
                    this.onAvailableCharacters(stringArray);
                    HashMap<String, RPObject> hashMap = ((MessageS2CCharacterList)message).getCharacterDetails();
                    this.onAvailableCharacterDetails(hashMap);
                    ++n;
                    break;
                }
                case S2C_CREATECHARACTER_NACK: {
                    logger.debug("Create character NACK");
                    MessageS2CCreateCharacterNACK messageS2CCreateCharacterNACK = (MessageS2CCreateCharacterNACK)message;
                    characterResult = new CharacterResult(messageS2CCreateCharacterNACK.getResolutionCode(), string, rPObject);
                    return characterResult;
                }
            }
        }
        return characterResult;
    }

    public void send(RPAction rPAction) {
        MessageC2SAction messageC2SAction = new MessageC2SAction(null, rPAction);
        this.netMan.addMessage(messageC2SAction);
    }

    public synchronized boolean logout() throws InvalidVersionException, TimeoutException, BannedAddressException {
        MessageC2SLogout messageC2SLogout = new MessageC2SLogout(null);
        this.netMan.addMessage(messageC2SLogout);
        boolean bl = false;
        while (!bl) {
            Message message = this.getMessage(10000);
            switch (message.getType()) {
                case S2C_LOGOUT_ACK: {
                    logger.debug("Logout ACK");
                    if (this.keepAliveTimer != null) {
                        this.keepAliveTimer.cancel();
                    }
                    return true;
                }
                case S2C_LOGOUT_NACK: {
                    logger.debug("Logout NACK");
                    return false;
                }
            }
        }
        return false;
    }

    public void close() {
        if (this.keepAliveTimer != null) {
            this.keepAliveTimer.cancel();
        }
        if (this.netMan != null) {
            this.netMan.finish();
        }
    }

    public synchronized boolean loop(int n) {
        boolean bl = false;
        this.messages.addAll(((TCPNetworkClientManager)this.netMan).getMessages());
        for (Message message : this.messages) {
            bl = true;
            switch (message.getType()) {
                case S2C_PERCEPTION: {
                    logger.debug("Processing Message Perception");
                    List<TransferContent> list = (MessageS2CPerception)message;
                    this.onPerception((MessageS2CPerception)((Object)list));
                    break;
                }
                case S2C_TRANSFER_REQ: {
                    logger.debug("Processing Content Transfer Request");
                    List<TransferContent> list = ((MessageS2CTransferREQ)message).getContents();
                    list = this.onTransferREQ(list);
                    MessageC2STransferACK messageC2STransferACK = new MessageC2STransferACK(null, list);
                    this.netMan.addMessage(messageC2STransferACK);
                    break;
                }
                case S2C_TRANSFER: {
                    logger.debug("Processing Content Transfer");
                    List<TransferContent> list = ((MessageS2CTransfer)message).getContents();
                    this.onTransfer(list);
                    break;
                }
            }
        }
        this.messages.clear();
        return bl;
    }

    public void sendKeepAlive() {
        MessageC2SKeepAlive messageC2SKeepAlive = new MessageC2SKeepAlive();
        this.netMan.addMessage(messageC2SKeepAlive);
    }

    public boolean getConnectionState() {
        return this.netMan.getConnectionState();
    }

    protected abstract void onPerception(MessageS2CPerception var1);

    protected abstract List<TransferContent> onTransferREQ(List<TransferContent> var1);

    protected abstract void onTransfer(List<TransferContent> var1);

    protected abstract void onAvailableCharacters(String[] var1);

    protected void onAvailableCharacterDetails(Map<String, RPObject> map) {
    }

    protected abstract void onServerInfo(String[] var1);

    protected abstract String getGameName();

    protected abstract String getVersionNumber();

    protected abstract void onPreviousLogins(List<String> var1);
}

