/*
 * Decompiled with CFR 0.152.
 */
package marauroa.common.game;

import java.io.IOException;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.common.game.Validator;
import marauroa.common.net.InputSerializer;
import marauroa.common.net.OutputSerializer;
import marauroa.common.net.Serializable;

public class Definition
implements Serializable {
    private static final Logger logger = Log4J.getLogger(Definition.class);
    private static final Validator validator = new Validator();
    public static final byte STANDARD = 0;
    public static final byte PRIVATE = 1;
    public static final byte HIDDEN = 2;
    public static final byte VOLATILE = 4;
    private DefinitionClass clazz;
    private short code;
    private String name;
    private String value;
    private int capacity;
    private Type type;
    private byte flags;

    public Definition() {
    }

    protected Definition(DefinitionClass definitionClass) {
        this.clazz = definitionClass;
        this.code = (short)-1;
    }

    public String toString() {
        return (Object)((Object)this.clazz) + ": N=" + this.name + " T=" + (Object)((Object)this.type) + " C=" + this.code;
    }

    void setCode(short s) {
        this.code = s;
    }

    public static Definition defineAttribute(String string, Type type, byte by) {
        Definition definition = new Definition(DefinitionClass.ATTRIBUTE);
        definition.name = string;
        definition.type = type;
        definition.flags = by;
        definition.capacity = 0;
        return definition;
    }

    public static Definition defineStaticAttribute(String string, String string2, byte by) {
        Definition definition = new Definition(DefinitionClass.STATIC);
        definition.name = string;
        definition.value = string2;
        definition.type = Type.NOTYPE;
        definition.flags = by;
        definition.capacity = 0;
        return definition;
    }

    public static Definition defineEvent(String string, byte by) {
        Definition definition = new Definition(DefinitionClass.RPEVENT);
        definition.name = string;
        definition.type = Type.NOTYPE;
        definition.flags = by;
        definition.capacity = 0;
        return definition;
    }

    public static Definition defineSlot(String string, int n, byte by) {
        Definition definition = new Definition(DefinitionClass.RPSLOT);
        definition.name = string;
        definition.capacity = n;
        definition.flags = by;
        definition.type = Type.NOTYPE;
        return definition;
    }

    public static Definition defineLink(String string, byte by) {
        Definition definition = new Definition(DefinitionClass.RPLINK);
        definition.name = string;
        definition.capacity = 0;
        definition.flags = by;
        definition.type = Type.NOTYPE;
        return definition;
    }

    public short getCode() {
        return this.code;
    }

    public DefinitionClass getDefinitionClass() {
        return this.clazz;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public Type getType() {
        return this.type;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public byte getFlags() {
        return this.flags;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void setCapacity(byte by) {
        this.capacity = by;
    }

    public void setFlags(byte by) {
        this.flags = by;
    }

    public boolean isVisible() {
        return (this.flags & 3) == 0;
    }

    public boolean isPrivate() {
        return (this.flags & 1) == 1;
    }

    public boolean isHidden() {
        return (this.flags & 2) == 2;
    }

    public boolean isStorable() {
        return (this.flags & 4) == 0;
    }

    public String deserialize(InputSerializer inputSerializer) throws IOException {
        switch (this.type) {
            case VERY_LONG_STRING: {
                return inputSerializer.readString();
            }
            case LONG_STRING: {
                return inputSerializer.read65536LongString();
            }
            case STRING: {
                return inputSerializer.read255LongString();
            }
            case FLOAT: {
                return Float.toString(inputSerializer.readFloat());
            }
            case LONG: {
                return Long.toString(inputSerializer.readLong());
            }
            case INT: {
                return Integer.toString(inputSerializer.readInt());
            }
            case SHORT: {
                return Short.toString(inputSerializer.readShort());
            }
            case BYTE: {
                return Byte.toString(inputSerializer.readByte());
            }
            case FLAG: {
                return "";
            }
        }
        return null;
    }

    public void serialize(String string, OutputSerializer outputSerializer) throws IOException {
        try {
            switch (this.type) {
                case VERY_LONG_STRING: {
                    outputSerializer.write(string);
                    break;
                }
                case LONG_STRING: {
                    outputSerializer.write65536LongString(string);
                    break;
                }
                case STRING: {
                    outputSerializer.write255LongString(string);
                    break;
                }
                case FLOAT: {
                    outputSerializer.write(Float.parseFloat(string));
                    break;
                }
                case LONG: {
                    outputSerializer.write(Long.parseLong(string));
                    break;
                }
                case INT: {
                    outputSerializer.write(Integer.parseInt(string));
                    break;
                }
                case SHORT: {
                    outputSerializer.write(Short.parseShort(string));
                    break;
                }
                case BYTE: {
                    outputSerializer.write(Byte.parseByte(string));
                    break;
                }
                case FLAG: {
                    break;
                }
                default: {
                    logger.error("got unknown attribute(" + this.name + ") type:" + (Object)((Object)this.type));
                    break;
                }
            }
        }
        catch (IOException iOException) {
            logger.warn("Exception caused by name=" + this.name + " type=" + (Object)((Object)this.type) + " code?" + this.code + " value=" + string, iOException);
            throw iOException;
        }
        catch (NullPointerException nullPointerException) {
            logger.warn("Exception caused by name=" + this.name + " type=" + (Object)((Object)this.type) + " code=" + this.code + " value=" + string, nullPointerException);
            throw nullPointerException;
        }
    }

    public void validate(String string) throws IllegalArgumentException {
        try {
            switch (this.type) {
                case VERY_LONG_STRING: {
                    validator.validateVeryLongString(string);
                    break;
                }
                case LONG_STRING: {
                    validator.validate65536LongString(string);
                    break;
                }
                case STRING: {
                    validator.validate255LongString(string);
                    break;
                }
                case FLOAT: {
                    validator.validateFloat(string);
                    break;
                }
                case LONG: {
                    validator.validateLong(string);
                    break;
                }
                case INT: {
                    validator.validateInteger(string);
                    break;
                }
                case SHORT: {
                    validator.validateShort(string);
                    break;
                }
                case BYTE: {
                    validator.validateByte(string);
                    break;
                }
                case FLAG: {
                    break;
                }
                case MAP: {
                    validator.validateMap(string);
                    break;
                }
                default: {
                    logger.error("got unknown attribute(" + this.name + ") type:" + (Object)((Object)this.type));
                    break;
                }
            }
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalArgumentException(runtimeException.getMessage() + " caused by name=" + this.name + " type=" + (Object)((Object)this.type) + " code=" + this.code + " value=" + string, runtimeException);
        }
    }

    public void writeObject(OutputSerializer outputSerializer) throws IOException {
        outputSerializer.write((byte)this.clazz.ordinal());
        outputSerializer.write(this.code);
        outputSerializer.write(this.name);
        outputSerializer.write(this.capacity);
        if (this.value == null) {
            outputSerializer.write((byte)0);
        } else {
            outputSerializer.write((byte)1);
            outputSerializer.write255LongString(this.value);
        }
        outputSerializer.write((byte)this.type.ordinal());
        outputSerializer.write(this.flags);
    }

    public void readObject(InputSerializer inputSerializer) throws IOException {
        this.clazz = DefinitionClass.values()[inputSerializer.readByte()];
        this.code = inputSerializer.readShort();
        this.name = inputSerializer.readString();
        this.capacity = inputSerializer.readInt();
        if (inputSerializer.readByte() == 1) {
            this.value = inputSerializer.read255LongString();
        }
        this.type = Type.values()[inputSerializer.readByte()];
        this.flags = inputSerializer.readByte();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.clazz == null ? 0 : this.clazz.hashCode());
        n = 31 * n + this.code;
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        n = 31 * n + (this.type == null ? 0 : this.type.hashCode());
        n = 31 * n + (this.value == null ? 0 : this.value.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        boolean bl;
        if (!(object instanceof Definition)) {
            return false;
        }
        Definition definition = (Definition)object;
        boolean bl2 = bl = this.clazz.equals((Object)definition.clazz) && this.code == definition.code && this.capacity == definition.capacity && this.flags == definition.flags && this.name.equals(definition.name) && this.type == definition.type;
        if (bl) {
            bl = this.value == null ? definition.value == null : this.value.equals(definition.value);
        }
        return bl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        NOTYPE,
        VERY_LONG_STRING,
        LONG_STRING,
        STRING,
        FLOAT,
        INT,
        SHORT,
        BYTE,
        FLAG,
        MAP,
        LONG;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DefinitionClass {
        STATIC,
        ATTRIBUTE,
        RPSLOT,
        RPEVENT,
        RPLINK;

    }
}

