/*
 * Decompiled with CFR 0.152.
 */
package marauroa.common.game;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.common.game.DefaultRPClass;
import marauroa.common.game.Definition;
import marauroa.common.game.SyntaxException;
import marauroa.common.net.InputSerializer;
import marauroa.common.net.OutputSerializer;
import marauroa.common.net.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RPClass
implements Serializable {
    private static final Logger logger = Log4J.getLogger(RPClass.class);
    private static Map<String, RPClass> rpClassList = new LinkedHashMap<String, RPClass>();
    private String name = null;
    private RPClass parent = null;
    private Map<String, Definition> staticattributes;
    private short lastCode = 0;
    private List<String> definitions = new LinkedList<String>();
    private Map<String, Definition> attributes;
    private Map<String, Definition> rpevents;
    private Map<String, Definition> rpslots;
    private Map<String, Definition> rplinks;
    private boolean baked = false;
    private static final RPClass defaultRPClass = new DefaultRPClass();

    public RPClass() {
        this.staticattributes = new HashMap<String, Definition>();
        this.attributes = new HashMap<String, Definition>();
        this.rpevents = new HashMap<String, Definition>();
        this.rpslots = new HashMap<String, Definition>();
        this.rplinks = new HashMap<String, Definition>();
    }

    public RPClass(String string) {
        this();
        this.name = string;
        this.add(Definition.DefinitionClass.ATTRIBUTE, "id", Definition.Type.INT, (byte)0);
        this.add(Definition.DefinitionClass.ATTRIBUTE, "zoneid", Definition.Type.STRING, (byte)2);
        this.add(Definition.DefinitionClass.ATTRIBUTE, "#clientid", Definition.Type.INT, (byte)6);
        this.add(Definition.DefinitionClass.ATTRIBUTE, "#db_id", Definition.Type.INT, (byte)2);
        if (rpClassList.containsKey(string)) {
            throw new IllegalArgumentException("Duplicated class name: " + string);
        }
        rpClassList.put(string, this);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("RPCLASS name: " + this.name + "\n");
        stringBuilder.append("isa: " + (this.parent != null ? this.parent.getName() : null) + "\n");
        for (Definition definition : this.staticattributes.values()) {
            stringBuilder.append(definition + "\n");
        }
        for (Definition definition : this.attributes.values()) {
            stringBuilder.append(definition + "\n");
        }
        for (Definition definition : this.rpslots.values()) {
            stringBuilder.append(definition + "\n");
        }
        for (Definition definition : this.rplinks.values()) {
            stringBuilder.append(definition + "\n");
        }
        for (Definition definition : this.rpevents.values()) {
            stringBuilder.append(definition + "\n");
        }
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    public static boolean hasRPClass(String string) {
        return rpClassList.containsKey(string);
    }

    public static RPClass getRPClass(String string) {
        return rpClassList.get(string);
    }

    static RPClass getRPClassOrDefault(String string) {
        RPClass rPClass = rpClassList.get(string);
        if (rPClass == null) {
            rPClass = RPClass.getBaseRPObjectDefault();
        }
        return rPClass;
    }

    public void isA(RPClass rPClass) {
        this.parent = rPClass;
        this.lastCode = rPClass.lastCode;
    }

    public void isA(String string) {
        this.parent = RPClass.getRPClass(string);
        this.lastCode = this.parent.lastCode;
    }

    public boolean subclassOf(String string) {
        if (!RPClass.hasRPClass(string)) {
            return false;
        }
        if (this.name.equals(string)) {
            return true;
        }
        if (this.parent != null) {
            return this.parent.subclassOf(string);
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public RPClass getParent() {
        return this.parent;
    }

    private short getValidCode(Definition.DefinitionClass definitionClass, String string) {
        if (this.definitions.contains(string)) {
            throw new SyntaxException(string);
        }
        this.definitions.add(string);
        this.lastCode = (short)(this.lastCode + 1);
        return this.lastCode;
    }

    public void add(Definition.DefinitionClass definitionClass, String string, Definition.Type type) {
        this.add(definitionClass, string, type, (byte)0);
    }

    public void add(Definition.DefinitionClass definitionClass, String string, Definition.Type type, byte by) {
        if (definitionClass != Definition.DefinitionClass.ATTRIBUTE) {
            throw new SyntaxException(string);
        }
        Definition definition = Definition.defineAttribute(string, type, by);
        this.attributes.put(string, definition);
        definition.setCode(this.getValidCode(definitionClass, string));
    }

    public void add(Definition.DefinitionClass definitionClass, String string, byte by) {
        Definition definition = null;
        switch (definitionClass) {
            case RPLINK: {
                definition = Definition.defineEvent(string, by);
                this.rplinks.put(string, definition);
                break;
            }
            case RPEVENT: {
                definition = Definition.defineEvent(string, by);
                this.rpevents.put(string, definition);
                break;
            }
            default: {
                throw new SyntaxException(string);
            }
        }
        definition.setCode(this.getValidCode(definitionClass, string));
    }

    public void add(Definition.DefinitionClass definitionClass, String string, int n, byte by) {
        if (definitionClass != Definition.DefinitionClass.RPSLOT) {
            throw new SyntaxException(string);
        }
        Definition definition = Definition.defineSlot(string, n, by);
        this.rpslots.put(string, definition);
        definition.setCode(this.getValidCode(definitionClass, string));
    }

    public void add(Definition.DefinitionClass definitionClass, String string, String string2, byte by) {
        if (definitionClass != Definition.DefinitionClass.STATIC) {
            throw new SyntaxException(string);
        }
        Definition definition = Definition.defineStaticAttribute(string, string2, by);
        this.staticattributes.put(string, definition);
        definition.setCode(this.getValidCode(definitionClass, string));
    }

    public void addAttribute(String string, Definition.Type type, byte by) {
        this.add(Definition.DefinitionClass.ATTRIBUTE, string, type, by);
    }

    public void addAttribute(String string, Definition.Type type) {
        this.add(Definition.DefinitionClass.ATTRIBUTE, string, type, (byte)0);
    }

    public void addStaticAttribute(String string, String string2, byte by) {
        this.add(Definition.DefinitionClass.STATIC, string, string2, by);
    }

    public void addRPSlot(String string, int n, byte by) {
        this.add(Definition.DefinitionClass.RPSLOT, string, n, by);
    }

    public void addRPSlot(String string, int n) {
        this.add(Definition.DefinitionClass.RPSLOT, string, n, (byte)0);
    }

    public void addRPLink(String string, byte by) {
        this.add(Definition.DefinitionClass.RPLINK, string, by);
    }

    public void addRPEvent(String string, byte by) {
        this.add(Definition.DefinitionClass.RPEVENT, string, by);
    }

    public Definition getDefinition(Definition.DefinitionClass definitionClass, String string) {
        Definition definition = null;
        switch (definitionClass) {
            case STATIC: {
                definition = this.staticattributes.get(string);
                break;
            }
            case ATTRIBUTE: {
                definition = this.attributes.get(string);
                break;
            }
            case RPEVENT: {
                definition = this.rpevents.get(string);
                break;
            }
            case RPSLOT: {
                definition = this.rpslots.get(string);
                break;
            }
            case RPLINK: {
                definition = this.rplinks.get(string);
                break;
            }
            default: {
                throw new SyntaxException("Class not found: " + (Object)((Object)definitionClass));
            }
        }
        if (definition == null && this.parent != null && !this.baked) {
            return this.parent.getDefinition(definitionClass, string);
        }
        return definition;
    }

    public List<Definition> getDefinitions() {
        LinkedList<Definition> linkedList = new LinkedList<Definition>();
        linkedList.addAll(this.staticattributes.values());
        linkedList.addAll(this.attributes.values());
        linkedList.addAll(this.rpevents.values());
        linkedList.addAll(this.rpslots.values());
        linkedList.addAll(this.rplinks.values());
        return linkedList;
    }

    public void bake() {
        if (!this.baked) {
            RPClass rPClass = this.parent;
            while (rPClass != null) {
                this.staticattributes.putAll(rPClass.staticattributes);
                this.attributes.putAll(rPClass.attributes);
                this.rpevents.putAll(rPClass.rpevents);
                this.rpslots.putAll(rPClass.rpslots);
                this.rplinks.putAll(rPClass.rplinks);
                rPClass = rPClass.parent;
            }
        }
        this.baked = true;
    }

    public static void bakeAll() {
        for (RPClass rPClass : rpClassList.values()) {
            rPClass.bake();
        }
    }

    boolean hasAnyDefinition(Definition.DefinitionClass definitionClass) {
        boolean bl = false;
        switch (definitionClass) {
            case STATIC: {
                bl = !this.staticattributes.isEmpty();
                break;
            }
            case ATTRIBUTE: {
                bl = !this.attributes.isEmpty();
                break;
            }
            case RPEVENT: {
                bl = !this.rpevents.isEmpty();
                break;
            }
            case RPSLOT: {
                bl = !this.rpslots.isEmpty();
                break;
            }
            case RPLINK: {
                bl = !this.rplinks.isEmpty();
                break;
            }
            default: {
                throw new SyntaxException("Class not found: " + (Object)((Object)definitionClass));
            }
        }
        if (!bl && this.parent != null) {
            return this.parent.hasAnyDefinition(definitionClass);
        }
        return bl;
    }

    public boolean hasDefinition(Definition.DefinitionClass definitionClass, String string) {
        return this.getDefinition(definitionClass, string) != null;
    }

    public short getCode(Definition.DefinitionClass definitionClass, String string) {
        Definition definition = this.getDefinition(definitionClass, string);
        if (definition != null) {
            return definition.getCode();
        }
        if (this.parent != null) {
            return this.parent.getCode(definitionClass, string);
        }
        throw new SyntaxException(string);
    }

    public String getName(Definition.DefinitionClass definitionClass, short s) {
        Map<String, Definition> map = null;
        switch (definitionClass) {
            case ATTRIBUTE: {
                map = this.attributes;
                break;
            }
            case RPEVENT: {
                map = this.rpevents;
                break;
            }
            case RPSLOT: {
                map = this.rpslots;
                break;
            }
            case RPLINK: {
                map = this.rplinks;
                break;
            }
            default: {
                throw new SyntaxException("Class not found: " + (Object)((Object)definitionClass));
            }
        }
        if (map == null) {
            logger.warn("Unexpected type of Definition: " + (Object)((Object)definitionClass));
            throw new SyntaxException(s);
        }
        for (Definition definition : map.values()) {
            if (definition.getCode() != s) continue;
            return definition.getName();
        }
        if (this.parent != null) {
            return this.parent.getName(definitionClass, s);
        }
        throw new SyntaxException(s);
    }

    @Override
    public void writeObject(OutputSerializer outputSerializer) throws IOException {
        outputSerializer.write(this.name);
        if (this.parent == null) {
            outputSerializer.write((byte)0);
        } else {
            outputSerializer.write((byte)1);
            outputSerializer.write(this.parent.name);
        }
        LinkedList<Map<String, Definition>> linkedList = new LinkedList<Map<String, Definition>>();
        linkedList.add(this.attributes);
        linkedList.add(this.rpslots);
        linkedList.add(this.rpevents);
        linkedList.add(this.rplinks);
        linkedList.add(this.staticattributes);
        for (Map map : linkedList) {
            outputSerializer.write(map.size());
            for (Definition definition : map.values()) {
                outputSerializer.write(definition);
            }
        }
    }

    @Override
    public void readObject(InputSerializer inputSerializer) throws IOException {
        this.name = inputSerializer.readString();
        byte by = inputSerializer.readByte();
        if (by == 1) {
            this.isA(inputSerializer.readString());
        }
        LinkedList<Map<String, Definition>> linkedList = new LinkedList<Map<String, Definition>>();
        linkedList.add(this.attributes);
        linkedList.add(this.rpslots);
        linkedList.add(this.rpevents);
        linkedList.add(this.rplinks);
        linkedList.add(this.staticattributes);
        for (Map map : linkedList) {
            int n = inputSerializer.readInt();
            for (int i = 0; i < n; ++i) {
                Definition definition = (Definition)inputSerializer.readObject(new Definition());
                map.put(definition.getName(), definition);
            }
        }
        rpClassList.put(this.name, this);
    }

    public static Iterator<RPClass> iterator() {
        return rpClassList.values().iterator();
    }

    public static int size() {
        return rpClassList.size();
    }

    public static RPClass getBaseRPObjectDefault() {
        return defaultRPClass;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.attributes == null ? 0 : this.attributes.hashCode());
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        n = 31 * n + (this.parent == null ? 0 : this.parent.hashCode());
        n = 31 * n + (this.rpevents == null ? 0 : this.rpevents.hashCode());
        n = 31 * n + (this.rpslots == null ? 0 : this.rpslots.hashCode());
        n = 31 * n + (this.staticattributes == null ? 0 : this.staticattributes.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RPClass)) {
            return false;
        }
        RPClass rPClass = (RPClass)object;
        boolean bl = this.name == null ? rPClass.name == null : this.name.equals(rPClass.name);
        bl = this.parent == null ? bl && rPClass.parent == null : bl && this.parent.equals(rPClass.parent);
        bl = bl && this.staticattributes.equals(rPClass.staticattributes) && this.attributes.equals(rPClass.attributes) && this.rpevents.equals(rPClass.rpevents) && this.rpslots.equals(rPClass.rpslots);
        return bl;
    }
}

