/*
 * Decompiled with CFR 0.152.
 */
package marauroa.common.game;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.common.game.Attributes;
import marauroa.common.game.Definition;
import marauroa.common.game.DetailLevel;
import marauroa.common.game.RPClass;
import marauroa.common.game.RPObject;
import marauroa.common.game.RPSlot;
import marauroa.common.game.SlotAlreadyAddedException;
import marauroa.common.net.InputSerializer;
import marauroa.common.net.OutputSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SlotOwner
extends Attributes {
    private static final Logger logger = Log4J.getLogger(SlotOwner.class);
    private static final List<RPSlot> EMPTY = Collections.unmodifiableList(new ArrayList());
    protected List<RPSlot> slots;
    private int lastAssignedID;

    public SlotOwner(RPClass rPClass) {
        super(rPClass);
    }

    @Override
    public Object fill(Attributes attributes) {
        Object object = super.fill(attributes);
        this.slots = null;
        if (attributes instanceof SlotOwner) {
            SlotOwner slotOwner = (SlotOwner)attributes;
            this.lastAssignedID = slotOwner.lastAssignedID;
            if (slotOwner.slots != null) {
                this.slots = new LinkedList<RPSlot>();
                for (RPSlot rPSlot : slotOwner.slots) {
                    RPSlot rPSlot2 = (RPSlot)rPSlot.clone();
                    rPSlot2.setOwner(this);
                    this.slots.add(rPSlot2);
                }
            }
        }
        return object;
    }

    public boolean hasSlot(String string) {
        if (this.slots == null) {
            return false;
        }
        for (RPSlot rPSlot : this.slots) {
            if (!rPSlot.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public void addSlot(String string) throws SlotAlreadyAddedException {
        if (this.hasSlot(string)) {
            throw new SlotAlreadyAddedException(string);
        }
        RPSlot rPSlot = new RPSlot(string);
        rPSlot.setOwner(this);
        if (this.slots == null) {
            this.slots = new LinkedList<RPSlot>();
        }
        this.slots.add(rPSlot);
    }

    public void addSlot(RPSlot rPSlot) throws SlotAlreadyAddedException {
        if (this.hasSlot(rPSlot.getName())) {
            throw new SlotAlreadyAddedException(rPSlot.getName());
        }
        rPSlot.setOwner(this);
        if (this.slots == null) {
            this.slots = new LinkedList<RPSlot>();
        }
        this.slots.add(rPSlot);
        for (RPObject rPObject : rPSlot) {
            this.assignSlotID(rPObject);
            rPObject.setContainer(this, rPSlot);
        }
    }

    public RPSlot removeSlot(String string) {
        if (this.slots == null) {
            return null;
        }
        Iterator<RPSlot> iterator = this.slots.iterator();
        while (iterator.hasNext()) {
            RPSlot rPSlot = iterator.next();
            if (!string.equals(rPSlot.getName())) continue;
            iterator.remove();
            return rPSlot;
        }
        return null;
    }

    public RPSlot getSlot(String string) {
        if (this.slots == null) {
            return null;
        }
        for (RPSlot rPSlot : this.slots) {
            if (!string.equals(rPSlot.getName())) continue;
            return rPSlot;
        }
        return null;
    }

    public Iterator<RPSlot> slotsIterator() {
        if (this.slots == null) {
            return EMPTY.iterator();
        }
        return this.slots.iterator();
    }

    public List<RPSlot> slots() {
        if (this.slots == null) {
            return EMPTY;
        }
        return Collections.unmodifiableList(this.slots);
    }

    void assignSlotID(RPObject rPObject) {
        if (this.getContainerOwner() != null) {
            this.getContainerOwner().assignSlotID(rPObject);
        } else {
            rPObject.put("id", this.lastAssignedID++);
            if (rPObject.has("zoneid")) {
                rPObject.remove("zoneid");
            }
        }
    }

    void usedSlotID(int n) {
        if (this.getContainerOwner() != null) {
            this.getContainerOwner().usedSlotID(n);
        } else if (n >= this.lastAssignedID) {
            logger.debug("Reseting slot ID: " + this.lastAssignedID + " -> " + (n + 1));
            this.lastAssignedID = n + 1;
        }
    }

    abstract void setContainer(SlotOwner var1, RPSlot var2);

    abstract SlotOwner getContainerOwner();

    abstract SlotOwner getContainerBaseOwner();

    protected void serializeRPSlots(OutputSerializer outputSerializer, DetailLevel detailLevel) throws IOException {
        int n = 0;
        if (this.slots != null) {
            for (RPSlot rPSlot : this.slots) {
                if (!this.shouldSerialize(Definition.DefinitionClass.RPSLOT, rPSlot.getName(), detailLevel)) continue;
                ++n;
            }
            outputSerializer.write(n);
            for (RPSlot rPSlot : this.slots) {
                Definition definition = this.getRPClass().getDefinition(Definition.DefinitionClass.RPSLOT, rPSlot.getName());
                if (!this.shouldSerialize(definition, detailLevel)) continue;
                rPSlot.writeObject(outputSerializer, detailLevel);
            }
        } else {
            outputSerializer.write(0);
        }
    }

    @Override
    public void writeToJson(StringBuilder stringBuilder, DetailLevel detailLevel) {
        super.writeToJson(stringBuilder, detailLevel);
        if (this.slots == null || this.slots.isEmpty()) {
            return;
        }
        boolean bl = true;
        stringBuilder.append(",\"s\":{");
        for (RPSlot rPSlot : this.slots) {
            Definition definition;
            if (rPSlot.isEmpty() || !this.shouldSerialize(definition = this.getRPClass().getDefinition(Definition.DefinitionClass.RPSLOT, rPSlot.getName()), detailLevel)) continue;
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(",");
            }
            rPSlot.writeToJson(stringBuilder, detailLevel);
        }
        stringBuilder.append("}");
    }

    protected void deserializeRPSlots(InputSerializer inputSerializer) throws IOException {
        int n = inputSerializer.readInt();
        if (n > 262144) {
            throw new IOException("Illegal request of an list of " + String.valueOf(n) + " size");
        }
        if (n > 0) {
            this.slots = new LinkedList<RPSlot>();
            for (int i = 0; i < n; ++i) {
                RPSlot rPSlot = new RPSlot();
                rPSlot.setOwner(this);
                rPSlot = (RPSlot)inputSerializer.readObject(rPSlot);
                this.slots.add(rPSlot);
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        if (this.slots != null) {
            stringBuilder.append(" and RPSlots ");
            for (RPSlot rPSlot : this.slots) {
                stringBuilder.append("[" + rPSlot.toString() + "]");
            }
        }
        return stringBuilder.toString();
    }
}

