/*
 * Decompiled with CFR 0.152.
 */
package marauroa.common.net.message;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import marauroa.common.game.DetailLevel;
import marauroa.common.game.RPObject;
import marauroa.common.net.Channel;
import marauroa.common.net.InputSerializer;
import marauroa.common.net.OutputSerializer;
import marauroa.common.net.Serializable;
import marauroa.common.net.message.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageS2CCharacterList
extends Message {
    private Map<String, RPObject> characters;

    public MessageS2CCharacterList() {
        super(Message.MessageType.S2C_CHARACTERLIST, null);
    }

    public MessageS2CCharacterList(Channel channel, String[] stringArray) {
        super(Message.MessageType.S2C_CHARACTERLIST, channel);
        this.characters = new LinkedHashMap<String, RPObject>();
        for (String string : stringArray) {
            this.characters.put(string, new RPObject());
        }
    }

    public MessageS2CCharacterList(Channel channel, Map<String, RPObject> map) {
        super(Message.MessageType.S2C_CHARACTERLIST, channel);
        this.characters = new LinkedHashMap<String, RPObject>(map);
    }

    public String[] getCharacters() {
        String[] stringArray = new String[this.characters.size()];
        this.characters.keySet().toArray(stringArray);
        return stringArray;
    }

    public HashMap<String, RPObject> getCharacterDetails() {
        return new LinkedHashMap<String, RPObject>(this.characters);
    }

    @Override
    public String toString() {
        return "Message (S2C Character List) from (" + this.getAddress() + ") CONTENTS: (" + this.characters.keySet() + ")";
    }

    @Override
    public void readObject(InputSerializer inputSerializer) throws IOException {
        super.readObject(inputSerializer);
        String[] stringArray = inputSerializer.readStringArray();
        this.characters = new LinkedHashMap<String, RPObject>();
        if (this.protocolVersion >= 32) {
            Object[] objectArray = inputSerializer.readObjectArray(RPObject.class);
            for (int i = 0; i < stringArray.length; ++i) {
                this.characters.put(stringArray[i], (RPObject)objectArray[i]);
            }
        } else {
            for (String string : stringArray) {
                this.characters.put(string, new RPObject());
            }
        }
        if (this.type != Message.MessageType.S2C_CHARACTERLIST) {
            throw new IOException();
        }
    }

    @Override
    public void writeObject(OutputSerializer outputSerializer) throws IOException {
        super.writeObject(outputSerializer);
        outputSerializer.write(this.getCharacters());
        if (this.protocolVersion >= 32) {
            String[] stringArray = this.getCharacters();
            Serializable[] serializableArray = new RPObject[this.characters.size()];
            for (int i = 0; i < this.characters.size(); ++i) {
                serializableArray[i] = this.characters.get(stringArray[i]);
            }
            outputSerializer.write(serializableArray);
        }
    }

    @Override
    public void writeToJson(StringBuilder stringBuilder) {
        super.writeToJson(stringBuilder);
        stringBuilder.append(",\"characters\":{");
        boolean bl = true;
        for (Map.Entry<String, RPObject> entry : this.characters.entrySet()) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(",");
            }
            OutputSerializer.writeJson(stringBuilder, entry.getKey());
            stringBuilder.append(":{");
            entry.getValue().writeToJson(stringBuilder, DetailLevel.NORMAL);
            stringBuilder.append("}");
        }
        stringBuilder.append("}");
    }
}

